ServerEvents.recipes(event => {

    const tools = ['sword', 'pickaxe', 'shovel', 'crossbow', 'bow', 'axe', 'shield', 'helmet', 'chestplate', 'leggings', 'boots', 'horse_armor']

    tools.forEach(element => {
        event.smithing('upgradednetherite_creative:creative_upgraded_netherite_' + element, 'upgradednetherite_ultimate:ultimate_upgraded_netherite_' + element, 'upgradednetherite_creative:creative_upgraded_netherite_ingot')

    });

    event.smithing('upgradednetherite_items:creative_upgraded_netherite_totem', 'upgradednetherite_items:ultimate_upgraded_netherite_totem', 'upgradednetherite_creative:creative_upgraded_netherite_ingot')
    event.smithing('upgradedtools:creative_upgraded_netherite_hammer', 'upgradedtools:ultimate_upgraded_netherite_hammer', 'upgradednetherite_creative:creative_upgraded_netherite_ingot')



    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'ae2:fluid_storage_cell_256k'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'ae2:creative_fluid_cell',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'ae2:item_storage_cell_256k'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'ae2:creative_item_cell',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'appmek:chemical_storage_cell_256k'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'appmek:creative_chemical_cell',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'appbot:mana_storage_cell_256k'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'appbot:creative_mana_cell',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'ae2:dense_energy_cell'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'ae2:creative_energy_cell',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'solarflux:sp_8'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'createaddition:creative_energy',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'thermal_extra:rf_coil_xfer_augment_5'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'thermal:rf_coil_creative_augment',
                "count": 1
            }
        ],
        "energy": 1000000
    })

    event.custom({
        "type": "mekanism:combining",
        "extraInput": {
            "ingredient": {
                "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
            }
        },
        "mainInput": {
            "ingredient": {
                "item": 'mekanism:ultimate_chemical_tank'
            }
        },
        "output": {
            "item": 'mekanism:creative_chemical_tank'
        }
    })

    event.custom({
        "type": "mekanism:combining",
        "extraInput": {
            "ingredient": {
                "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
            }
        },
        "mainInput": {
            "ingredient": {
                "item": 'mekanism:ultimate_fluid_tank'
            }
        },
        "output": {
            "item": 'mekanism:creative_fluid_tank'
        }
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'thermal_extra:fluid_tank_augment_6'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'thermal:fluid_tank_creative_augment',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'thermal_extra:dynamo_output_augment_4'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'thermal:machine_efficiency_creative_augment',
                "count": 1
            }
        ],
        "energy": 1000000
    })
    event.custom({
        "type": "thermal:smelter",
        "ingredients": [
            {
                "value": [
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "count": 1
            },
            {
                "value": [
                    {
                        "item": 'thermal_extra:machine_catalyst_augment_3'
                    }
                ],
                "count": 1
            }
        ],
        "result": [
            {
                "item": 'thermal:machine_catalyst_creative_augment',
                "count": 1
            }
        ],
        "energy": 1000000
    })

    event.recipes.botania.runic_altar(Item.of('botania:mana_tablet', '{creative:1b,mana:500000}'), ['botania:mana_tablet', 'upgradednetherite_creative:creative_upgraded_netherite_ingot'], 1000000)
    event.recipes.botania.runic_altar('botania:creative_pool', ['botania:mana_pool', 'upgradednetherite_creative:creative_upgraded_netherite_ingot'], 1000000)

    event.custom({
        "type": "ars_nouveau:enchanting_apparatus",
        "count": 1,

        "output": {
            "item": 'ars_nouveau:creative_source_jar'
        },
        "pedestalItems": [
            {
                "item": {
                    "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                }
            }
        ],
        "reagent": [
            {
                "item": 'ars_nouveau:source_jar'
            }
        ],
        "source": 100000
    })
    event.custom({
        "type": "ars_nouveau:enchanting_apparatus",
        "count": 1,

        "output": {
            "item": 'ars_nouveau:creative_spell_book'
        },
        "pedestalItems": [
            {
                "item": {
                    "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                }
            }
        ],
        "reagent": [
            {
                "item": 'ars_nouveau:archmage_spell_book'
            }
        ],
        "source": 100000
    })

    event.custom({
        "type": "create:sequenced_assembly",
        "ingredient": {
            "item": 'createaddition:electric_motor'
        },
        "transitionalItem": {
            "item": 'createaddition:electric_motor'
        },
        "sequence": [

            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'createaddition:electric_motor'
                    },
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "results": [
                    {
                        "item": 'createaddition:electric_motor'
                    }
                ]
            }

        ],
        "results": [
            {
                "item": 'create:creative_motor'
            }
        ],
        "loops": 1
    })
    event.custom({
        "type": "create:sequenced_assembly",
        "ingredient": {
            "item": 'functionalstorage:netherite_upgrade'
        },
        "transitionalItem": {
            "item": 'functionalstorage:netherite_upgrade'
        },
        "sequence": [

            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'functionalstorage:netherite_upgrade'
                    },
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "results": [
                    {
                        "item": 'functionalstorage:netherite_upgrade'
                    }
                ]
            }

        ],
        "results": [
            {
                "item": 'functionalstorage:creative_vending_upgrade'
            }
        ],
        "loops": 1
    })
    event.custom({
        "type": "create:sequenced_assembly",
        "ingredient": {
            "item": 'pneumaticcraft:speed_upgrade'
        },
        "transitionalItem": {
            "item": 'pneumaticcraft:speed_upgrade'
        },
        "sequence": [

            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'pneumaticcraft:speed_upgrade'
                    },
                    {
                        "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot'
                    }
                ],
                "results": [
                    {
                        "item": 'pneumaticcraft:speed_upgrade'
                    }
                ]
            }

        ],
        "results": [
            {
                "item": 'pneumaticcraft:creative_upgrade'
            }
        ],
        "loops": 1
    })

    event.custom({
        "type": "create:mechanical_crafting",
        "pattern": [
            "  A  ",
            " BCD ",
            "EFGHI",
            " JKL ",
            "  M  "
        ],
        "key": {
            "A": {
                "item": 'cataclysm:burning_ashes'
            },
            "B": {
                "item": 'undergarden:masticator_scales'
            },
            "C": {
                "item": 'cataclysm:ignitium_ingot'
            },
            "D": {
                "item": 'bhc:soul_heart_canister'
            },
            "E": {
                "item": 'botanicadds:gaiasteel_ingot'
            },
            "F": {
                "item": 'allthemodium:allthemodium_ingot'
            },
            "G": {
                "item": 'upgradednetherite_ultimate:ultimate_upgraded_netherite_ingot'
            },
            "H": {
                "item": 'allthemodium:unobtainium_ingot'
            },
            "I": {
                "item": 'thermal_extra:twinite_ingot'
            },
            "J": {
                "item": 'create:creative_blaze_cake'
            },
            "K": {
                "item": 'allthemodium:vibranium_ingot'
            },
            "L": {
                "item": 'the_bumblezone:bee_stinger'
            },
            "M": {
                "item": 'minecraft:dragon_head'
            }
        },
        "result": {
            "item": 'upgradednetherite_creative:creative_upgraded_netherite_ingot',
            "count": 1
        },
        "acceptMirrored": false
    })


    event.custom({
        "type": "create:sequenced_assembly",
        "ingredient": {
            "item": 'thermal:chocolate_cake'
        },
        "transitionalItem": {
            "item": 'thermal:chocolate_cake'
        },
        "sequence": [
            //1

            //2

            //3
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'thermal:chocolate_cake'
                    },
                    {
                        "item": 'mekanism:pellet_polonium'
                    }
                ],
                "results": [
                    {
                        "item": 'thermal:chocolate_cake'
                    }
                ]
            },
            //4
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'thermal:chocolate_cake'
                    },
                    {
                        "item": 'deeperdarker:warden_carapace'
                    }
                ],
                "results": [
                    {
                        "item": 'thermal:chocolate_cake'
                    }
                ]
            },
            //5
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'thermal:chocolate_cake'
                    },
                    {
                        "item": 'evilcraft:condensed_blood'
                    }
                ],
                "results": [
                    {
                        "item": 'thermal:chocolate_cake'
                    }
                ]
            },
            //6
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'thermal:chocolate_cake'
                    },
                    {
                        "item": 'delightful:deluxe_cheeseburger'
                    }
                ],
                "results": [
                    {
                        "item": 'thermal:chocolate_cake'
                    }
                ]
            },


            {
                "type": "create:filling",
                "ingredients": [
                    {
                        "item": 'thermal:chocolate_cake'
                    },
                    {
                        "fluid": "industrialforegoing:ether_gas",
                        "nbt": {},
                        "amount": 5000
                    }
                ],
                "results": [
                    {
                        "item": 'thermal:chocolate_cake'
                    }
                ]
            },
            {
                "type": "create:deploying",
                "ingredients": [
                    {
                        "item": 'thermal:chocolate_cake'
                    },
                    {
                        "item": 'mysticalagradditions:creative_essence'
                    }
                ],
                "results": [
                    {
                        "item": 'thermal:chocolate_cake'
                    }
                ]
            }

        ],
        "results": [
            {
                "item": 'create:creative_blaze_cake'
            }
        ],
        "loops": 2
    })
    event.custom({
        "type": "ars_nouveau:enchanting_apparatus",
        "count": 1,

        "output": {
            "item": 'mysticalagradditions:creative_essence'
        },
        "pedestalItems": [
            {
                "item": {
                    "item": 'mysticalagriculture:awakened_supremium_gemstone'
                }
            },
            {
                "item": {
                    "item": 'mysticalagriculture:awakened_supremium_ingot'
                }
            },
            {
                "item": {
                    "item": 'mysticalagriculture:gaia_spirit_essence'
                }
            },
            {
                "item": {
                    "item": 'mysticalagriculture:netherite_essence'
                }
            },
            {
                "item": {
                    "item": 'ars_elemental:necrotic_focus'
                }
            },
            {
                "item": {
                    "item": 'deeperdarker:heart_of_the_deep'
                }
            },
            {
                "item": {
                    "item": 'mysticalagriculture:cognizant_dust'
                }
            },
            {
                "item": {
                    "item": 'stalwart_dungeons:void_crystal'
                }
            }
        ],
        "reagent": [
            {
                "item": 'mysticalagriculture:awakened_supremium_essence'
            }
        ],
        "source": 10000
    })

    event.remove({ id: 'mysticalagriculture:awakened_supremium_gemstone' })
    event.remove({ id: 'mysticalagriculture:awakened_supremium_ingot' })
    event.remove({ id: 'mysticalagriculture:awakened_supremium_block_awakening' })


    event.custom({
        "type": "botania:runic_altar",
        "ingredients": [
            {
                "item": 'botania:dragonstone'
            },
            {
                "item": 'mysticalagriculture:awakened_supremium_essence'
            },
            {
                "item": 'mysticalagriculture:awakened_supremium_essence'
            }
        ],
        "mana": 5000,
        "output": {
            "count": 1,
            "item": 'mysticalagriculture:awakened_supremium_gemstone'
        }
    })

    event.custom({
        "type": "botania:runic_altar",
        "ingredients": [
            {
                "item": 'botania:elementium_ingot'
            },
            {
                "item": 'mysticalagriculture:awakened_supremium_essence'
            },
            {
                "item": 'mysticalagriculture:awakened_supremium_essence'
            }
        ],
        "mana": 5000,
        "output": {
            "count": 1,
            "item": 'mysticalagriculture:awakened_supremium_ingot'
        }
    })
})