/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite_creative.handlers;

import com.rolfmao.upgradednetherite_creative.config.UpgradedNetheriteCreativeConfig;
import com.rolfmao.upgradednetherite_creative.utils.CreativeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite_creative", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HorseArmorEventHandler {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        Horse horse;
        if (event.getEntity() instanceof Horse && ((Horse)event.getEntity()).m_30614_() && CreativeUtil.isHorseWearingCreativeArmor(horse = (Horse)event.getEntity())) {
            if (!horse.m_21220_().isEmpty() && UpgradedNetheriteCreativeConfig.EnableCreativeNoHarmful) {
                Map activeEffects = horse.m_21221_();
                Iterator iterator = activeEffects.values().iterator();
                ArrayList<MobEffect> effectList = new ArrayList<MobEffect>();
                int i = 0;
                while (iterator.hasNext()) {
                    MobEffectInstance effect = (MobEffectInstance)iterator.next();
                    if (effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                        effectList.add(effect.m_19544_());
                    }
                    ++i;
                }
                for (i = 0; i < effectList.size(); ++i) {
                    horse.m_21195_((MobEffect)effectList.get(i));
                }
            }
            if (UpgradedNetheriteCreativeConfig.EnableCreativeHeal && horse.m_21223_() < horse.m_21233_()) {
                horse.m_5634_(1.0f);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onDamageEntity(LivingAttackEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Horse && CreativeUtil.isHorseWearingCreativeArmor((Horse)event.getEntity()) && UpgradedNetheriteCreativeConfig.EnableCreativeNoDamage && event.getSource() != DamageSource.f_19317_ && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onDamageEntity(LivingHurtEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Horse && CreativeUtil.isHorseWearingCreativeArmor((Horse)event.getEntity()) && UpgradedNetheriteCreativeConfig.EnableCreativeNoDamage && event.getSource() != DamageSource.f_19317_) {
            event.setAmount(0.0f);
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(MobEffectEvent.Added event) {
        if (event.getEntity() instanceof Horse && ((Horse)event.getEntity()).m_30614_()) {
            Horse horse = (Horse)event.getEntity();
            if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL && CreativeUtil.isHorseWearingCreativeArmor(horse) && UpgradedNetheriteCreativeConfig.EnableCreativeNoHarmful) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

