/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite_creative.handlers;

import com.rolfmao.upgradednetherite_creative.config.UpgradedNetheriteCreativeConfig;
import com.rolfmao.upgradednetherite_creative.utils.CreativeUtil;
import com.rolfmao.upgradednetherite_creative.utils.EntityDataUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgradednetherite_creative", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorEventHandler {
    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (CreativeUtil.isWearingCreativeArmor(player)) {
                if (UpgradedNetheriteCreativeConfig.EnableCreativeFlying) {
                    if (!player.m_150110_().f_35936_) {
                        player.m_150110_().f_35936_ = true;
                        EntityDataUtil.setAbilityFlying((Entity)player, true);
                    }
                    if (player.m_150110_().f_35935_ && UpgradedNetheriteCreativeConfig.EnableCreativeFlyNoClip) {
                        player.f_19794_ = true;
                        if (player.m_20089_() == Pose.SWIMMING) {
                            player.m_20124_(Pose.STANDING);
                        }
                    }
                }
                if (UpgradedNetheriteCreativeConfig.EnableCreativeSaturation) {
                    if (player.m_36324_().m_38702_() < 20) {
                        player.m_36324_().m_38705_(player.m_36324_().m_38702_() + 1);
                    } else if (player.m_36324_().m_38722_() < 20.0f) {
                        player.m_36324_().m_38717_(player.m_36324_().m_38722_() + 1.0f);
                    }
                }
                if (UpgradedNetheriteCreativeConfig.EnableCreativeHeal && player.m_21223_() < player.m_21233_()) {
                    player.m_5634_(1.0f);
                }
                if (UpgradedNetheriteCreativeConfig.EnableCreativeNoDamage && player.m_20146_() < player.m_6062_()) {
                    player.m_20301_(player.m_20146_() + 4);
                }
            } else if (EntityDataUtil.getAbilityFlying((Entity)player) && player.m_150110_().f_35936_) {
                EntityDataUtil.setAbilityFlying((Entity)player, false);
                if (!player.m_7500_()) {
                    player.m_150110_().f_35936_ = false;
                    if (player.m_150110_().f_35935_) {
                        player.m_150110_().f_35935_ = false;
                    }
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && CreativeUtil.isWearingCreativeArmor(player = (Player)event.getEntity()) && UpgradedNetheriteCreativeConfig.EnableCreativeNoHarmful) {
            CreativeUtil.cleanHarmfulEffects(player);
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.LOWEST)
    public static void onDamageEntity(LivingAttackEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (event.getEntity() instanceof Player && CreativeUtil.isWearingCreativeArmor((Player)event.getEntity()) && UpgradedNetheriteCreativeConfig.EnableCreativeNoDamage && event.getSource() != DamageSource.f_19317_) {
            event.getEntity().m_20095_();
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public void onApplyEffect(MobEffectEvent.Added event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL && CreativeUtil.isWearingCreativeArmor((Player)player) && UpgradedNetheriteCreativeConfig.EnableCreativeNoHarmful) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @OnlyIn(value=Dist.CLIENT)
    public void onOverlayRender(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type() && CreativeUtil.isWearingCreativeArmor((Player)mc.f_91074_) && UpgradedNetheriteCreativeConfig.EnableCreativeNoDamage && (double)mc.f_91074_.m_20146_() >= (double)mc.f_91074_.m_6062_() * 0.966) {
            event.setCanceled(true);
        }
    }
}

