/*
 * Decompiled with CFR 0.152.
 */
package com.rolfmao.upgradednetherite_creative.content;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.rolfmao.upgradednetherite_creative.config.UpgradedNetheriteCreativeConfig;
import com.rolfmao.upgradednetherite_creative.init.ModItems;
import com.rolfmao.upgradednetherite_creative.utils.CreativeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UpgradedNetheriteCrossbow
extends CrossbowItem {
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public UpgradedNetheriteCrossbow(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return Items.f_42418_.equals(repair.m_41720_());
    }

    public boolean isDamageable(ItemStack stack) {
        if (UpgradedNetheriteCreativeConfig.EnableCreativeUnbreakable && this.m_5456_() == ModItems.CREATIVE_UPGRADED_NETHERITE_CROSSBOW.get()) {
            return false;
        }
        return this.m_5456_().m_41465_();
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        ItemStack stack;
        if (this.m_220152_(tab) && CreativeUtil.isCreativeRangedWeapon(stack = new ItemStack((ItemLike)this))) {
            list.add((Object)stack);
        }
    }

    public Predicate<ItemStack> m_6442_() {
        return f_43006_;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (UpgradedNetheriteCrossbow.isCharged(itemstack)) {
            UpgradedNetheriteCrossbow.performShooting(level, (LivingEntity)player, interactionHand, itemstack, UpgradedNetheriteCrossbow.getShootingPower(itemstack), 1.0f);
            UpgradedNetheriteCrossbow.setCharged(itemstack, false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!player.m_6298_(itemstack).m_41619_()) {
            if (!UpgradedNetheriteCrossbow.isCharged(itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                player.m_6672_(interactionHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int timeLeft) {
        int i = this.m_8105_(itemStack) - timeLeft;
        float f = UpgradedNetheriteCrossbow.getPowerForTime(i, itemStack);
        if (f >= 1.0f && !UpgradedNetheriteCrossbow.isCharged(itemStack) && UpgradedNetheriteCrossbow.tryLoadProjectiles(livingEntity, itemStack)) {
            UpgradedNetheriteCrossbow.setCharged(itemStack, true);
            SoundSource soundcategory = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11841_, soundcategory, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity livingEntity, ItemStack itemStack) {
        int i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack);
        int j = i == 0 ? 1 : 3;
        boolean flag = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
        ItemStack itemstack = livingEntity.m_6298_(itemStack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (UpgradedNetheriteCrossbow.loadProjectile(livingEntity, itemStack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack1, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (itemStack1.m_41619_()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && itemStack1.m_41720_() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = itemStack1.m_41620_(1);
            if (itemStack1.m_41619_() && livingEntity instanceof Player) {
                ((Player)livingEntity).m_150109_().m_36057_(itemStack1);
            }
        } else {
            itemstack = itemStack1.m_41777_();
        }
        UpgradedNetheriteCrossbow.addChargedProjectile(itemStack, itemstack);
        return true;
    }

    public static boolean isCharged(ItemStack itemStack) {
        CompoundTag compoundnbt = itemStack.m_41783_();
        return compoundnbt != null && compoundnbt.m_128471_("Charged");
    }

    public static void setCharged(ItemStack itemStack, boolean p_220011_1_) {
        CompoundTag compoundnbt = itemStack.m_41784_();
        compoundnbt.m_128379_("Charged", p_220011_1_);
    }

    private static void addChargedProjectile(ItemStack itemStack, ItemStack itemStack1) {
        CompoundTag compoundnbt = itemStack.m_41784_();
        ListTag listnbt = compoundnbt.m_128425_("ChargedProjectiles", 9) ? compoundnbt.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundnbt1 = new CompoundTag();
        itemStack1.m_41739_(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.m_128365_("ChargedProjectiles", (Tag)listnbt);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack itemStack) {
        ListTag listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundnbt = itemStack.m_41783_();
        if (compoundnbt != null && compoundnbt.m_128425_("ChargedProjectiles", 9) && (listnbt = compoundnbt.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt1 = listnbt.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundnbt1));
            }
        }
        return list;
    }

    private static void clearChargedProjectiles(ItemStack itemStack) {
        CompoundTag compoundnbt = itemStack.m_41783_();
        if (compoundnbt != null) {
            ListTag listnbt = compoundnbt.m_128437_("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.m_128365_("ChargedProjectiles", (Tag)listnbt);
        }
    }

    private static void shootProjectile(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack itemStack, ItemStack itemStack1, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (livingEntity instanceof Player) {
            Player playerentity = (Player)livingEntity;
            if (!level.f_46443_) {
                AbstractArrow projectileentity;
                boolean flag;
                boolean bl = flag = itemStack1.m_41720_() == Items.f_42688_;
                if (flag) {
                    projectileentity = new FireworkRocketEntity(level, itemStack1, (Entity)livingEntity, livingEntity.m_20185_(), livingEntity.m_20188_() - (double)0.15f, livingEntity.m_20189_(), true);
                } else {
                    projectileentity = UpgradedNetheriteCrossbow.getArrow(level, livingEntity, itemStack, itemStack1);
                    if (p_220016_6_ || p_220016_9_ != 0.0f) {
                        projectileentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                }
                if (livingEntity instanceof CrossbowAttackMob) {
                    CrossbowAttackMob icrossbowuser = (CrossbowAttackMob)livingEntity;
                    icrossbowuser.m_5811_(icrossbowuser.m_5448_(), itemStack, (Projectile)projectileentity, p_220016_9_);
                } else {
                    Vec3 vec31 = livingEntity.m_20289_(1.0f);
                    Quaternion quaternion = new Quaternion(new Vector3f(vec31), p_220016_9_, true);
                    Vec3 vec3 = livingEntity.m_20252_(1.0f);
                    Vector3f vector3f = new Vector3f(vec3);
                    vector3f.m_122251_(quaternion);
                    projectileentity.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), p_220016_7_, p_220016_8_);
                }
                itemStack.m_41622_(flag ? 3 : 1, livingEntity, p_220017_1_ -> p_220017_1_.m_21190_(interactionHand));
                if (itemStack.m_41720_() == ModItems.CREATIVE_UPGRADED_NETHERITE_CROSSBOW.get()) {
                    projectileentity.m_20049_("CreativeUpgradedNetheriteBow");
                }
                level.m_7967_((Entity)projectileentity);
                level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, p_220016_5_);
            }
        }
    }

    private static AbstractArrow getArrow(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack1) {
        ArrowItem arrowitem = (ArrowItem)(itemStack1.m_41720_() instanceof ArrowItem ? itemStack1.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrowentity = arrowitem.m_6394_(level, itemStack1, livingEntity);
        if (livingEntity instanceof Player) {
            abstractarrowentity.m_36762_(true);
        }
        abstractarrowentity.m_36740_(SoundEvents.f_11840_);
        abstractarrowentity.m_36793_(true);
        int i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
        if (i > 0) {
            abstractarrowentity.m_36767_((byte)i);
        }
        return abstractarrowentity;
    }

    public static void performShooting(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack itemStack, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = UpgradedNetheriteCrossbow.getChargedProjectiles(itemStack);
        float[] afloat = UpgradedNetheriteCrossbow.getShotPitches(livingEntity.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                UpgradedNetheriteCrossbow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                UpgradedNetheriteCrossbow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            UpgradedNetheriteCrossbow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 10.0f);
        }
        UpgradedNetheriteCrossbow.onCrossbowShot(level, livingEntity, itemStack);
    }

    private static float[] getShotPitches(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, UpgradedNetheriteCrossbow.getRandomShotPitch(flag, random), UpgradedNetheriteCrossbow.getRandomShotPitch(!flag, random)};
    }

    private static float getRandomShotPitch(boolean p_220032_0_, RandomSource random) {
        float f = p_220032_0_ ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)livingEntity;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayerentity, itemStack);
            }
            serverplayerentity.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        }
        UpgradedNetheriteCrossbow.clearChargedProjectiles(itemStack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int p_219972_4_) {
        if (!level.f_46443_) {
            int i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
            SoundEvent soundevent = this.getStartSound(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(itemStack.m_41779_() - p_219972_4_) / (float)UpgradedNetheriteCrossbow.getChargeDuration(itemStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack p_77626_1_) {
        return UpgradedNetheriteCrossbow.getChargeDuration(p_77626_1_) + 3;
    }

    public static int getChargeDuration(ItemStack p_220026_0_) {
        int i = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44960_, (ItemStack)p_220026_0_);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.CROSSBOW;
    }

    private SoundEvent getStartSound(int p_220025_1_) {
        switch (p_220025_1_) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    private static float getPowerForTime(int p_220031_0_, ItemStack p_220031_1_) {
        float f = (float)p_220031_0_ / (float)UpgradedNetheriteCrossbow.getChargeDuration(p_220031_1_);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        List<ItemStack> list = UpgradedNetheriteCrossbow.getChargedProjectiles(itemStack);
        if (!UpgradedNetheriteCreativeConfig.DisableTooltips) {
            if (Screen.m_96638_()) {
                if (CreativeUtil.isCreativeRangedWeapon(itemStack) && UpgradedNetheriteCreativeConfig.EnableCreativeInstaKill) {
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Blank.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Bonus.TT"));
                    tooltip.add((Component)Component.m_237115_((String)"upgradednetherite_creative.Creative_Bonus_Weapon.TT"));
                }
            } else {
                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.Blank.TT"));
                tooltip.add((Component)Component.m_237115_((String)"upgradednetherite.HoldShift.TT"));
            }
        }
        if (UpgradedNetheriteCrossbow.isCharged(itemStack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            tooltip.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_130946_(" ").m_7220_(itemstack.m_41611_()));
            if (tooltipFlag.m_7050_() && itemstack.m_41720_() == Items.f_42688_) {
                ArrayList list1 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemstack, level, (List)list1, tooltipFlag);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list1.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.addAll(list1);
                }
            }
        }
    }

    private static float getShootingPower(ItemStack p_220013_0_) {
        return p_220013_0_.m_41720_() == Items.f_42717_ && UpgradedNetheriteCrossbow.m_40871_((ItemStack)p_220013_0_, (Item)Items.f_42688_) ? 2.4f : 4.725f;
    }

    public int m_6615_() {
        return 8;
    }
}

