/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.NameHelper;
import shetiphian.endertanks.client.misc.EventHandlerClient;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.network.NetworkHandler;
import shetiphian.endertanks.common.network.PacketTankInfo;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class TankInfoHelper {
    private static final Style GOLD = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
    private static final Style GRAY = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY));
    private static final Style GREEN = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
    private static final Style AQUA = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA));
    private static final Style BOLD_RED = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true));
    private static final MutableComponent DUMMY = Component.m_237113_((String)"");

    public static void unpackHUDInfo(List<Component> lines, ListTag listNBT) {
        listNBT.forEach(tag -> lines.add((Component)Component.Serializer.m_130701_((String)tag.m_7916_())));
    }

    public static StringTag toTag(Component entry) {
        return StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)entry));
    }

    public static ListTag packHUDBasic(TileEntityEnderTank tile) {
        ListTag listNBT = new ListTag();
        listNBT.add((Object)TankInfoHelper.toTag((Component)TankInfoHelper.infoTankOwner(tile.getOwnerName(), true, false)));
        listNBT.add((Object)TankInfoHelper.toTag((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.code")).m_7220_((Component)Component.m_237113_((String)(" " + tile.getCode())))));
        return listNBT;
    }

    public static ListTag packHUDContents(TileEntityEnderTank tile) {
        ListTag listNBT = new ListTag();
        for (Component component : tile.getEnderContainer().getContentsInfo(false)) {
            listNBT.add((Object)TankInfoHelper.toTag(component));
        }
        return listNBT;
    }

    public static ListTag packHUDStatus(TileEntityEnderTank tile) {
        ListTag listNBT = new ListTag();
        listNBT.add((Object)TankInfoHelper.toTag((Component)TankInfoHelper.infoPump(tile.getPumpCapacity()).m_6270_(GRAY)));
        listNBT.add((Object)TankInfoHelper.toTag((Component)Component.m_237113_((String)" ").m_7220_(tile.getComparatorTypeDisplayName()).m_7220_((Component)Component.m_237113_((String)(" " + tile.getComparatorOutput())))));
        return listNBT;
    }

    public static void sendTankInfo(Player player, String ownerName, String ownerID, String code, boolean sendAll) {
        TankInfoHelper.sendTankInfo(player, TankHelper.getTank(ownerID, code, player.m_9236_().m_5776_()).getContentsInfo(!sendAll), Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)("info.endertanks." + (sendAll ? "tank" : "bucket") + ".header")).m_130946_(":").m_6270_(GOLD)).m_7220_((Component)TankInfoHelper.infoTankOwner(ownerName, false, true)));
    }

    public static void sendTankInfo(Player player, TileEntityEnderTank tile) {
        TankInfoHelper.sendTankInfo(player, tile.getEnderContainer().getContentsInfo(false), Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.header").m_130946_(":").m_6270_(GOLD)).m_7220_((Component)TankInfoHelper.infoPump(tile.getPumpCapacity())).m_7220_((Component)TankInfoHelper.infoTankOwner(tile.getOwnerName(), false, true)));
    }

    private static void sendTankInfo(Player player, List<MutableComponent> contents, MutableComponent info) {
        if (contents.size() > 1) {
            contents.add(0, info);
            TankInfoHelper.sendInfo(player, contents.toArray(new MutableComponent[0]));
        } else if (contents.size() == 1) {
            TankInfoHelper.sendInfo(player, info.m_130946_(" ").m_7220_((Component)contents.get(0)));
        }
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderTank tankTile) {
        TankInfoHelper.sendInfo(player, Component.m_237115_((String)"info.endertanks.tank.capacity").m_130946_(" " + TankHelper.getTank(tankTile.getOwnerID(), tankTile.getCode(), tankTile.m_58904_().m_5776_()).getCapacity()));
    }

    public static void sendPumpInfo(Player player, TileEntityEnderTank tile) {
        TankInfoHelper.sendInfo(player, Component.m_237115_((String)"info.endertanks.tank.pump.upgrade").m_130946_(" " + tile.getPumpCapacity() + "mB"));
    }

    public static void sendLinkError(Player player, int error) {
        TankInfoHelper.sendInfo(player, Component.m_237115_((String)("error.endertanks.bucket.nolink" + error)).m_6270_(BOLD_RED));
    }

    public static void sendError(Player player, String error) {
        TankInfoHelper.sendInfo(player, Component.m_237115_((String)("error." + error)).m_6270_(BOLD_RED));
    }

    private static MutableComponent infoPump(int capacity) {
        if (capacity >= 1000) {
            return Component.m_237113_((String)(" " + (float)capacity / 1000.0f + "K mB ")).m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.pump"));
        }
        return Component.m_237113_((String)(" " + capacity + "mB ")).m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.pump"));
    }

    private static MutableComponent infoTankOwner(String owner, boolean displayPublic, boolean comma) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            if (displayPublic) {
                return Component.m_237113_((String)" [-").m_6270_(GOLD).m_7220_((Component)Component.m_237115_((String)"info.endertanks.tank.public")).m_7220_((Component)Component.m_237113_((String)"-]"));
            }
            return DUMMY;
        }
        boolean isTeam = owner.startsWith("#");
        return Component.m_237113_((String)((comma ? "," : "") + " [-")).m_6270_(isTeam ? GREEN : AQUA).m_7220_((Component)Component.m_237113_((String)ChatFormatting.m_126649_((String)owner.substring(isTeam ? 1 : 0)))).m_7220_((Component)Component.m_237113_((String)"-]"));
    }

    @Nullable
    public static MutableComponent formatTankOwner(String owner) {
        MutableComponent component = TankInfoHelper.infoTankOwner(owner, false, false);
        return component != DUMMY ? component : null;
    }

    public static void sendInfo(Player player, MutableComponent ... message) {
        if (player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(new PacketTankInfo((Component[])message), (ServerPlayer)player);
        } else {
            EventHandlerClient.setDelayedMessage((Component[])message);
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

