/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.AllKeys;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBoundary;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroup;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrackGraphVisualizer {
    public static void visualiseSignalEdgeGroups(TrackGraph graph) {
        Minecraft mc = Minecraft.m_91087_();
        Entity cameraEntity = mc.f_91075_;
        if (cameraEntity == null) {
            return;
        }
        AABB box = graph.getBounds((Level)mc.f_91073_).box;
        if (box == null || !box.m_82381_(cameraEntity.m_20191_().m_82400_(50.0))) {
            return;
        }
        Vec3 camera = cameraEntity.m_146892_();
        Outliner outliner = CreateClient.OUTLINER;
        boolean ctrl = false;
        Map<UUID, SignalEdgeGroup> allGroups = Create.RAILWAYS.sided(null).signalEdgeGroups;
        float width = 0.125f;
        for (Map.Entry<TrackNodeLocation, TrackNode> nodeEntry : graph.nodes.entrySet()) {
            Map<TrackNode, TrackEdge> map;
            Vec3 location;
            TrackNodeLocation nodeLocation = nodeEntry.getKey();
            TrackNode node = nodeEntry.getValue();
            if (nodeLocation == null || (location = nodeLocation.getLocation()).m_82554_(camera) > 50.0 || !mc.f_91073_.m_46472_().equals(nodeLocation.dimension) || (map = graph.connectionsByNode.get(node)) == null) continue;
            int hashCode = node.hashCode();
            for (Map.Entry<TrackNode, TrackEdge> entry : map.entrySet()) {
                UUID singleGroup;
                SignalEdgeGroup singleEdgeGroup;
                TrackNode other = entry.getKey();
                TrackEdge edge = entry.getValue();
                EdgeData signalData = edge.getEdgeData();
                if (!edge.node1.location.dimension.equals(edge.node2.location.dimension) || other.hashCode() > hashCode && other.location.getLocation().m_82554_(camera) <= 50.0) continue;
                Vec3 yOffset = new Vec3(0.0, (double)((float)(other.hashCode() > hashCode ? 6 : 5) / 64.0f), 0.0);
                Vec3 startPoint = edge.getPosition(0.0);
                Vec3 endPoint = edge.getPosition(1.0);
                if (!edge.isTurn()) {
                    if (signalData.hasSignalBoundaries()) {
                        double prev = 0.0;
                        double length = edge.getLength();
                        SignalBoundary prevBoundary = null;
                        SignalEdgeGroup group = null;
                        for (TrackEdgePoint trackEdgePoint : signalData.getPoints()) {
                            SignalBoundary boundary;
                            if (!(trackEdgePoint instanceof SignalBoundary)) continue;
                            prevBoundary = boundary = (SignalBoundary)trackEdgePoint;
                            group = allGroups.get(boundary.getGroup(node));
                            if (group == null) continue;
                            Vec3 vec3 = edge.getPosition(prev + (prev == 0.0 ? 0.0 : 0.0625 / length)).m_82549_(yOffset);
                            prev = boundary.getLocationOn(edge) / length;
                            outliner.showLine(Pair.of(boundary, edge), vec3, edge.getPosition(prev - 0.0625 / length).m_82549_(yOffset)).colored(group.color.get()).lineWidth(width);
                        }
                        if (prevBoundary != null) {
                            group = allGroups.get(prevBoundary.getGroup(other));
                            if (group == null) continue;
                            outliner.showLine(edge, edge.getPosition(prev + 0.0625 / length).m_82549_(yOffset), endPoint.m_82549_(yOffset)).colored(group.color.get()).lineWidth(width);
                            continue;
                        }
                    }
                    SignalEdgeGroup signalEdgeGroup = singleEdgeGroup = (singleGroup = signalData.getEffectiveEdgeGroupId(graph)) == null ? null : allGroups.get(singleGroup);
                    if (singleEdgeGroup == null) continue;
                    outliner.showLine(edge, startPoint.m_82549_(yOffset), endPoint.m_82549_(yOffset)).colored(singleEdgeGroup.color.get()).lineWidth(width);
                    continue;
                }
                if (signalData.hasSignalBoundaries()) {
                    SignalEdgeGroup initialGroup;
                    UUID initialGroupId;
                    Iterator<TrackEdgePoint> points = signalData.getPoints().iterator();
                    SignalBoundary currentBoundary = null;
                    double currentBoundaryPosition = 0.0;
                    while (points.hasNext()) {
                        SignalBoundary signal;
                        TrackEdgePoint next = points.next();
                        if (!(next instanceof SignalBoundary)) continue;
                        currentBoundary = signal = (SignalBoundary)next;
                        currentBoundaryPosition = signal.getLocationOn(edge);
                        break;
                    }
                    if (currentBoundary == null || (initialGroupId = currentBoundary.getGroup(node)) == null || (initialGroup = allGroups.get(initialGroupId)) == null) continue;
                    Color currentColour = initialGroup.color.get();
                    Vec3 previous = null;
                    BezierConnection turn = edge.getTurn();
                    for (int i = 0; i <= turn.getSegmentCount(); ++i) {
                        double f = (float)i * 1.0f / (float)turn.getSegmentCount();
                        double position = f * turn.getLength();
                        Vec3 current = edge.getPosition(f);
                        if (previous != null) {
                            if (currentBoundary != null && position > currentBoundaryPosition) {
                                current = edge.getPosition((currentBoundaryPosition - (double)width) / turn.getLength());
                                outliner.showLine(Pair.of(edge, previous), previous.m_82549_(yOffset), current.m_82549_(yOffset)).colored(currentColour).lineWidth(width);
                                previous = current = edge.getPosition((currentBoundaryPosition + (double)width) / turn.getLength());
                                UUID newId = currentBoundary.getGroup(other);
                                if (newId != null && allGroups.containsKey(newId)) {
                                    currentColour = allGroups.get((Object)newId).color.get();
                                }
                                currentBoundary = null;
                                while (points.hasNext()) {
                                    SignalBoundary signal;
                                    TrackEdgePoint next = points.next();
                                    if (!(next instanceof SignalBoundary)) continue;
                                    currentBoundary = signal = (SignalBoundary)next;
                                    currentBoundaryPosition = signal.getLocationOn(edge);
                                    break;
                                }
                            }
                            outliner.showLine(Pair.of(edge, previous), previous.m_82549_(yOffset), current.m_82549_(yOffset)).colored(currentColour).lineWidth(width);
                        }
                        previous = current;
                    }
                }
                SignalEdgeGroup signalEdgeGroup = singleEdgeGroup = (singleGroup = signalData.getEffectiveEdgeGroupId(graph)) == null ? null : allGroups.get(singleGroup);
                if (singleEdgeGroup == null) continue;
                Vec3 previous = null;
                BezierConnection turn = edge.getTurn();
                for (int i = 0; i <= turn.getSegmentCount(); ++i) {
                    Vec3 current = edge.getPosition((float)i * 1.0f / (float)turn.getSegmentCount());
                    if (previous != null) {
                        outliner.showLine(Pair.of(edge, previous), previous.m_82549_(yOffset), current.m_82549_(yOffset)).colored(singleEdgeGroup.color.get()).lineWidth(width);
                    }
                    previous = current;
                }
            }
        }
    }

    public static void debugViewGraph(TrackGraph graph) {
        Minecraft mc = Minecraft.m_91087_();
        Entity cameraEntity = mc.f_91075_;
        if (cameraEntity == null) {
            return;
        }
        AABB box = graph.getBounds((Level)mc.f_91073_).box;
        if (box == null || !box.m_82381_(cameraEntity.m_20191_().m_82400_(50.0))) {
            return;
        }
        Vec3 camera = cameraEntity.m_146892_();
        for (Map.Entry<TrackNodeLocation, TrackNode> nodeEntry : graph.nodes.entrySet()) {
            Vec3 location;
            TrackNodeLocation nodeLocation = nodeEntry.getKey();
            TrackNode node = nodeEntry.getValue();
            if (nodeLocation == null || (location = nodeLocation.getLocation()).m_82554_(camera) > 50.0 || !mc.f_91073_.m_46472_().equals(nodeLocation.dimension)) continue;
            Vec3 yOffset = new Vec3(0.0, 0.1875, 0.0);
            Vec3 v1 = location.m_82549_(yOffset);
            Vec3 v2 = v1.m_82549_(node.normal.m_82490_(0.1875));
            CreateClient.OUTLINER.showLine(node.netId, v1, v2).colored(Color.mixColors(Color.WHITE, graph.color, 1.0f)).lineWidth(0.125f);
            Map<TrackNode, TrackEdge> map = graph.connectionsByNode.get(node);
            if (map == null) continue;
            int hashCode = node.hashCode();
            for (Map.Entry<TrackNode, TrackEdge> entry : map.entrySet()) {
                TrackNode other = entry.getKey();
                TrackEdge edge = entry.getValue();
                if (!edge.node1.location.dimension.equals(edge.node2.location.dimension)) {
                    v1 = location.m_82549_(yOffset);
                    v2 = v1.m_82549_(node.normal.m_82490_(0.1875));
                    CreateClient.OUTLINER.showLine(node.netId, v1, v2).colored(Color.mixColors(Color.WHITE, graph.color, 1.0f)).lineWidth(0.25f);
                    continue;
                }
                if (other.hashCode() > hashCode && !AllKeys.isKeyDown(341)) continue;
                yOffset = new Vec3(0.0, (double)((float)(other.hashCode() > hashCode ? 6 : 4) / 16.0f), 0.0);
                if (!edge.isTurn()) {
                    CreateClient.OUTLINER.showLine(edge, edge.getPosition(0.0).m_82549_(yOffset), edge.getPosition(1.0).m_82549_(yOffset)).colored(graph.color).lineWidth(0.0625f);
                    continue;
                }
                Vec3 previous = null;
                BezierConnection turn = edge.getTurn();
                for (int i = 0; i <= turn.getSegmentCount(); ++i) {
                    Vec3 current = edge.getPosition((float)i * 1.0f / (float)turn.getSegmentCount());
                    if (previous != null) {
                        CreateClient.OUTLINER.showLine(Pair.of(edge, previous), previous.m_82549_(yOffset), current.m_82549_(yOffset)).colored(graph.color).lineWidth(0.0625f);
                    }
                    previous = current;
                }
            }
        }
    }
}

