/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.curiosities.zapper.ConfigureZapperPacket;
import com.simibubi.create.content.curiosities.zapper.PlacementPatterns;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.Vector;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ZapperScreen
extends AbstractSimiScreen {
    protected final Component patternSection = Lang.translateDirect("gui.terrainzapper.patternSection", new Object[0]);
    protected AllGuiTextures background;
    protected ItemStack zapper;
    protected InteractionHand hand;
    protected float animationProgress;
    protected Component f_96539_;
    protected Vector<IconButton> patternButtons = new Vector(6);
    private IconButton confirmButton;
    protected int brightColor;
    protected int fontColor;
    protected PlacementPatterns currentPattern;

    public ZapperScreen(AllGuiTextures background, ItemStack zapper, InteractionHand hand) {
        this.background = background;
        this.zapper = zapper;
        this.hand = hand;
        this.f_96539_ = Components.immutableEmpty();
        this.brightColor = 0xFEFEFE;
        this.fontColor = 5726074;
        CompoundTag nbt = zapper.m_41784_();
        this.currentPattern = NBTHelper.readEnum(nbt, "Pattern", PlacementPatterns.class);
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height);
        this.setWindowOffset(-10, 0);
        super.m_7856_();
        this.animationProgress = 0.0f;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.m_7379_());
        this.m_142416_(this.confirmButton);
        this.patternButtons.clear();
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                IconButton patternButton = new IconButton(x + this.background.width - 76 + col * 18, y + 21 + row * 18, pattern.icon);
                patternButton.withCallback(() -> {
                    this.patternButtons.forEach(b -> {
                        b.f_93623_ = true;
                    });
                    patternButton.f_93623_ = false;
                    this.currentPattern = pattern;
                });
                patternButton.setToolTip((Component)Lang.translateDirect("gui.terrainzapper.pattern." + pattern.translationKey, new Object[0]));
                this.patternButtons.add(patternButton);
            }
        }
        this.patternButtons.get((int)this.currentPattern.ordinal()).f_93623_ = false;
        this.addRenderableWidgets(this.patternButtons);
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(ms, x, y, (GuiComponent)this);
        this.drawOnBackground(ms, x, y);
        this.renderBlock(ms, x, y);
        this.renderZapper(ms, x, y);
    }

    protected void drawOnBackground(PoseStack ms, int x, int y) {
        this.f_96547_.m_92889_(ms, this.f_96539_, (float)(x + 11), (float)(y + 4), 5513551);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.animationProgress += 5.0f;
    }

    public void m_7861_() {
        ConfigureZapperPacket packet = this.getConfigurationPacket();
        packet.configureZapper(this.zapper);
        AllPackets.channel.sendToServer((Object)packet);
    }

    protected void renderZapper(PoseStack ms, int x, int y) {
        ((RenderElement)GuiGameElement.of(this.zapper).scale(4.0).at(x + this.background.width, y + this.background.height - 48, -200.0f)).render(ms);
    }

    protected void renderBlock(PoseStack ms, int x, int y) {
        ms.m_85836_();
        ms.m_85837_((double)(x + 32), (double)(y + 42), 120.0);
        ms.m_85845_(new Vector3f(1.0f, 0.0f, 0.0f).m_122240_(-25.0f));
        ms.m_85845_(new Vector3f(0.0f, 1.0f, 0.0f).m_122240_(-45.0f));
        ms.m_85841_(20.0f, 20.0f, 20.0f);
        BlockState state = Blocks.f_50016_.m_49966_();
        if (this.zapper.m_41782_() && this.zapper.m_41783_().m_128441_("BlockUsed")) {
            state = NbtUtils.m_129241_((CompoundTag)this.zapper.m_41783_().m_128469_("BlockUsed"));
        }
        GuiGameElement.of(state).render(ms);
        ms.m_85849_();
    }

    protected abstract ConfigureZapperPacket getConfigurationPacket();
}

