/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.curiosities.toolbox.RadialToolboxMenu;
import com.simibubi.create.content.curiosities.toolbox.ToolboxEquipPacket;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class ToolboxHandlerClient {
    public static final IGuiOverlay OVERLAY = ToolboxHandlerClient::renderOverlay;
    static int COOLDOWN = 0;

    public static void clientTick() {
        if (COOLDOWN > 0 && !AllKeys.TOOLBELT.isPressed()) {
            --COOLDOWN;
        }
    }

    public static boolean onPickItem() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return false;
        }
        Level level = player.f_19853_;
        HitResult hitResult = mc.f_91077_;
        if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        if (player.m_7500_()) {
            return false;
        }
        ItemStack result = ItemStack.f_41583_;
        List<ToolboxTileEntity> toolboxes = ToolboxHandler.getNearest((LevelAccessor)player.f_19853_, (Player)player, 8);
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = ((BlockHitResult)hitResult).m_82425_();
            BlockState state = level.m_8055_(pos);
            if (state.m_60767_() == Material.f_76296_) {
                return false;
            }
            result = state.getCloneItemStack(hitResult, (BlockGetter)level, pos, (Player)player);
        } else if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)hitResult).m_82443_();
            result = entity.getPickedResult(hitResult);
        }
        if (result.m_41619_()) {
            return false;
        }
        for (ToolboxTileEntity toolboxTileEntity : toolboxes) {
            ToolboxInventory inventory = toolboxTileEntity.inventory;
            for (int comp = 0; comp < 8; ++comp) {
                ItemStack inSlot = inventory.takeFromCompartment(1, comp, true);
                if (inSlot.m_41619_() || inSlot.m_41720_() != result.m_41720_() || !ItemStack.m_41658_((ItemStack)inSlot, (ItemStack)result)) continue;
                AllPackets.channel.sendToServer((Object)new ToolboxEquipPacket(toolboxTileEntity.m_58899_(), comp, player.m_150109_().f_35977_));
                return true;
            }
        }
        return false;
    }

    public static void onKeyInput(int key, boolean pressed) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91072_ == null || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        if (key != AllKeys.TOOLBELT.getBoundCode()) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        List<ToolboxTileEntity> toolboxes = ToolboxHandler.getNearest((LevelAccessor)player.f_19853_, (Player)player, 8);
        toolboxes.sort(Comparator.comparing(ToolboxTileEntity::getUniqueId));
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        String slotKey = String.valueOf(player.m_150109_().f_35977_);
        boolean equipped = compound.m_128441_(slotKey);
        if (equipped) {
            BlockEntity blockEntity;
            boolean canReachToolbox;
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(slotKey).m_128469_("Pos"));
            double max = ToolboxHandler.getMaxRange((Player)player);
            boolean bl = canReachToolbox = ToolboxHandler.distance(player.m_20182_(), pos) < max * max;
            if (canReachToolbox && (blockEntity = level.m_7702_(pos)) instanceof ToolboxTileEntity) {
                RadialToolboxMenu screen = new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP, (ToolboxTileEntity)blockEntity);
                screen.prevSlot(compound.m_128469_(slotKey).m_128451_("Slot"));
                ScreenOpener.open(screen);
                return;
            }
            ScreenOpener.open(new RadialToolboxMenu((List<ToolboxTileEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH, null));
            return;
        }
        if (toolboxes.isEmpty()) {
            return;
        }
        if (toolboxes.size() == 1) {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM, toolboxes.get(0)));
        } else {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_BOX, null));
        }
    }

    public static void renderOverlay(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        int x = width / 2 - 90;
        int y = height - 23;
        RenderSystem.m_69482_();
        LocalPlayer player = mc.f_91074_;
        CompoundTag persistentData = player.getPersistentData();
        if (!persistentData.m_128441_("CreateToolboxData")) {
            return;
        }
        CompoundTag compound = player.getPersistentData().m_128469_("CreateToolboxData");
        if (compound.m_128456_()) {
            return;
        }
        poseStack.m_85836_();
        for (int slot = 0; slot < 9; ++slot) {
            int offset;
            String key = String.valueOf(slot);
            if (!compound.m_128441_(key)) continue;
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(key).m_128469_("Pos"));
            double max = ToolboxHandler.getMaxRange((Player)player);
            boolean selected = player.m_150109_().f_35977_ == slot;
            int n = offset = selected ? 1 : 0;
            AllGuiTextures texture = ToolboxHandler.distance(player.m_20182_(), pos) < max * max ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
            texture.render(poseStack, x + 20 * slot - offset, y + offset);
        }
        poseStack.m_85849_();
    }
}

