/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.actors.HarvesterBlock;
import com.simibubi.create.content.contraptions.components.actors.HarvesterTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HarvesterRenderer
extends SafeTileEntityRenderer<HarvesterTileEntity> {
    public HarvesterRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(HarvesterTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = te.m_58900_();
        SuperByteBuffer superBuffer = CachedBufferer.partial(AllBlockPartials.HARVESTER_BLADE, blockState);
        HarvesterRenderer.transform(te.m_58904_(), (Direction)blockState.m_61143_((Property)HarvesterBlock.f_54117_), superBuffer, te.getAnimatedSpeed());
        superBuffer.light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffers) {
        float speed;
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        SuperByteBuffer superBuffer = CachedBufferer.partial(AllBlockPartials.HARVESTER_BLADE, blockState);
        float f = speed = !VecHelper.isVecPointingTowards(context.relativeMotion, facing.m_122424_()) ? context.getAnimationSpeed() : 0.0f;
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        superBuffer.transform(matrices.getModel());
        HarvesterRenderer.transform(context.world, facing, superBuffer, speed);
        superBuffer.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffers.m_6299_(RenderType.m_110457_()));
    }

    public static void transform(Level world, Direction facing, SuperByteBuffer superBuffer, float speed) {
        float originOffset = 0.0625f;
        Vec3 rotOffset = new Vec3(0.0, (double)(-2.0f * originOffset), (double)originOffset).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_));
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)world) / 20.0f;
        float angle = time * speed % 360.0f;
        ((SuperByteBuffer)superBuffer.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(facing))).translate(rotOffset.f_82479_, rotOffset.f_82480_, rotOffset.f_82481_).rotate(Direction.WEST, AngleHelper.rad(angle))).translate(-rotOffset.f_82479_, -rotOffset.f_82480_, -rotOffset.f_82481_);
    }
}

