/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import it.unimi.dsi.fastutil.floats.FloatConsumer;
import it.zerono.mods.zerocore.lib.functional.FloatSupplier;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;

public class FloadData
implements IContainerData {
    private final FloatSupplier _getter;
    private final FloatConsumer _setter;
    private float _lastValue;

    public FloadData(FloatSupplier getter, FloatConsumer setter) {
        this._getter = getter;
        this._setter = setter;
        this._lastValue = 0.0f;
    }

    public static FloadData wrap(float[] array, int index) {
        return new FloadData(() -> array[index], v -> {
            array[index] = v;
        });
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        float current = this._getter.getAsFloat();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.writeFloat(this._getter.getAsFloat());
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this._setter.accept(dataSource.readFloat());
    }
}

