/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.AbstractModRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;

public class ManyToOneRecipeBuilder<IngredientT, Result, RecipeIngredient extends IRecipeIngredient<IngredientT>, RecipeResult extends IRecipeResult<Result>>
extends AbstractModRecipeBuilder<ManyToOneRecipeBuilder<IngredientT, Result, RecipeIngredient, RecipeResult>> {
    private final List<RecipeIngredient> _ingredients;
    private final RecipeResult _result;
    private final IntFunction<String> _jsonIngredientsLabelsSupplier;

    public ManyToOneRecipeBuilder(ResourceLocation serializerId, RecipeResult result, IntFunction<String> jsonIngredientsLabelsSupplier) {
        super(serializerId);
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0, (Object)"A result cannot be empty");
        this._ingredients = new ObjectArrayList(4);
        this._result = result;
        this._jsonIngredientsLabelsSupplier = jsonIngredientsLabelsSupplier;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, this._result.getId());
    }

    public void addIngredient(RecipeIngredient ingredient) {
        Preconditions.checkArgument((!ingredient.isEmpty() ? 1 : 0) != 0, (Object)"An ingredient cannot be empty");
        this._ingredients.add(ingredient);
    }

    @Override
    protected FinishedRecipe getFinishedRecipe(ResourceLocation id) {
        return new ManyToOneRecipeBuilderFinishedRecipe(id);
    }

    public class ManyToOneRecipeBuilderFinishedRecipe
    extends AbstractModRecipeBuilder.AbstractFinishedRecipe {
        protected ManyToOneRecipeBuilderFinishedRecipe(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(JsonObject json) {
            int count = ManyToOneRecipeBuilder.this._ingredients.size();
            for (int idx = 0; idx < count; ++idx) {
                json.add(ManyToOneRecipeBuilder.this._jsonIngredientsLabelsSupplier.apply(idx), ((IRecipeIngredient)ManyToOneRecipeBuilder.this._ingredients.get(idx)).serializeTo());
            }
            json.add("result", ManyToOneRecipeBuilder.this._result.serializeTo());
        }
    }
}

