/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.layout;

import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.layout.AbstractLayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.HorizontalAlignment;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.layout.VerticalAlignment;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;

public class TabularLayoutEngine
extends AbstractLayoutEngine<TabularLayoutEngine> {
    public static final TabularLayoutHint DEFAULT_HINT = new TabularLayoutHint();
    final List<IntUnaryOperator> _columnDefinition;
    final List<IntUnaryOperator> _rowDefinition;

    public static Builder builder() {
        return new Builder();
    }

    public static TabularLayoutHint.Builder hintBuilder() {
        return new TabularLayoutHint.Builder();
    }

    @Override
    public void layout(IControlContainer controlsContainer) {
        new CellLayout(this._columnDefinition, this._rowDefinition, controlsContainer.getBounds()).layout(controlsContainer);
    }

    private static IntUnaryOperator sizeDefinition(int pixel) {
        return $ -> pixel;
    }

    private static IntUnaryOperator sizeDefinition(double percentage) {
        return $ -> (int)((double)$ * percentage);
    }

    private TabularLayoutEngine(List<IntUnaryOperator> columnDefinition, List<IntUnaryOperator> rowDefinition) {
        this._columnDefinition = columnDefinition;
        this._rowDefinition = rowDefinition;
    }

    private static int cellSize(int index, int span, int tableSize, List<IntUnaryOperator> definition) {
        if (1 == span) {
            return definition.get(index).applyAsInt(tableSize);
        }
        int sum = 0;
        for (int i = 0; i < span; ++i) {
            sum += definition.get(index + i).applyAsInt(tableSize);
        }
        return sum;
    }

    public static class Builder {
        int _columnsCount = -1;
        int _rowsCount = -1;
        List<IntUnaryOperator> _columnDefinition;
        List<IntUnaryOperator> _rowDefinition;

        Builder() {
        }

        public TabularLayoutEngine build() {
            return (TabularLayoutEngine)new TabularLayoutEngine(this._columnDefinition, this._rowDefinition).setZeroMargins();
        }

        public Builder columns(int count, int ... sizesInPixels) {
            this.validateColumns(count);
            this.validateSizes(count, sizesInPixels);
            this._columnsCount = count;
            this._columnDefinition = Builder.buildDefinition(sizesInPixels);
            return this;
        }

        public Builder columns(int count, double ... sizesInPercentage) {
            this.validateColumns(count);
            this.validatePercentages(count, sizesInPercentage);
            this._columnsCount = count;
            this._columnDefinition = Builder.buildDefinition(sizesInPercentage);
            return this;
        }

        public Builder columns(int count) {
            this.validateColumns(count);
            double[] percentages = new double[count];
            Arrays.fill(percentages, 1.0 / (double)count);
            this._columnsCount = count;
            this._columnDefinition = Builder.buildDefinition(percentages);
            return this;
        }

        public Builder rows(int count, int ... sizesInPixels) {
            this.validateRows(count);
            this.validateSizes(count, sizesInPixels);
            this._rowsCount = count;
            this._rowDefinition = Builder.buildDefinition(sizesInPixels);
            return this;
        }

        public Builder rows(int count) {
            this.validateRows(count);
            double[] percentages = new double[count];
            Arrays.fill(percentages, 1.0 / (double)count);
            this._rowsCount = count;
            this._rowDefinition = Builder.buildDefinition(percentages);
            return this;
        }

        public Builder rows(int count, double ... sizesInPercentage) {
            this.validateRows(count);
            this.validatePercentages(count, sizesInPercentage);
            this._rowsCount = count;
            this._rowDefinition = Builder.buildDefinition(sizesInPercentage);
            return this;
        }

        private void validateColumns(int count) {
            if (this._columnsCount > 0) {
                throw new IllegalStateException("Columns were already defined");
            }
            if (count <= 0) {
                throw new IllegalArgumentException("The number of columns must be greater than zero");
            }
        }

        private void validateRows(int count) {
            if (this._rowsCount > 0) {
                throw new IllegalStateException("Rows were already defined");
            }
            if (count <= 0) {
                throw new IllegalArgumentException("The number of rows must be greater than zero");
            }
        }

        private void validateSizes(int count, int[] pixels) {
            if (count != pixels.length) {
                throw new IllegalArgumentException("Invalid number of sizes passed in");
            }
            for (int pixel : pixels) {
                if (pixel > 0) continue;
                throw new IllegalArgumentException("Every size must be greater than zero");
            }
        }

        private void validatePercentages(int count, double[] percentages) {
            if (count != percentages.length) {
                throw new IllegalArgumentException("Invalid number of percentages passed in");
            }
            for (double percentage : percentages) {
                if (!(percentage <= 0.0)) continue;
                throw new IllegalArgumentException("Every percentage must be greater than zero");
            }
        }

        private static List<IntUnaryOperator> buildDefinition(int[] pixels) {
            return Arrays.stream(pixels).mapToObj(TabularLayoutEngine::sizeDefinition).collect(Collectors.toList());
        }

        private static List<IntUnaryOperator> buildDefinition(double[] percentages) {
            return Arrays.stream(percentages).mapToObj(TabularLayoutEngine::sizeDefinition).collect(Collectors.toList());
        }
    }

    private static class TabularLayoutHint
    implements ILayoutEngine.ILayoutEngineHint {
        private final int CellColumnsSpan;
        private final int CellRowsSpan;
        private final HorizontalAlignment CellHorizontalAlignment;
        private final VerticalAlignment CellVerticalAlignment;
        private final Padding CellPadding;

        private TabularLayoutHint() {
            this(1, 1, HorizontalAlignment.Center, VerticalAlignment.Center, Padding.ZERO);
        }

        TabularLayoutHint(int colSpan, int rowSpan, HorizontalAlignment hAlign, VerticalAlignment vAlign, Padding padding) {
            this.CellColumnsSpan = colSpan;
            this.CellRowsSpan = rowSpan;
            this.CellHorizontalAlignment = hAlign;
            this.CellVerticalAlignment = vAlign;
            this.CellPadding = padding;
        }

        public static class Builder {
            private int _columnsSpan = 1;
            private int _rowsSpan = 1;
            private HorizontalAlignment _horizontalAlignment = HorizontalAlignment.Center;
            private VerticalAlignment _verticalAlignment = VerticalAlignment.Center;
            private Padding _padding = Padding.ZERO;

            Builder() {
            }

            public TabularLayoutHint build() {
                return new TabularLayoutHint(this._columnsSpan, this._rowsSpan, this._horizontalAlignment, this._verticalAlignment, this._padding);
            }

            public Builder setColumnsSpan(int span) {
                this._columnsSpan = span;
                return this;
            }

            public Builder setRowsSpan(int span) {
                this._rowsSpan = span;
                return this;
            }

            public Builder setHorizontalAlignment(HorizontalAlignment alignment) {
                this._horizontalAlignment = alignment;
                return this;
            }

            public Builder setVerticalAlignment(VerticalAlignment alignment) {
                this._verticalAlignment = alignment;
                return this;
            }

            public Builder setPadding(Padding padding) {
                this._padding = padding;
                return this;
            }
        }
    }

    private class CellLayout {
        private final boolean[][] _filledCells;
        private final int _maxColumns;
        private final int _maxRows;
        private final Rectangle _tableBounds;
        private final List<IntUnaryOperator> _columns;
        private final List<IntUnaryOperator> _rows;
        private int _currentColumn;
        private int _currentRow;
        private int _cellX;
        private int _cellY;
        private int _columnSpanApplied;
        private int _rowSpanApplied;

        public CellLayout(List<IntUnaryOperator> columns, List<IntUnaryOperator> rows, Rectangle tableBounds) {
            this._columns = columns;
            this._maxColumns = columns.size();
            this._rows = rows;
            this._maxRows = rows.size();
            this._filledCells = new boolean[this._maxRows][this._maxColumns];
            this._tableBounds = tableBounds;
            this._currentRow = 0;
            this._currentColumn = 0;
            this._cellY = 0;
            this._cellX = 0;
            this._rowSpanApplied = 1;
            this._columnSpanApplied = 1;
        }

        public void layout(IControlContainer controlsContainer) {
            for (IControl control : controlsContainer) {
                if (this.placeControl(control)) continue;
                return;
            }
        }

        private boolean placeControl(IControl control) {
            int columnSpan;
            int rowSpan;
            TabularLayoutHint hint = control.getLayoutEngineHint().filter(h -> h instanceof TabularLayoutHint).map(h -> (TabularLayoutHint)h).orElse(DEFAULT_HINT);
            int n = rowSpan = this._currentRow + hint.CellRowsSpan <= this._maxRows ? hint.CellRowsSpan : Math.min(0, this._maxRows - this._currentRow);
            for (columnSpan = this._currentColumn + hint.CellColumnsSpan <= this._maxColumns ? hint.CellColumnsSpan : Math.min(0, this._maxColumns - this._currentColumn); columnSpan > 1 && this._filledCells[this._currentRow][this._currentColumn + columnSpan - 1]; --columnSpan) {
            }
            while (rowSpan > 1 && this._filledCells[this._currentRow + rowSpan - 1][this._currentColumn]) {
                --rowSpan;
            }
            this._columnSpanApplied = columnSpan;
            this._rowSpanApplied = rowSpan;
            int cellWidth = TabularLayoutEngine.cellSize(this._currentColumn, columnSpan, this._tableBounds.Width, this._columns);
            int cellHeight = TabularLayoutEngine.cellSize(this._currentRow, rowSpan, this._tableBounds.Height, this._rows);
            int controlMaxWidth = cellWidth - (hint.CellPadding.getLeft() + hint.CellPadding.getRight());
            int controlMaxHeight = cellHeight - (hint.CellPadding.getTop() + hint.CellPadding.getBottom());
            int controlWidth = Math.min(controlMaxWidth, TabularLayoutEngine.this.getControlDesiredDimension(control, DesiredDimension.Width, controlMaxWidth));
            int controlHeight = Math.min(controlMaxHeight, TabularLayoutEngine.this.getControlDesiredDimension(control, DesiredDimension.Height, controlMaxHeight));
            control.setBounds(new Rectangle(this._cellX + hint.CellPadding.getLeft() + hint.CellHorizontalAlignment.align(0, controlWidth, controlMaxWidth), this._cellY + hint.CellPadding.getTop() + hint.CellVerticalAlignment.align(0, controlHeight, controlMaxHeight), controlWidth, controlHeight));
            this.fill(this._columnSpanApplied, this._rowSpanApplied);
            return this.next();
        }

        private boolean next() {
            do {
                for (int i = 0; i < this._columnSpanApplied; ++i) {
                    this._cellX += this._columns.get(this._currentColumn).applyAsInt(this._tableBounds.Width);
                    ++this._currentColumn;
                }
                if (this._currentColumn < this._maxColumns) continue;
                this._currentColumn = 0;
                this._cellX = 0;
                this._cellY += this._rows.get(this._currentRow).applyAsInt(this._tableBounds.Height);
                ++this._currentRow;
                if (this._currentRow < this._maxRows) continue;
                this._currentColumn = -1;
                this._currentRow = -1;
                return false;
            } while (this._filledCells[this._currentRow][this._currentColumn]);
            return true;
        }

        private void fill(int colSpan, int rowSpan) {
            int i;
            this._filledCells[this._currentRow][this._currentColumn] = true;
            if (colSpan > 1) {
                for (i = 1; i < colSpan; ++i) {
                    this._filledCells[this._currentRow][this._currentColumn + i] = true;
                }
            }
            if (rowSpan > 1) {
                for (i = 1; i < rowSpan; ++i) {
                    this._filledCells[this._currentRow + i][this._currentColumn] = true;
                }
            }
        }
    }
}

