/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.collect.ImmutableList;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Button;
import it.zerono.mods.zerocore.lib.compat.Mods;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import vazkii.patchouli.api.PatchouliAPI;

public class HelpButton
extends Button {
    public static HelpButton patchouli(ModContainerScreen<? extends ModContainer> gui, String name, ResourceLocation bookId, ResourceLocation entryId, int pageNum) {
        HelpButton button = new HelpButton(gui, name);
        if (Mods.PATCHOULI.isPresent()) {
            button.Clicked.subscribe((control, mb) -> control.enqueueTask(() -> {
                try {
                    PatchouliAPI.get().openBookEntry(bookId, entryId, pageNum);
                }
                catch (Exception ex) {
                    Log.LOGGER.error(Log.CORE, "Exception while opening Patchouli book.", (Throwable)ex);
                }
            }));
            button.setTooltips((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"zerocore:gui.manual.open")));
        } else {
            button.setTooltips((List<Component>)ImmutableList.of((Object)Component.m_237115_((String)"zerocore:gui.patchouli.missing")));
            button.setEnabled(false);
        }
        return button;
    }

    protected HelpButton(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name, "?");
        this.setDesiredDimension(14, 14);
    }
}

