/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.server.packs.resources.Resource;

public final class Theme {
    public static final Theme DEFAULT = new Theme();
    public final Colour FLAT_BACKGROUND_COLOR;
    public final Colour TEXT_ENABLED_COLOR;
    public final Colour TEXT_DISABLED_COLOR;
    public final Colour DARK_OUTLINE_COLOR;
    public final Colour BUTTON_NORMAL_3D_GRADIENT_LIGHT;
    public final Colour BUTTON_NORMAL_3D_GRADIENT_DARK;
    public final Colour BUTTON_NORMAL_3D_BORDER_LIGHT;
    public final Colour BUTTON_NORMAL_3D_BORDER_DARK;
    public final Colour BUTTON_DISABLED_3D_GRADIENT_LIGHT;
    public final Colour BUTTON_DISABLED_3D_GRADIENT_DARK;
    public final Colour BUTTON_DISABLED_3D_BORDER_LIGHT;
    public final Colour BUTTON_DISABLED_3D_BORDER_DARK;
    public final Colour BUTTON_ACTIVE_3D_GRADIENT_LIGHT;
    public final Colour BUTTON_ACTIVE_3D_GRADIENT_DARK;
    public final Colour BUTTON_ACTIVE_3D_BORDER_LIGHT;
    public final Colour BUTTON_ACTIVE_3D_BORDER_DARK;
    public final Colour BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT;
    public final Colour BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK;
    public final Colour BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT;
    public final Colour BUTTON_HIGHLIGHTED_3D_BORDER_DARK;
    public final Colour TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT;
    public final Colour TEXTFIELD_NORMAL_3D_GRADIENT_DARK;
    public final Colour TEXTFIELD_NORMAL_3D_BORDER_LIGHT;
    public final Colour TEXTFIELD_NORMAL_3D_BORDER_DARK;
    public final Colour TEXTFIELD_CARET;
    public final Colour GUI_TITLE;

    public static Theme read(Path jsonFilePath) {
        if (Files.exists(jsonFilePath, new LinkOption[0])) {
            Theme theme;
            FileReader reader = new FileReader(jsonFilePath.toFile());
            try {
                theme = Theme.read(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.LOGGER.error((Object)e);
                }
            }
            ((Reader)reader).close();
            return theme;
        }
        return DEFAULT;
    }

    public static Theme read(Resource resource) {
        Theme theme;
        block8: {
            BufferedReader reader = resource.m_215508_();
            try {
                theme = Theme.read(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.LOGGER.error((Object)e);
                    return DEFAULT;
                }
            }
            ((Reader)reader).close();
        }
        return theme;
    }

    public static void write(Path jsonFilePath, Theme theme) {
        JsonObject json = new JsonObject();
        Theme.writeColour(json, "FLAT_BACKGROUND_COLOR", theme.FLAT_BACKGROUND_COLOR);
        Theme.writeColour(json, "TEXT_ENABLED_COLOR", theme.TEXT_ENABLED_COLOR);
        Theme.writeColour(json, "TEXT_DISABLED_COLOR", theme.TEXT_DISABLED_COLOR);
        Theme.writeColour(json, "DARK_OUTLINE_COLOR", theme.DARK_OUTLINE_COLOR);
        Theme.writeColour(json, "BUTTON_NORMAL_3D_GRADIENT_LIGHT", theme.BUTTON_NORMAL_3D_GRADIENT_LIGHT);
        Theme.writeColour(json, "BUTTON_NORMAL_3D_GRADIENT_DARK", theme.BUTTON_NORMAL_3D_GRADIENT_DARK);
        Theme.writeColour(json, "BUTTON_NORMAL_3D_BORDER_LIGHT", theme.BUTTON_NORMAL_3D_BORDER_LIGHT);
        Theme.writeColour(json, "BUTTON_NORMAL_3D_BORDER_DARK", theme.BUTTON_NORMAL_3D_BORDER_DARK);
        Theme.writeColour(json, "BUTTON_DISABLED_3D_GRADIENT_LIGHT", theme.BUTTON_DISABLED_3D_GRADIENT_LIGHT);
        Theme.writeColour(json, "BUTTON_DISABLED_3D_GRADIENT_DARK", theme.BUTTON_DISABLED_3D_GRADIENT_DARK);
        Theme.writeColour(json, "BUTTON_DISABLED_3D_BORDER_LIGHT", theme.BUTTON_DISABLED_3D_BORDER_LIGHT);
        Theme.writeColour(json, "BUTTON_DISABLED_3D_BORDER_DARK", theme.BUTTON_DISABLED_3D_BORDER_DARK);
        Theme.writeColour(json, "BUTTON_ACTIVE_3D_GRADIENT_LIGHT", theme.BUTTON_ACTIVE_3D_GRADIENT_LIGHT);
        Theme.writeColour(json, "BUTTON_ACTIVE_3D_GRADIENT_DARK", theme.BUTTON_ACTIVE_3D_GRADIENT_DARK);
        Theme.writeColour(json, "BUTTON_ACTIVE_3D_BORDER_LIGHT", theme.BUTTON_ACTIVE_3D_BORDER_LIGHT);
        Theme.writeColour(json, "BUTTON_ACTIVE_3D_BORDER_DARK", theme.BUTTON_ACTIVE_3D_BORDER_DARK);
        Theme.writeColour(json, "BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT", theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT);
        Theme.writeColour(json, "BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK", theme.BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK);
        Theme.writeColour(json, "BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT", theme.BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT);
        Theme.writeColour(json, "BUTTON_HIGHLIGHTED_3D_BORDER_DARK", theme.BUTTON_HIGHLIGHTED_3D_BORDER_DARK);
        Theme.writeColour(json, "TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT", theme.TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT);
        Theme.writeColour(json, "TEXTFIELD_NORMAL_3D_GRADIENT_DARK", theme.TEXTFIELD_NORMAL_3D_GRADIENT_DARK);
        Theme.writeColour(json, "TEXTFIELD_NORMAL_3D_BORDER_LIGHT", theme.TEXTFIELD_NORMAL_3D_BORDER_LIGHT);
        Theme.writeColour(json, "TEXTFIELD_NORMAL_3D_BORDER_DARK", theme.TEXTFIELD_NORMAL_3D_BORDER_DARK);
        Theme.writeColour(json, "TEXTFIELD_CARET", theme.TEXTFIELD_CARET);
        Theme.writeColour(json, "GUI_TITLE", theme.GUI_TITLE);
        try (FileWriter writer = new FileWriter(jsonFilePath.toFile());){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Theme() {
        this.FLAT_BACKGROUND_COLOR = new Colour(134, 134, 134, 255);
        this.TEXT_ENABLED_COLOR = new Colour(39, 39, 39, 255);
        this.TEXT_DISABLED_COLOR = new Colour(160, 160, 160, 255);
        this.DARK_OUTLINE_COLOR = new Colour(0.0, 0.0, 0.0, 0.7);
        this.BUTTON_NORMAL_3D_GRADIENT_LIGHT = new Colour(144, 144, 144, 255);
        this.BUTTON_NORMAL_3D_GRADIENT_DARK = new Colour(32, 32, 32, 255);
        this.BUTTON_NORMAL_3D_BORDER_LIGHT = new Colour(221, 221, 221, 255);
        this.BUTTON_NORMAL_3D_BORDER_DARK = new Colour(119, 119, 119, 238);
        this.BUTTON_DISABLED_3D_GRADIENT_LIGHT = this.BUTTON_NORMAL_3D_GRADIENT_LIGHT;
        this.BUTTON_DISABLED_3D_GRADIENT_DARK = this.BUTTON_NORMAL_3D_GRADIENT_DARK;
        this.BUTTON_DISABLED_3D_BORDER_LIGHT = this.BUTTON_NORMAL_3D_BORDER_LIGHT;
        this.BUTTON_DISABLED_3D_BORDER_DARK = this.BUTTON_NORMAL_3D_BORDER_DARK;
        this.BUTTON_ACTIVE_3D_GRADIENT_LIGHT = new Colour(167, 153, 174, 255);
        this.BUTTON_ACTIVE_3D_GRADIENT_DARK = new Colour(41, 36, 46, 255);
        this.BUTTON_ACTIVE_3D_BORDER_LIGHT = new Colour(119, 119, 119, 238);
        this.BUTTON_ACTIVE_3D_BORDER_DARK = new Colour(221, 221, 221, 255);
        this.BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT = new Colour(167, 153, 174, 255);
        this.BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK = new Colour(41, 36, 46, 255);
        this.BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT = new Colour(119, 119, 119, 238);
        this.BUTTON_HIGHLIGHTED_3D_BORDER_DARK = new Colour(221, 221, 221, 255);
        this.TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT = this.BUTTON_NORMAL_3D_GRADIENT_LIGHT;
        this.TEXTFIELD_NORMAL_3D_GRADIENT_DARK = this.BUTTON_NORMAL_3D_GRADIENT_DARK;
        this.TEXTFIELD_NORMAL_3D_BORDER_LIGHT = Colour.WHITE;
        this.TEXTFIELD_NORMAL_3D_BORDER_DARK = new Colour(43, 43, 43, 255);
        this.TEXTFIELD_CARET = new Colour(0, 0, 0, 111);
        this.GUI_TITLE = Colour.BLACK;
    }

    private Theme(JsonObject json) {
        this.FLAT_BACKGROUND_COLOR = Theme.readColour(json, "FLAT_BACKGROUND_COLOR");
        this.TEXT_ENABLED_COLOR = Theme.readColour(json, "TEXT_ENABLED_COLOR");
        this.TEXT_DISABLED_COLOR = Theme.readColour(json, "TEXT_DISABLED_COLOR");
        this.DARK_OUTLINE_COLOR = Theme.readColour(json, "DARK_OUTLINE_COLOR");
        this.BUTTON_NORMAL_3D_GRADIENT_LIGHT = Theme.readColour(json, "BUTTON_NORMAL_3D_GRADIENT_LIGHT");
        this.BUTTON_NORMAL_3D_GRADIENT_DARK = Theme.readColour(json, "BUTTON_NORMAL_3D_GRADIENT_DARK");
        this.BUTTON_NORMAL_3D_BORDER_LIGHT = Theme.readColour(json, "BUTTON_NORMAL_3D_BORDER_LIGHT");
        this.BUTTON_NORMAL_3D_BORDER_DARK = Theme.readColour(json, "BUTTON_NORMAL_3D_BORDER_DARK");
        this.BUTTON_DISABLED_3D_GRADIENT_LIGHT = Theme.readColour(json, "BUTTON_DISABLED_3D_GRADIENT_LIGHT");
        this.BUTTON_DISABLED_3D_GRADIENT_DARK = Theme.readColour(json, "BUTTON_DISABLED_3D_GRADIENT_DARK");
        this.BUTTON_DISABLED_3D_BORDER_LIGHT = Theme.readColour(json, "BUTTON_DISABLED_3D_BORDER_LIGHT");
        this.BUTTON_DISABLED_3D_BORDER_DARK = Theme.readColour(json, "BUTTON_DISABLED_3D_BORDER_DARK");
        this.BUTTON_ACTIVE_3D_GRADIENT_LIGHT = Theme.readColour(json, "BUTTON_ACTIVE_3D_GRADIENT_LIGHT");
        this.BUTTON_ACTIVE_3D_GRADIENT_DARK = Theme.readColour(json, "BUTTON_ACTIVE_3D_GRADIENT_DARK");
        this.BUTTON_ACTIVE_3D_BORDER_LIGHT = Theme.readColour(json, "BUTTON_ACTIVE_3D_BORDER_LIGHT");
        this.BUTTON_ACTIVE_3D_BORDER_DARK = Theme.readColour(json, "BUTTON_ACTIVE_3D_BORDER_DARK");
        this.BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT = Theme.readColour(json, "BUTTON_HIGHLIGHTED_3D_GRADIENT_LIGHT");
        this.BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK = Theme.readColour(json, "BUTTON_HIGHLIGHTED_3D_GRADIENT_DARK");
        this.BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT = Theme.readColour(json, "BUTTON_HIGHLIGHTED_3D_BORDER_LIGHT");
        this.BUTTON_HIGHLIGHTED_3D_BORDER_DARK = Theme.readColour(json, "BUTTON_HIGHLIGHTED_3D_BORDER_DARK");
        this.TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT = Theme.readColour(json, "TEXTFIELD_NORMAL_3D_GRADIENT_LIGHT");
        this.TEXTFIELD_NORMAL_3D_GRADIENT_DARK = Theme.readColour(json, "TEXTFIELD_NORMAL_3D_GRADIENT_DARK");
        this.TEXTFIELD_NORMAL_3D_BORDER_LIGHT = Theme.readColour(json, "TEXTFIELD_NORMAL_3D_BORDER_LIGHT");
        this.TEXTFIELD_NORMAL_3D_BORDER_DARK = Theme.readColour(json, "TEXTFIELD_NORMAL_3D_BORDER_DARK");
        this.TEXTFIELD_CARET = Theme.readColour(json, "TEXTFIELD_CARET");
        this.GUI_TITLE = Theme.readColour(json, "GUI_TITLE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Theme read(Reader reader) {
        try (JsonReader jsonReader = new JsonReader(reader);){
            JsonElement root = JsonParser.parseReader((JsonReader)jsonReader);
            if (!root.isJsonObject()) return DEFAULT;
            Theme theme = new Theme(root.getAsJsonObject());
            return theme;
        }
        catch (JsonParseException | IOException e) {
            Log.LOGGER.error((Object)e);
        }
        return DEFAULT;
    }

    private static void writeColour(JsonObject json, String name, Colour colour) {
        JSONHelper.jsonSetString(json, name, colour.toHexRGBA());
    }

    private static Colour readColour(JsonObject json, String name) {
        return Colour.fromHexRGBA(JSONHelper.jsonGetString(json, name));
    }
}

