/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomBrushBaseModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomKeychainChainModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomKeychainModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomLargeSatchelModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomMediumSatchelModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomNetheriteTipModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomRingsModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomSmallSatchelModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomStickBaseModel;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomWaterproofTipModel;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomAttachmentItem;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.joefoxe.hexerei.item.custom.SatchelItem;
import net.joefoxe.hexerei.util.HexereiTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BroomRenderer
extends EntityRenderer<BroomEntity> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom.png");
    protected static final ResourceLocation WILLOW_TEXTURE = new ResourceLocation("hexerei", "textures/entity/willow_broom.png");
    protected static final ResourceLocation HERB_BRUSH_TEXTURE = new ResourceLocation("hexerei", "textures/entity/herb_enhanced_brush.png");
    protected static final ResourceLocation SATCHEL_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_satchel.png");
    protected static final ResourceLocation SATCHEL_TEXTURE_DYE = new ResourceLocation("hexerei", "textures/entity/broom_satchel_dye.png");
    protected static final ResourceLocation SATCHEL_SMALL_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_small_satchel.png");
    protected static final ResourceLocation SATCHEL_SMALL_TEXTURE_DYE = new ResourceLocation("hexerei", "textures/entity/broom_small_satchel_dye.png");
    protected static final ResourceLocation SATCHEL_LARGE_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_large_satchel.png");
    protected static final ResourceLocation SATCHEL_LARGE_TEXTURE_DYE = new ResourceLocation("hexerei", "textures/entity/broom_large_satchel_dye.png");
    protected static final ResourceLocation KEYCHAIN_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_keychain.png");
    protected static final ResourceLocation NETHERITE_TIP_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_netherite_tip.png");
    protected static final ResourceLocation WATERPROOF_TIP_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_waterproof_tip.png");
    protected static final ResourceLocation ENDER_SATCHEL_TEXTURE = new ResourceLocation("hexerei", "textures/entity/broom_ender_satchel.png");
    private final Pair<ResourceLocation, BroomModel> broomResources;
    private final Pair<ResourceLocation, BroomStickBaseModel> broomStickResources;
    private final Pair<ResourceLocation, BroomBrushBaseModel> broomBrushResources;
    private final Pair<ResourceLocation, BroomRingsModel> broomRingsResources;
    private final Pair<ResourceLocation, BroomSmallSatchelModel> broomSmallSatchelResources;
    private final Pair<ResourceLocation, BroomMediumSatchelModel> broomMediumSatchelResources;
    private final Pair<ResourceLocation, BroomLargeSatchelModel> broomLargeSatchelResources;
    private final Pair<ResourceLocation, BroomKeychainModel> broomKeychainResources;
    private final Pair<ResourceLocation, BroomNetheriteTipModel> broomNetheriteTipResources;
    private final Pair<ResourceLocation, BroomWaterproofTipModel> broomWaterproofTipResources;
    private final Pair<ResourceLocation, BroomKeychainChainModel> broomKeychainChainResources;
    private final Pair<ResourceLocation, BroomMediumSatchelModel> broomEnderSatchelResources;
    private static final ResourceLocation POWER_LOCATION = new ResourceLocation("hexerei", "textures/entity/power_layer_light.png");
    private final BroomStickBaseModel broomPowerModel;
    private final BroomBrushBaseModel broomBrushPowerModel;

    public BroomRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.0f;
        this.broomResources = Pair.of((Object)TEXTURE, (Object)((Object)new BroomModel(context.m_174023_(BroomModel.LAYER_LOCATION))));
        this.broomRingsResources = Pair.of((Object)TEXTURE, (Object)((Object)new BroomRingsModel(context.m_174023_(BroomRingsModel.LAYER_LOCATION))));
        this.broomSmallSatchelResources = Pair.of((Object)SATCHEL_SMALL_TEXTURE, (Object)((Object)new BroomSmallSatchelModel(context.m_174023_(BroomSmallSatchelModel.LAYER_LOCATION))));
        this.broomMediumSatchelResources = Pair.of((Object)SATCHEL_TEXTURE, (Object)((Object)new BroomMediumSatchelModel(context.m_174023_(BroomMediumSatchelModel.LAYER_LOCATION))));
        this.broomLargeSatchelResources = Pair.of((Object)SATCHEL_LARGE_TEXTURE, (Object)((Object)new BroomLargeSatchelModel(context.m_174023_(BroomLargeSatchelModel.LAYER_LOCATION))));
        this.broomStickResources = Pair.of((Object)TEXTURE, (Object)((Object)new BroomStickBaseModel(context.m_174023_(BroomStickBaseModel.LAYER_LOCATION))));
        this.broomBrushResources = Pair.of((Object)TEXTURE, (Object)((Object)new BroomBrushBaseModel(context.m_174023_(BroomBrushBaseModel.LAYER_LOCATION))));
        this.broomKeychainResources = Pair.of((Object)KEYCHAIN_TEXTURE, (Object)((Object)new BroomKeychainModel(context.m_174023_(BroomKeychainModel.LAYER_LOCATION))));
        this.broomKeychainChainResources = Pair.of((Object)KEYCHAIN_TEXTURE, (Object)((Object)new BroomKeychainChainModel(context.m_174023_(BroomKeychainChainModel.LAYER_LOCATION))));
        this.broomNetheriteTipResources = Pair.of((Object)NETHERITE_TIP_TEXTURE, (Object)((Object)new BroomNetheriteTipModel(context.m_174023_(BroomNetheriteTipModel.LAYER_LOCATION))));
        this.broomWaterproofTipResources = Pair.of((Object)WATERPROOF_TIP_TEXTURE, (Object)((Object)new BroomWaterproofTipModel(context.m_174023_(BroomWaterproofTipModel.LAYER_LOCATION))));
        this.broomPowerModel = new BroomStickBaseModel(context.m_174023_(BroomStickBaseModel.POWER_LAYER_LOCATION));
        this.broomBrushPowerModel = new BroomBrushBaseModel(context.m_174023_(BroomBrushBaseModel.POWER_LAYER_LOCATION));
        this.broomEnderSatchelResources = Pair.of((Object)ENDER_SATCHEL_TEXTURE, (Object)((Object)new BroomMediumSatchelModel(context.m_174023_(BroomMediumSatchelModel.LAYER_LOCATION))));
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public ResourceLocation getTextureLocation(BroomEntity p_114482_) {
        return TEXTURE;
    }

    public void render(BroomEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        ItemStack miscStack;
        Item vertexConsumer;
        BroomAttachmentItem satchelItem;
        ItemStack satchelStack;
        float[] afloat;
        Item brushVertexConsumer;
        BroomAttachmentItem brushItem;
        ItemStack brushStack;
        Item offset2;
        float f2;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.375 + (double)entityIn.floatingOffset, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw - entityIn.deltaRotation * 2.0f));
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)entityIn.m_20184_().m_7098_() * 20.0f));
        float f = (float)entityIn.getTimeSinceHit() - partialTicks;
        float f1 = entityIn.getDamageTaken() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entityIn.getForwardDirection()));
        }
        if (!Mth.m_14033_((float)(f2 = entityIn.getRockingAngle(partialTicks)), (float)0.0f)) {
            matrixStackIn.m_85845_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entityIn.getRockingAngle(partialTicks), true));
        }
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        matrixStackIn.m_85837_(0.0, -1.6, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        matrixStackIn.m_85837_(0.0, -2.75, 0.0);
        BroomModel broomModel = (BroomModel)((Object)this.broomResources.getSecond());
        BroomStickBaseModel broomStickModel = (BroomStickBaseModel)((Object)this.broomStickResources.getSecond());
        broomModel.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        broomStickModel.setupAnim(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        ResourceLocation loc = TEXTURE;
        if (entityIn.getBroomType() == BroomEntity.Type.WILLOW) {
            loc = WILLOW_TEXTURE;
        }
        VertexConsumer ivertexbuilderStick = bufferIn.m_6299_(broomStickModel.m_103119_(loc));
        broomStickModel.m_7695_(matrixStackIn, ivertexbuilderStick, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (BroomEntity.getDyeColorNamed(entityIn) != null) {
            DyeColor dyeColor = BroomEntity.getDyeColorNamed(entityIn);
            float[] afloat2 = new float[]{1.0f, 1.0f, 1.0f};
            if (dyeColor != null) {
                afloat2 = BroomEntity.getDyeColorNamed(entityIn).m_41068_();
            }
            float offset2 = Hexerei.getClientTicks();
            VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)POWER_LOCATION, (float)(offset2 * 0.01f % 1.0f), (float)(offset2 * 0.01f % 1.0f)));
            this.broomPowerModel.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, afloat2[0], afloat2[1], afloat2[2], 1.0f);
        }
        if ((offset2 = (brushStack = entityIn.itemHandler.getStackInSlot(2)).m_41720_()) instanceof BroomAttachmentItem) {
            brushItem = (BroomAttachmentItem)offset2;
            if (brushItem.model == null) {
                brushItem.bakeModels();
            }
        }
        if (entityIn.itemHandler.getStackInSlot(2).m_204117_(HexereiTags.Items.BROOM_BRUSH) && (offset2 = brushStack.m_41720_()) instanceof BroomAttachmentItem) {
            brushItem = (BroomAttachmentItem)offset2;
            Model broomBrushModel = brushItem.model;
            brushVertexConsumer = bufferIn.m_6299_(broomBrushModel.m_103119_(brushItem.texture));
            broomBrushModel.m_7695_(matrixStackIn, (VertexConsumer)brushVertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (entityIn.m_8077_() && BroomEntity.getDyeColorNamed(entityIn) != null) {
                DyeColor dyeColor = BroomEntity.getDyeColorNamed(entityIn);
                afloat = new float[]{1.0f, 1.0f, 1.0f};
                if (dyeColor != null) {
                    afloat = BroomEntity.getDyeColorNamed(entityIn).m_41068_();
                }
                float offset3 = Hexerei.getClientTicks();
                VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110436_((ResourceLocation)POWER_LOCATION, (float)(offset3 * 0.01f % 1.0f), (float)(offset3 * 0.01f % 1.0f)));
                broomBrushModel.m_7695_(matrixStackIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, afloat[0], afloat[1], afloat[2], 1.0f);
            }
        }
        if ((brushVertexConsumer = (satchelStack = entityIn.itemHandler.getStackInSlot(1)).m_41720_()) instanceof BroomAttachmentItem) {
            satchelItem = (BroomAttachmentItem)brushVertexConsumer;
            if (satchelItem.model == null) {
                satchelItem.bakeModels();
            }
        }
        if (entityIn.itemHandler.getStackInSlot(1).m_204117_(HexereiTags.Items.ALL_SATCHELS) && (brushVertexConsumer = satchelStack.m_41720_()) instanceof BroomAttachmentItem) {
            satchelItem = (BroomAttachmentItem)brushVertexConsumer;
            Model satchelModel = satchelItem.model;
            vertexConsumer = bufferIn.m_6299_(satchelModel.m_103119_(satchelItem.texture));
            satchelModel.m_7695_(matrixStackIn, (VertexConsumer)vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (satchelItem.dye_texture != null) {
                if (SatchelItem.getDyeColorNamed(satchelStack) != null) {
                    afloat = SatchelItem.getDyeColorNamed(satchelStack).m_41068_();
                    VertexConsumer vertexConsumerDye = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)satchelItem.dye_texture), (boolean)false, (boolean)false);
                    satchelModel.m_7695_(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.f_118083_, afloat[0], afloat[1], afloat[2], 1.0f);
                } else {
                    int col = SatchelItem.getColorStatic(satchelStack);
                    int i = (col & 0xFF0000) >> 16;
                    int j = (col & 0xFF00) >> 8;
                    int k = col & 0xFF;
                    float[] afloat3 = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
                    VertexConsumer vertexConsumerDye = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)satchelItem.dye_texture), (boolean)false, (boolean)false);
                    satchelModel.m_7695_(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.f_118083_, afloat3[0], afloat3[1], afloat3[2], 1.0f);
                }
            }
        }
        if ((vertexConsumer = (miscStack = entityIn.itemHandler.getStackInSlot(0)).m_41720_()) instanceof BroomAttachmentItem) {
            BroomAttachmentItem miscItem = (BroomAttachmentItem)vertexConsumer;
            if (miscItem.model == null) {
                miscItem.bakeModels();
            }
        }
        if (miscStack.m_204117_(HexereiTags.Items.BROOM_MISC)) {
            vertexConsumer = miscStack.m_41720_();
            if (vertexConsumer instanceof KeychainItem) {
                KeychainItem keychainItem = (KeychainItem)vertexConsumer;
                Model broomKeychainModel = keychainItem.model;
                VertexConsumer ivertexbuilderRings = bufferIn.m_6299_(broomKeychainModel.m_103119_(keychainItem.texture));
                broomKeychainModel.m_7695_(matrixStackIn, ivertexbuilderRings, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85837_(-1.1875, 0.0, (double)-0.025f);
                matrixStackIn.m_85837_(0.0, 2.75, 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                matrixStackIn.m_85837_(0.0, 1.3, 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-((float)entityIn.m_20184_().m_7098_()) * 20.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)(Math.atan2(entityIn.m_20184_().m_7094_(), entityIn.m_20184_().m_7096_()) / (Math.PI * 2) * 360.0) - entityYaw));
                if (entityIn.selfItem != null && entityIn.selfItem.m_41782_() && Hexerei.proxy.getPlayer().m_21205_().m_41782_() && Hexerei.proxy.getPlayer().m_21205_().m_41783_().equals((Object)entityIn.selfItem.m_41783_()) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_((Hexerei.proxy.getPlayer().f_20885_ - Hexerei.proxy.getPlayer().f_20886_) * 1.5f));
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14036_((float)((float)Hexerei.proxy.getPlayer().m_20184_().m_82524_(-90.0f).m_82526_(Hexerei.proxy.getPlayer().m_20154_()) * -125.0f), (float)-70.0f, (float)70.0f)));
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)(Hexerei.proxy.getPlayer().m_20154_().f_82480_ * -50.0) - 50.0f));
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14036_((float)((float)Hexerei.proxy.getPlayer().m_20184_().m_82526_(Hexerei.proxy.getPlayer().m_20154_()) * -125.0f), (float)-70.0f, (float)70.0f)));
                }
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)Mth.m_184645_((double)entityIn.m_20184_().m_7096_(), (double)entityIn.m_20184_().m_7094_()) * 50.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrixStackIn.m_85837_(0.0, -1.3, 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                matrixStackIn.m_85837_(0.0, -2.79375, 0.0);
                Model broomKeychainChainModel = (Model)keychainItem.chain_resources.getSecond();
                VertexConsumer ivertexbuilderChain = bufferIn.m_6299_(broomKeychainChainModel.m_103119_((ResourceLocation)keychainItem.chain_resources.getFirst()));
                broomKeychainChainModel.m_7695_(matrixStackIn, ivertexbuilderRings, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85837_(0.0, 1.71875, 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                if (entityIn.selfItem != null && entityIn.selfItem.m_41782_() && Hexerei.proxy.getPlayer().m_21205_().m_41782_() && Hexerei.proxy.getPlayer().m_21205_().m_41783_().equals((Object)entityIn.selfItem.m_41783_()) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)(Hexerei.proxy.getPlayer().m_20154_().f_82480_ * 20.0)));
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(Mth.m_14036_((float)((float)Hexerei.proxy.getPlayer().m_20184_().m_82526_(Hexerei.proxy.getPlayer().m_20154_()) * 50.0f), (float)-20.0f, (float)20.0f)));
                }
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)Mth.m_184645_((double)entityIn.m_20184_().m_7096_(), (double)entityIn.m_20184_().m_7094_()) * -20.0f));
                NonNullList items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
                if (miscStack.m_41782_()) {
                    ContainerHelper.m_18980_((CompoundTag)miscStack.m_41783_(), (NonNullList)items);
                }
                if (((ItemStack)items.get(0)).m_41720_() instanceof BroomItem) {
                    matrixStackIn.m_85841_(0.45f, 0.45f, 0.45f);
                } else {
                    matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
                }
                this.renderItem((ItemStack)items.get(0), partialTicks, matrixStackIn, bufferIn, packedLightIn);
            } else if (miscStack.m_150930_((Item)ModItems.BROOM_NETHERITE_TIP.get())) {
                Item ivertexbuilderRings = miscStack.m_41720_();
                if (ivertexbuilderRings instanceof BroomAttachmentItem) {
                    miscItem = (BroomAttachmentItem)ivertexbuilderRings;
                    int light = packedLightIn / 15 * (15 - (int)(8.0f * ((float)miscStack.m_41773_() / (float)miscStack.m_41776_())));
                    Model miscModel = miscItem.model;
                    vertexConsumer = bufferIn.m_6299_(miscModel.m_103119_(miscItem.texture));
                    miscModel.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStackIn.m_85837_(-1.375, 0.0, (double)-0.025f);
                    matrixStackIn.m_85837_(0.0, 2.68, 0.0);
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                    matrixStackIn.m_85837_(0.0, 1.3, 0.0);
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    matrixStackIn.m_85841_(0.3f, 0.3f, 0.3f);
                    this.renderItem(new ItemStack((ItemLike)ModItems.SELENITE_SHARD.get()), partialTicks, matrixStackIn, bufferIn, light);
                }
            } else if (miscStack.m_150930_((Item)ModItems.BROOM_WATERPROOF_TIP.get())) {
                Item light = miscStack.m_41720_();
                if (light instanceof BroomAttachmentItem) {
                    miscItem = (BroomAttachmentItem)light;
                    int light2 = packedLightIn / 15 * (15 - (int)(8.0f * ((float)miscStack.m_41773_() / (float)miscStack.m_41776_())));
                    Model miscModel = miscItem.model;
                    vertexConsumer = bufferIn.m_6299_(miscModel.m_103119_(miscItem.texture));
                    miscModel.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    matrixStackIn.m_85837_(-1.375, 0.0, (double)-0.025f);
                    matrixStackIn.m_85837_(0.0, 2.68, 0.0);
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                    matrixStackIn.m_85837_(0.0, 1.3, 0.0);
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                    matrixStackIn.m_85841_(0.3f, 0.3f, 0.3f);
                    this.renderItem(new ItemStack((ItemLike)Items.f_42364_), partialTicks, matrixStackIn, bufferIn, light2);
                }
            } else {
                Item light2 = miscStack.m_41720_();
                if (light2 instanceof BroomAttachmentItem) {
                    miscItem = (BroomAttachmentItem)light2;
                    Model miscModel = miscItem.model;
                    VertexConsumer vertexConsumer2 = bufferIn.m_6299_(miscModel.m_103119_(miscItem.texture));
                    miscModel.m_7695_(matrixStackIn, vertexConsumer2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    if (miscItem.dye_texture != null) {
                        if (SatchelItem.getDyeColorNamed(satchelStack) != null) {
                            float[] afloat4 = SatchelItem.getDyeColorNamed(satchelStack).m_41068_();
                            VertexConsumer vertexConsumerDye = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)miscItem.dye_texture), (boolean)false, (boolean)false);
                            miscModel.m_7695_(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.f_118083_, afloat4[0], afloat4[1], afloat4[2], 1.0f);
                        } else {
                            int col = SatchelItem.getColorStatic(satchelStack);
                            int i = (col & 0xFF0000) >> 16;
                            int j = (col & 0xFF00) >> 8;
                            int k = col & 0xFF;
                            float[] afloat5 = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
                            VertexConsumer vertexConsumerDye = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)miscItem.dye_texture), (boolean)false, (boolean)false);
                            miscModel.m_7695_(matrixStackIn, vertexConsumerDye, packedLightIn, OverlayTexture.f_118083_, afloat5[0], afloat5[1], afloat5[2], 1.0f);
                        }
                    }
                }
            }
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderItem(ItemStack stack, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }
}

