/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.connected;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.joefoxe.hexerei.block.connected.BakedModelWrapperWithData;
import net.joefoxe.hexerei.block.connected.CTSpriteShiftEntry;
import net.joefoxe.hexerei.block.connected.CTType;
import net.joefoxe.hexerei.block.connected.ConnectedTextureBehaviour;
import net.joefoxe.hexerei.block.connected.QuadHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class CTModel
extends BakedModelWrapperWithData {
    private static final ModelProperty<CTData> CT_PROPERTY = new ModelProperty();
    private final ConnectedTextureBehaviour behaviour;

    public CTModel(BakedModel originalModel, ConnectedTextureBehaviour behaviour) {
        super(originalModel);
        this.behaviour = behaviour;
    }

    @Override
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return builder.with(CT_PROPERTY, (Object)this.createCTData(world, pos, state));
    }

    protected CTData createCTData(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        CTData data = new CTData();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Direction.values()) {
            Random random;
            int rand;
            CTType dataType;
            if (!this.behaviour.buildContextForOccludedDirections() && !Block.m_152444_((BlockState)state, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)mutablePos.m_122159_((Vec3i)pos, face)) || (dataType = this.behaviour.getDataType(state, face)) == null) continue;
            ConnectedTextureBehaviour.CTContext context = this.behaviour.buildContext(world, pos, state, face, dataType.getContextRequirement());
            int textureIndex = dataType.getTextureIndex(context);
            if (dataType.getExtraFaceVariations() > 0 && textureIndex == 54 && (rand = (random = new Random((long)(Math.abs(pos.m_123341_()) + 1) * (long)(Math.abs(pos.m_123342_()) + 1) * (long)(Math.abs(pos.m_123343_()) + 1))).nextInt((int)((float)dataType.getExtraFaceVariations() / dataType.getPercent()))) != 0 && rand < dataType.getExtraFaceVariations()) {
                textureIndex = rand * 8 - 1;
            }
            data.put(face, textureIndex);
        }
        return data;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        if (!extraData.has(CT_PROPERTY)) {
            return quads;
        }
        CTData data = (CTData)extraData.get(CT_PROPERTY);
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            ResourceLocation loc2;
            ResourceLocation loc1;
            CTSpriteShiftEntry spriteShift;
            BakedQuad quad = (BakedQuad)quads.get(i);
            int index = data.get(quad.m_111306_());
            if (index == -1 || (spriteShift = this.behaviour.getShift(state, quad.m_111306_(), quad.m_173410_())) == null || (loc1 = quad.m_173410_().m_118413_()) != (loc2 = spriteShift.getOriginal().m_118413_())) continue;
            BakedQuad newQuad = QuadHelper.clone(quad);
            int[] vertexData = newQuad.m_111303_();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = QuadHelper.getU(vertexData, vertex);
                float v = QuadHelper.getV(vertexData, vertex);
                QuadHelper.setU(vertexData, vertex, spriteShift.getTargetU(u, index));
                QuadHelper.setV(vertexData, vertex, spriteShift.getTargetV(v, index));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    private static class CTData {
        private final int[] indices = new int[6];

        public CTData() {
            Arrays.fill(this.indices, -1);
        }

        public void put(Direction face, int texture) {
            this.indices[face.m_122411_()] = texture;
        }

        public int get(Direction face) {
            return this.indices[face.m_122411_()];
        }
    }
}

