/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.FlowerPouchItem;
import vazkii.botania.test.TestingUtil;

public class FlowerPouchTest {
    @GameTest(template="fabric-gametest-api-v1:empty")
    public void testNoShinyFlowers(GameTestHelper helper) {
        Player player = helper.m_177368_();
        ItemStack bag = new ItemStack((ItemLike)BotaniaItems.flowerBag);
        player.m_150109_().m_6836_(1, bag);
        ItemEntity flower = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)BotaniaBlocks.blackShinyFlower, 64));
        TestingUtil.assertThat(!FlowerPouchItem.onPickupItem(flower, player), () -> "Should not pick up glimmering flowers");
        TestingUtil.assertEquals(flower.m_32055_().m_41720_(), BotaniaBlocks.blackShinyFlower.m_5456_());
        TestingUtil.assertEquals(flower.m_32055_().m_41613_(), 64);
        SimpleContainer inv = FlowerPouchItem.getInventory(bag);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            TestingUtil.assertThat(inv.m_8020_(i).m_41619_(), () -> "Bag should be empty");
        }
        helper.m_177412_();
    }

    @GameTest(template="fabric-gametest-api-v1:empty")
    public void testPickupBasic(GameTestHelper helper) {
        Player player = helper.m_177368_();
        ItemStack bag = new ItemStack((ItemLike)BotaniaItems.flowerBag);
        player.m_150109_().m_6836_(1, bag);
        ItemEntity flower = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)BotaniaBlocks.blackFlower, 64));
        TestingUtil.assertThat(FlowerPouchItem.onPickupItem(flower, player), () -> "Pickup should succeed since the bag has room");
        TestingUtil.assertThat(flower.m_32055_().m_41619_(), () -> "Should have consumed everything");
        ItemStack flowerInBag = FlowerPouchItem.getInventory(bag).m_8020_(DyeColor.BLACK.m_41060_());
        TestingUtil.assertThat(!flowerInBag.m_41619_(), () -> "Bag should have an item in black slot");
        TestingUtil.assertEquals(flowerInBag.m_41720_(), BotaniaBlocks.blackFlower.m_5456_());
        TestingUtil.assertEquals(flowerInBag.m_41613_(), 64);
        helper.m_177412_();
    }
}

