/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertPosException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.test.TestingUtil;

public class HopperhockTest {
    private static final String TEMPLATE = "botania:block/hopperhock_furnace";
    private static final BlockPos FLOWER_POS = new BlockPos(2, 3, 2);
    private static final BlockPos SPAWN_ITEM_POS = new BlockPos(2, 3, 1);
    private static final float SPAWN_ITEM_X = SPAWN_ITEM_POS.m_123341_();
    private static final float SPAWN_ITEM_Y = SPAWN_ITEM_POS.m_123342_();
    private static final float SPAWN_ITEM_Z = SPAWN_ITEM_POS.m_123343_();

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInsertTop(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7495_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        this.spawnItem(helper, Items.f_42594_);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.f_42594_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInsertSide(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_122019_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        this.spawnItem(helper, Items.f_42414_);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 1, Items.f_42414_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInsertBottom(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7494_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        this.spawnItem(helper, Items.f_42414_);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 1, Items.f_42414_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testInventoryFull(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7495_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        HopperhockTest.getFurnaceBlockEntity(helper, furnacePos).m_6836_(0, new ItemStack((ItemLike)Items.f_41837_, 64));
        this.spawnItem(helper, Items.f_41837_);
        helper.m_177425_().m_177546_(61, () -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.f_41837_, 64);
            helper.m_177194_(Items.f_41837_, SPAWN_ITEM_POS, 0.0);
        }).m_177543_();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testAddToStack(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7495_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        HopperhockTest.getFurnaceBlockEntity(helper, furnacePos).m_6836_(0, new ItemStack((ItemLike)Items.f_41837_, 60));
        ItemEntity itemEntity = this.spawnItem(helper, Items.f_41837_);
        itemEntity.m_32055_().m_41764_(10);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.f_41837_, 64);
            helper.m_177198_(Items.f_41837_, SPAWN_ITEM_POS, 0.0, 6);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testWrongItemForSlot(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7494_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        this.spawnItem(helper, Items.f_41995_);
        helper.m_177425_().m_177546_(61, () -> {
            helper.m_177440_(furnacePos);
            helper.m_177194_(Items.f_41995_, SPAWN_ITEM_POS, 0.0);
        }).m_177543_();
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFilterMatch(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7495_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        HopperhockTest.spawnItemFrame(helper, furnacePos.m_122024_(), Direction.WEST, Items.f_42594_);
        this.spawnItem(helper, Items.f_42594_);
        helper.m_177361_(() -> {
            HopperhockTest.assertItemInSlot(helper, furnacePos, 0, Items.f_42594_, 1);
            helper.m_177309_(EntityType.f_20461_);
        });
    }

    @GameTest(template="botania:block/hopperhock_furnace")
    public void testFilterNoMatch(GameTestHelper helper) {
        BlockPos furnacePos = FLOWER_POS.m_7495_();
        helper.m_177245_(furnacePos, Blocks.f_50094_);
        HopperhockTest.spawnItemFrame(helper, furnacePos.m_122024_(), Direction.WEST, Items.f_41837_);
        this.spawnItem(helper, Items.f_42594_);
        helper.m_177425_().m_177546_(61, () -> {
            helper.m_177440_(furnacePos);
            helper.m_177194_(Items.f_42594_, SPAWN_ITEM_POS, 0.0);
        }).m_177543_();
    }

    private static void spawnItemFrame(GameTestHelper helper, BlockPos pos, Direction direction, Item item) {
        ItemFrame itemFrame = new ItemFrame((Level)helper.m_177100_(), helper.m_177449_(pos), direction);
        itemFrame.m_31805_(new ItemStack((ItemLike)item));
        helper.m_177100_().m_7967_((Entity)itemFrame);
    }

    private ItemEntity spawnItem(GameTestHelper helper, Item item) {
        return helper.m_177189_(item, SPAWN_ITEM_X, SPAWN_ITEM_Y, SPAWN_ITEM_Z);
    }

    private static void assertItemInSlot(GameTestHelper helper, BlockPos furnacePos, int slot, Item expectedItem, int expectedCount) {
        ItemStack stack = HopperhockTest.getFurnaceBlockEntity(helper, furnacePos).m_8020_(slot);
        if (stack.m_41720_() != expectedItem) {
            TestingUtil.throwPositionedAssertion(helper, furnacePos, () -> "Expected " + expectedItem + " in slot " + slot + ", but got " + stack.m_41720_());
        } else if (stack.m_41613_() != expectedCount) {
            TestingUtil.throwPositionedAssertion(helper, furnacePos, () -> "Expected " + expectedCount + " items in slot " + slot + ", but got " + stack.m_41613_());
        }
    }

    private static AbstractFurnaceBlockEntity getFurnaceBlockEntity(GameTestHelper helper, BlockPos furnacePos) {
        BlockEntity blockEntity = helper.m_177347_(furnacePos);
        if (blockEntity instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)blockEntity;
            return furnace;
        }
        throw new GameTestAssertPosException("Expected furnace here", helper.m_177449_(furnacePos), furnacePos, helper.m_177436_());
    }
}

