/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.NoiseChunkAccessor;

public class SkyblockChunkGenerator
extends ChunkGenerator {
    public static final Codec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> SkyblockChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and(instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(gen -> gen.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(gen -> gen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(gen -> gen.settings))).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));
    protected final BlockState defaultBlock;
    private final Registry<NormalNoise.NoiseParameters> noises;
    protected final Holder<NoiseGeneratorSettings> settings;
    private final Aquifer.FluidPicker globalFluidPicker;

    public static void submitRegistration(BiConsumer<Codec<? extends ChunkGenerator>, ResourceLocation> consumer) {
        consumer.accept(CODEC, ResourceLocationHelper.prefix("skyblock"));
    }

    public static boolean isWorldSkyblock(Level world) {
        ServerChunkCache chunkCache;
        ChunkSource chunkSource = world.m_7726_();
        return chunkSource instanceof ServerChunkCache && (chunkCache = (ServerChunkCache)chunkSource).m_8481_() instanceof SkyblockChunkGenerator;
    }

    private SkyblockChunkGenerator(Registry<StructureSet> structureSets, Registry<NormalNoise.NoiseParameters> noises, BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(structureSets, Optional.empty(), biomeSource);
        this.noises = noises;
        this.settings = settings;
        NoiseGeneratorSettings genSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        this.defaultBlock = genSettings.f_64440_();
        Aquifer.FluidStatus lava = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int i = genSettings.f_64444_();
        Aquifer.FluidStatus defaultFluid = new Aquifer.FluidStatus(i, genSettings.f_64441_());
        this.globalFluidPicker = (x, y, z) -> y < Math.min(-54, i) ? lava : defaultFluid;
    }

    public CompletableFuture<ChunkAccess> m_213908_(Registry<Biome> biomes, Executor executor, RandomState randomState, Blender blender, StructureManager structureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"init_biomes", () -> {
            this.doCreateBiomes(blender, randomState, structureManager, chunkAccess);
            return chunkAccess;
        }), Util.m_183991_());
    }

    private void doCreateBiomes(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        NoiseChunk chunk = chunkAccess.m_223012_(access -> this.createNoiseChunk((ChunkAccess)access, structureManager, blender, randomState));
        BiomeResolver biomeResolver = BelowZeroRetrogen.m_204531_((BiomeResolver)blender.m_183383_((BiomeResolver)this.f_62137_), (ChunkAccess)chunkAccess);
        chunkAccess.m_183442_(biomeResolver, ((NoiseChunkAccessor)chunk).botania_cachedClimateSampler(randomState.m_224578_(), ((NoiseGeneratorSettings)this.settings.m_203334_()).f_224370_()));
    }

    private NoiseChunk createNoiseChunk(ChunkAccess chunkAccess, StructureManager structureManager, Blender blender, RandomState randomState) {
        return NoiseChunk.m_224352_((ChunkAccess)chunkAccess, (RandomState)randomState, (DensityFunctions.BeardifierOrMarker)Beardifier.m_223937_((StructureManager)structureManager, (ChunkPos)chunkAccess.m_7697_()), (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.settings.m_203334_()), (Aquifer.FluidPicker)this.globalFluidPicker, (Blender)blender);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public int m_214096_(int x, int z, Heightmap.Types heightmapTypes, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return levelHeightAccessor.m_141937_();
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return new NoiseColumn(levelHeightAccessor.m_141937_(), new BlockState[0]);
    }

    public void m_213600_(List<String> strings, RandomState randomState, BlockPos pos) {
        DecimalFormat format = new DecimalFormat("0.000");
        NoiseRouter router = randomState.m_224578_();
        DensityFunction.SinglePointContext ctx = new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        double $$6 = router.f_209389_().m_207386_((DensityFunction.FunctionContext)ctx);
        String var10001 = format.format(router.f_209384_().m_207386_((DensityFunction.FunctionContext)ctx));
        strings.add("NoiseRouter T: " + var10001 + " V: " + format.format(router.f_224392_().m_207386_((DensityFunction.FunctionContext)ctx)) + " C: " + format.format(router.f_209386_().m_207386_((DensityFunction.FunctionContext)ctx)) + " E: " + format.format(router.f_209387_().m_207386_((DensityFunction.FunctionContext)ctx)) + " D: " + format.format(router.f_209388_().m_207386_((DensityFunction.FunctionContext)ctx)) + " W: " + format.format($$6) + " PV: " + format.format(NoiseRouterData.m_224435_((float)((float)$$6))) + " AS: " + format.format(router.f_209390_().m_207386_((DensityFunction.FunctionContext)ctx)) + " N: " + format.format(router.f_209391_().m_207386_((DensityFunction.FunctionContext)ctx)));
    }

    public void m_214194_(WorldGenRegion region, StructureManager structures, RandomState randomState, ChunkAccess chunk) {
    }

    public void m_213679_(WorldGenRegion worldGenRegion, long seed, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_64508_();
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_158688_();
    }

    public void m_6929_(WorldGenRegion region) {
    }
}

