/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class BlackHoleTalismanItem
extends Item {
    public static final String TAG_ACTIVE = "active";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_COUNT = "blockCount";

    public BlackHoleTalismanItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (BlackHoleTalismanItem.getBlock(stack) != null && player.m_36341_()) {
            ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
            player.m_5496_(BotaniaSounds.blackHoleTalismanConfigure, 1.0f, 1.0f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack toUse;
        InteractionResult result;
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction side = ctx.m_43719_();
        Player player = ctx.m_43723_();
        BlockState state = world.m_8055_(pos);
        ItemStack stack = ctx.m_43722_();
        if (!state.m_60795_() && BlackHoleTalismanItem.setBlock(stack, state.m_60734_())) {
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        Block bBlock = BlackHoleTalismanItem.getBlock(stack);
        if (bBlock == null) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof Container) {
            Container container = (Container)tile;
            if (!world.f_46443_) {
                ItemStack toAdd = new ItemStack((ItemLike)bBlock);
                int maxSize = toAdd.m_41741_();
                toAdd.m_41764_(BlackHoleTalismanItem.remove(stack, maxSize));
                ItemStack remainder = HopperBlockEntity.m_59326_(null, (Container)container, (ItemStack)toAdd, (Direction)side);
                if (!remainder.m_41619_()) {
                    BlackHoleTalismanItem.add(stack, remainder.m_41613_());
                }
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if ((player == null || player.m_150110_().f_35937_ || BlackHoleTalismanItem.getBlockCount(stack) > 0) && (result = PlayerHelper.substituteUse(ctx, toUse = new ItemStack((ItemLike)bBlock))).m_19077_()) {
            if (!world.f_46443_) {
                BlackHoleTalismanItem.remove(stack, 1);
                ItemsRemainingRenderHandler.send(player, toUse, BlackHoleTalismanItem.getBlockCount(stack));
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        Block block = BlackHoleTalismanItem.getBlock(itemstack);
        if (!entity.f_19853_.f_46443_ && ItemNBTHelper.getBoolean(itemstack, TAG_ACTIVE, false) && block != null && entity instanceof Player) {
            Player player = (Player)entity;
            BlackHoleTalismanItem.suckFromPlayerInv(itemstack, block, player);
        }
    }

    private static void suckFromPlayerInv(ItemStack talisman, Block toTake, Player player) {
        int i;
        int highestIdx = -1;
        int[] counts = new int[player.m_150109_().m_6643_() - player.m_150109_().f_35975_.size()];
        for (i = 0; i < counts.length; ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || toTake.m_5456_() != stack.m_41720_() || stack.m_41783_() != null && !stack.m_41783_().m_128456_()) continue;
            counts[i] = stack.m_41613_();
            highestIdx = highestIdx == -1 ? i : (counts[i] > counts[highestIdx] && highestIdx > 8 ? i : highestIdx);
        }
        if (highestIdx != -1) {
            for (i = 0; i < counts.length; ++i) {
                int count = counts[i];
                if (count == 0) continue;
                BlackHoleTalismanItem.add(talisman, count);
                player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        Block block = BlackHoleTalismanItem.getBlock(stack);
        ItemStack bstack = new ItemStack((ItemLike)block);
        MutableComponent cand = super.m_7626_(stack).m_6881_();
        if (!bstack.m_41619_()) {
            cand.m_130946_(" (");
            cand.m_7220_((Component)bstack.m_41786_().m_6881_().m_130940_(ChatFormatting.GREEN));
            cand.m_130946_(")");
        }
        return cand;
    }

    private static boolean setBlock(ItemStack stack, Block block) {
        if (block.m_5456_() != Items.f_41852_ && (BlackHoleTalismanItem.getBlock(stack) == null || BlackHoleTalismanItem.getBlockCount(stack) == 0)) {
            ItemNBTHelper.setString(stack, TAG_BLOCK_NAME, Registry.f_122824_.m_7981_((Object)block).toString());
            return true;
        }
        return false;
    }

    private static void add(ItemStack stack, int count) {
        int current = BlackHoleTalismanItem.getBlockCount(stack);
        BlackHoleTalismanItem.setCount(stack, current + count);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        Block block = BlackHoleTalismanItem.getBlock(stack);
        if (block != null) {
            int count = BlackHoleTalismanItem.getBlockCount(stack);
            stacks.add((Component)Component.m_237113_((String)(count + " ")).m_7220_(new ItemStack((ItemLike)block).m_41786_()).m_130940_(ChatFormatting.GRAY));
        }
        if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.active"));
        } else {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.inactive"));
        }
    }

    private static void setCount(ItemStack stack, int count) {
        ItemNBTHelper.setInt(stack, TAG_BLOCK_COUNT, count);
    }

    public static int remove(ItemStack stack, int count) {
        int current = BlackHoleTalismanItem.getBlockCount(stack);
        BlackHoleTalismanItem.setCount(stack, Math.max(current - count, 0));
        return Math.min(current, count);
    }

    private static String getBlockName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_BLOCK_NAME, "");
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        ResourceLocation id = ResourceLocation.m_135820_((String)BlackHoleTalismanItem.getBlockName(stack));
        if (id != null) {
            return Registry.f_122824_.m_6612_(id).orElse(null);
        }
        return null;
    }

    public static int getBlockCount(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_BLOCK_COUNT, 0);
    }

    public boolean m_142207_(@NotNull ItemStack talisman, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        Block existingBlock;
        ItemStack toInsert;
        Block blockToInsert;
        if (clickAction == ClickAction.SECONDARY && (blockToInsert = Block.m_49814_((Item)(toInsert = slot.m_7993_()).m_41720_())) != Blocks.f_50016_ && ((existingBlock = BlackHoleTalismanItem.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            ItemStack taken = slot.m_150647_(toInsert.m_41613_(), Integer.MAX_VALUE, player);
            if (existingBlock == null) {
                BlackHoleTalismanItem.setBlock(talisman, blockToInsert);
                BlackHoleTalismanItem.setCount(talisman, taken.m_41613_());
            } else {
                BlackHoleTalismanItem.add(talisman, taken.m_41613_());
            }
            return true;
        }
        return false;
    }

    public boolean m_142305_(@NotNull ItemStack talisman, @NotNull ItemStack toInsert, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess cursorAccess) {
        Block existingBlock;
        Block blockToInsert;
        if (clickAction == ClickAction.SECONDARY && (blockToInsert = Block.m_49814_((Item)toInsert.m_41720_())) != Blocks.f_50016_ && ((existingBlock = BlackHoleTalismanItem.getBlock(talisman)) == null || existingBlock == blockToInsert)) {
            if (existingBlock == null) {
                BlackHoleTalismanItem.setBlock(talisman, blockToInsert);
                BlackHoleTalismanItem.setCount(talisman, toInsert.m_41613_());
            } else {
                BlackHoleTalismanItem.add(talisman, toInsert.m_41613_());
            }
            cursorAccess.m_142104_(ItemStack.f_41583_);
            return true;
        }
        return false;
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        private final ItemStack stack;

        public BlockProviderImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            int count;
            Block stored = BlackHoleTalismanItem.getBlock(this.stack);
            if (stored == block && (count = BlackHoleTalismanItem.getBlockCount(this.stack)) > 0) {
                if (doit) {
                    BlackHoleTalismanItem.setCount(this.stack, count - 1);
                }
                return true;
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            Block stored = BlackHoleTalismanItem.getBlock(this.stack);
            if (stored == block) {
                return BlackHoleTalismanItem.getBlockCount(this.stack);
            }
            return 0;
        }
    }
}

