/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.handler;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public abstract class EquipmentHandler {
    public static EquipmentHandler instance;

    public static void init() {
        if (instance == null) {
            instance = XplatAbstractions.INSTANCE.tryCreateEquipmentHandler();
        }
        if (instance == null) {
            instance = new InventoryEquipmentHandler();
        }
    }

    public static Container getAllWorn(LivingEntity living) {
        return instance.getAllWornItems(living);
    }

    public static ItemStack findOrEmpty(Item item, LivingEntity living) {
        return instance.findItem(item, living);
    }

    public static ItemStack findOrEmpty(Predicate<ItemStack> pred, LivingEntity living) {
        return instance.findItem(pred, living);
    }

    protected abstract Container getAllWornItems(LivingEntity var1);

    protected abstract ItemStack findItem(Item var1, LivingEntity var2);

    protected abstract ItemStack findItem(Predicate<ItemStack> var1, LivingEntity var2);

    public abstract void onInit(Item var1);

    public boolean isAccessory(ItemStack stack) {
        return stack.m_204117_(BotaniaTags.Items.RODS) || stack.m_41720_() instanceof BaubleItem || XplatAbstractions.INSTANCE.findManaItem(stack) != null;
    }

    public static class InventoryEquipmentHandler
    extends EquipmentHandler {
        private final Map<Player, ItemStack[]> map = new WeakHashMap<Player, ItemStack[]>();

        public void onPlayerTick(Player player) {
            player.f_19853_.m_46473_().m_6180_("botania:tick_wearables");
            ItemStack[] oldStacks = this.map.computeIfAbsent(player, p -> {
                Object[] array = new ItemStack[9];
                Arrays.fill(array, ItemStack.f_41583_);
                return array;
            });
            Inventory inv = player.m_150109_();
            for (int i = 0; i < 9; ++i) {
                ItemStack old = oldStacks[i];
                ItemStack current = inv.m_8020_(i);
                if (!ItemStack.m_41728_((ItemStack)old, (ItemStack)current)) {
                    BaubleItem bauble;
                    Item item = old.m_41720_();
                    if (item instanceof BaubleItem) {
                        bauble = (BaubleItem)item;
                        player.m_21204_().m_22161_(bauble.getEquippedAttributeModifiers(old));
                        bauble.onUnequipped(old, (LivingEntity)player);
                    }
                    if (InventoryEquipmentHandler.canEquip(current, (LivingEntity)player)) {
                        bauble = (BaubleItem)current.m_41720_();
                        player.m_21204_().m_22178_(bauble.getEquippedAttributeModifiers(current));
                        bauble.onEquipped(current, (LivingEntity)player);
                    }
                    oldStacks[i] = current.m_41777_();
                }
                if (!InventoryEquipmentHandler.canEquip(current, (LivingEntity)player)) continue;
                ((BaubleItem)current.m_41720_()).onWornTick(current, (LivingEntity)player);
            }
            player.f_19853_.m_46473_().m_7238_();
        }

        @Override
        protected Container getAllWornItems(LivingEntity living) {
            return new SimpleContainer(0);
        }

        @Override
        protected ItemStack findItem(Item item, LivingEntity living) {
            if (living instanceof Player) {
                Player player = (Player)living;
                Inventory inv = player.m_150109_();
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = inv.m_8020_(i);
                    if (!stack.m_150930_(item) || !InventoryEquipmentHandler.canEquip(stack, living)) continue;
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        }

        @Override
        protected ItemStack findItem(Predicate<ItemStack> pred, LivingEntity living) {
            if (living instanceof Player) {
                Player player = (Player)living;
                Inventory inv = player.m_150109_();
                for (int i = 0; i < 9; ++i) {
                    ItemStack stack = inv.m_8020_(i);
                    if (!pred.test(stack) || !InventoryEquipmentHandler.canEquip(stack, living)) continue;
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        }

        @Override
        public void onInit(Item item) {
        }

        private static boolean canEquip(ItemStack stack, LivingEntity living) {
            BaubleItem bauble;
            Item item = stack.m_41720_();
            return item instanceof BaubleItem && (bauble = (BaubleItem)item).canEquip(stack, living);
        }
    }
}

