/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.AdditionalLanternsClient;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.additionallanterns.VanillaLanternEvents;
import com.supermartijn642.additionallanterns.data.LanternBlockModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternBlockStateGenerator;
import com.supermartijn642.additionallanterns.data.LanternItemModelGenerator;
import com.supermartijn642.additionallanterns.data.LanternLanguageGenerator;
import com.supermartijn642.additionallanterns.data.LanternLootTableGenerator;
import com.supermartijn642.additionallanterns.data.LanternRecipeGenerator;
import com.supermartijn642.additionallanterns.data.LanternTagGenerator;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod(value="additionallanterns")
public class AdditionalLanterns {
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"additionallanterns", () -> LanternMaterial.NORMAL.getLanternBlock().m_5456_());

    public AdditionalLanterns() {
        VanillaLanternEvents.registerEventHandlers();
        AdditionalLanterns.register();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> AdditionalLanternsClient::register);
        AdditionalLanterns.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"additionallanterns");
        for (LanternMaterial material : LanternMaterial.values()) {
            handler.registerBlockCallback(material::registerBlocks);
            handler.registerItemCallback(material::registerItems);
        }
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"additionallanterns");
        handler.addGenerator(LanternBlockModelGenerator::new);
        handler.addGenerator(LanternItemModelGenerator::new);
        handler.addGenerator(LanternBlockStateGenerator::new);
        handler.addGenerator(LanternLanguageGenerator::new);
        handler.addGenerator(LanternLootTableGenerator::new);
        handler.addGenerator(LanternTagGenerator::new);
        handler.addGenerator(LanternRecipeGenerator::new);
    }
}

