/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.world.gen.feature;

import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.vanilla.VanillaDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class VanillaOreFeature
extends Feature<NoneFeatureConfiguration> {
    private final VanillaDepositModel model;
    private final EmendatusDataRegistry registry;
    private final Lazy<List<OreConfiguration.TargetBlockState>> lazyList;

    public VanillaOreFeature(VanillaDepositModel model, EmendatusDataRegistry registry) {
        super(NoneFeatureConfiguration.f_67815_);
        this.model = model;
        this.registry = registry;
        this.lazyList = Lazy.of(this::createTargetStateList);
    }

    private List<OreConfiguration.TargetBlockState> createTargetStateList() {
        ArrayList<OreConfiguration.TargetBlockState> states = new ArrayList<OreConfiguration.TargetBlockState>();
        if (this.model.getBlock() != null) {
            Block oreBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.model.getBlock()));
            if (oreBlock == null) {
                EmendatusEnigmatica.LOGGER.warn("Unable to find {} in forge registries", (Object)this.model.getBlock());
                return states;
            }
            for (StrataModel stratum : this.registry.getStrata()) {
                if (!this.model.getFillerTypes().contains(stratum.getId())) continue;
                Block stratumBlock = (Block)ForgeRegistries.BLOCKS.getValue(stratum.getFillerType());
                if (stratumBlock == null) {
                    EmendatusEnigmatica.LOGGER.warn("Unable to find {} in forge registries", (Object)stratum.getFillerType());
                    continue;
                }
                states.add(OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(stratumBlock), (BlockState)oreBlock.m_49966_()));
            }
            return states;
        }
        for (MaterialModel material : this.registry.getMaterials()) {
            if (!material.getId().equals(this.model.getMaterial())) continue;
            for (StrataModel stratum : this.registry.getStrata()) {
                if (!this.model.getFillerTypes().contains(stratum.getId())) continue;
                Block stratumBlock = (Block)ForgeRegistries.BLOCKS.getValue(stratum.getFillerType());
                if (stratumBlock == null) {
                    EmendatusEnigmatica.LOGGER.warn("Unable to find {} in forge registries", (Object)stratum.getFillerType());
                    continue;
                }
                RegistryObject blockRegistryObject = (RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)material.getId());
                if (blockRegistryObject == null) {
                    EmendatusEnigmatica.LOGGER.warn("Unable to find the combination of {} and {} in the ore block table", (Object)stratum.getId(), (Object)material.getId());
                    continue;
                }
                BlockState oreBlockstate = ((Block)blockRegistryObject.get()).m_49966_();
                states.add(OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(stratumBlock), (BlockState)oreBlockstate));
            }
        }
        return states;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> config) {
        RandomSource rand = config.m_225041_();
        BlockPos pos = config.m_159777_();
        WorldGenLevel reader = config.m_159774_();
        float f = rand.m_188501_() * (float)Math.PI;
        float f1 = (float)this.model.getSize() / 8.0f;
        int i = Mth.m_14167_((float)(((float)this.model.getSize() / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d0 = (double)pos.m_123341_() + Math.sin(f) * (double)f1;
        double d1 = (double)pos.m_123341_() - Math.sin(f) * (double)f1;
        double d2 = (double)pos.m_123343_() + Math.cos(f) * (double)f1;
        double d3 = (double)pos.m_123343_() - Math.cos(f) * (double)f1;
        int j = 2;
        double d4 = pos.m_123342_() + rand.m_188503_(3) - 2;
        double d5 = pos.m_123342_() + rand.m_188503_(3) - 2;
        int k = pos.m_123341_() - Mth.m_14167_((float)f1) - i;
        int l = pos.m_123342_() - 2 - i;
        int i1 = pos.m_123343_() - Mth.m_14167_((float)f1) - i;
        int j1 = 2 * (Mth.m_14167_((float)f1) + i);
        int k1 = 2 * (2 + i);
        for (int l1 = k; l1 <= k + j1; ++l1) {
            for (int i2 = i1; i2 <= i1 + j1; ++i2) {
                if (l > reader.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, l1, i2)) continue;
                return this.doPlace(reader, rand, d0, d1, d2, d3, d4, d5, k, l, i1, j1, k1);
            }
        }
        return false;
    }

    protected boolean doPlace(WorldGenLevel reader, RandomSource rand, double p_225175_, double p_225176_, double p_225177_, double p_225178_, double p_225179_, double p_225180_, int p_225181_, int p_225182_, int p_225183_, int p_225184_, int p_225185_) {
        int i = 0;
        BitSet bitset = new BitSet(p_225184_ * p_225185_ * p_225184_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = this.model.getSize();
        double[] adouble = new double[j * 4];
        for (int k = 0; k < j; ++k) {
            float f = (float)k / (float)j;
            double d0 = Mth.m_14139_((double)f, (double)p_225175_, (double)p_225176_);
            double d1 = Mth.m_14139_((double)f, (double)p_225179_, (double)p_225180_);
            double d2 = Mth.m_14139_((double)f, (double)p_225177_, (double)p_225178_);
            double d3 = rand.m_188500_() * (double)j / 16.0;
            double d4 = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * d3 + 1.0) / 2.0;
            adouble[k * 4 + 0] = d0;
            adouble[k * 4 + 1] = d1;
            adouble[k * 4 + 2] = d2;
            adouble[k * 4 + 3] = d4;
        }
        for (int l3 = 0; l3 < j - 1; ++l3) {
            if (adouble[l3 * 4 + 3] <= 0.0) continue;
            for (int i4 = l3 + 1; i4 < j; ++i4) {
                double d12;
                double d10;
                double d8;
                double d14;
                if (adouble[i4 * 4 + 3] <= 0.0 || !((d14 = adouble[l3 * 4 + 3] - adouble[i4 * 4 + 3]) * d14 > (d8 = adouble[l3 * 4 + 0] - adouble[i4 * 4 + 0]) * d8 + (d10 = adouble[l3 * 4 + 1] - adouble[i4 * 4 + 1]) * d10 + (d12 = adouble[l3 * 4 + 2] - adouble[i4 * 4 + 2]) * d12)) continue;
                if (d14 > 0.0) {
                    adouble[i4 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[l3 * 4 + 3] = -1.0;
            }
        }
        List targetBlockStates = (List)this.lazyList.get();
        try (BulkSectionAccess bulksectionaccess = new BulkSectionAccess((LevelAccessor)reader);){
            for (int j4 = 0; j4 < j; ++j4) {
                double d9 = adouble[j4 * 4 + 3];
                if (d9 < 0.0) continue;
                double d11 = adouble[j4 * 4 + 0];
                double d13 = adouble[j4 * 4 + 1];
                double d15 = adouble[j4 * 4 + 2];
                int k4 = Math.max(Mth.m_14107_((double)(d11 - d9)), p_225181_);
                int l = Math.max(Mth.m_14107_((double)(d13 - d9)), p_225182_);
                int i1 = Math.max(Mth.m_14107_((double)(d15 - d9)), p_225183_);
                int j1 = Math.max(Mth.m_14107_((double)(d11 + d9)), k4);
                int k1 = Math.max(Mth.m_14107_((double)(d13 + d9)), l);
                int l1 = Math.max(Mth.m_14107_((double)(d15 + d9)), i1);
                for (int i2 = k4; i2 <= j1; ++i2) {
                    double d5 = ((double)i2 + 0.5 - d11) / d9;
                    if (!(d5 * d5 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        double d6 = ((double)j2 + 0.5 - d13) / d9;
                        if (!(d5 * d5 + d6 * d6 < 1.0)) continue;
                        block11: for (int k2 = i1; k2 <= l1; ++k2) {
                            LevelChunkSection levelchunksection;
                            int l2;
                            double d7 = ((double)k2 + 0.5 - d15) / d9;
                            if (!(d5 * d5 + d6 * d6 + d7 * d7 < 1.0) || reader.m_151562_(j2) || bitset.get(l2 = i2 - p_225181_ + (j2 - p_225182_) * p_225184_ + (k2 - p_225183_) * p_225184_ * p_225185_)) continue;
                            bitset.set(l2);
                            blockpos$mutableblockpos.m_122178_(i2, j2, k2);
                            if (!reader.m_180807_((BlockPos)blockpos$mutableblockpos) || (levelchunksection = bulksectionaccess.m_156104_((BlockPos)blockpos$mutableblockpos)) == null) continue;
                            int i3 = SectionPos.m_123207_((int)i2);
                            int j3 = SectionPos.m_123207_((int)j2);
                            int k3 = SectionPos.m_123207_((int)k2);
                            BlockState blockstate = levelchunksection.m_62982_(i3, j3, k3);
                            for (OreConfiguration.TargetBlockState oreconfiguration$targetblockstate : targetBlockStates) {
                                if (!VanillaOreFeature.canPlaceOre(blockstate, arg_0 -> ((BulkSectionAccess)bulksectionaccess).m_156110_(arg_0), rand, oreconfiguration$targetblockstate, blockpos$mutableblockpos)) continue;
                                levelchunksection.m_62991_(i3, j3, k3, oreconfiguration$targetblockstate.f_161033_, false);
                                ++i;
                                continue block11;
                            }
                        }
                    }
                }
            }
        }
        return i > 0;
    }

    public static boolean canPlaceOre(BlockState stateAtLocation, Function<BlockPos, BlockState> getState, RandomSource random, OreConfiguration.TargetBlockState stateToPlace, BlockPos.MutableBlockPos pos) {
        if (!stateToPlace.f_161032_.m_213865_(stateAtLocation, random)) {
            return false;
        }
        if (VanillaOreFeature.shouldSkipAirCheck(random, 0.5f)) {
            return true;
        }
        return !VanillaOreFeature.m_159750_(getState, (BlockPos)pos);
    }

    protected static boolean shouldSkipAirCheck(RandomSource random, float chance) {
        if (chance <= 0.0f) {
            return true;
        }
        if (chance >= 1.0f) {
            return false;
        }
        return random.m_188501_() >= chance;
    }
}

