/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.world.gen.feature;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.test.TestDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.TestOreFeatureConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;

public class TestOreFeature
extends Feature<TestOreFeatureConfig> {
    private TestDepositModel model;
    private final EmendatusDataRegistry registry;
    private ArrayList<CommonBlockDefinitionModel> blocks;
    private static final Direction[] DIRECTIONS = Direction.values();

    public TestOreFeature(Codec<TestOreFeatureConfig> codec, TestDepositModel model, EmendatusDataRegistry registry) {
        super(codec);
        this.model = model;
        this.registry = registry;
        this.blocks = new ArrayList();
        for (CommonBlockDefinitionModel block : model.getConfig().getBlocks()) {
            NonNullList filled = NonNullList.m_122780_((int)block.getWeight(), (Object)block);
            this.blocks.addAll((Collection<CommonBlockDefinitionModel>)filled);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<TestOreFeatureConfig> config) {
        RandomSource rand = config.m_225041_();
        BlockPos pos = config.m_159777_();
        WorldGenLevel level = config.m_159774_();
        int yTop = this.model.getConfig().getMaxYLevel();
        int yBottom = this.model.getConfig().getMinYLevel();
        int size = this.model.getConfig().getSize();
        return true;
    }

    private void placeBlock(WorldGenLevel reader, RandomSource rand, BlockPos pos, FeaturePlaceContext<TestOreFeatureConfig> config) {
        if (!((TestOreFeatureConfig)config.m_159778_()).target.m_213865_(reader.m_8055_(pos), rand)) {
            return;
        }
        int index = rand.m_188503_(this.blocks.size());
        try {
            CommonBlockDefinitionModel commonBlockDefinitionModel = this.blocks.get(index);
            if (commonBlockDefinitionModel.getBlock() != null) {
                Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(commonBlockDefinitionModel.getBlock()));
                reader.m_7731_(pos, block2.m_49966_(), 2);
            } else if (commonBlockDefinitionModel.getTag() != null) {
                ITag blockITag = ForgeRegistries.BLOCKS.tags().getTag(EETags.getBlockTag(new ResourceLocation(commonBlockDefinitionModel.getTag())));
                blockITag.getRandomElement(rand).ifPresent(block -> reader.m_7731_(pos, block.m_49966_(), 2));
            } else if (commonBlockDefinitionModel.getMaterial() != null) {
                BlockState currentFiller = reader.m_8055_(pos);
                String fillerId = ForgeRegistries.BLOCKS.getKey((Object)currentFiller.m_60734_()).toString();
                Integer strataIndex = this.registry.getStrataByIndex().getOrDefault(fillerId, null);
                if (strataIndex != null) {
                    StrataModel stratum = this.registry.getStrata().get(strataIndex);
                    Block block3 = (Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)commonBlockDefinitionModel.getMaterial())).get();
                    reader.m_7731_(pos, block3.m_49966_(), 2);
                }
            }
        }
        catch (Exception e) {
            JsonElement modelJson = (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder(TestDepositModel.CODEC).apply(this.model)).result().get();
            EmendatusEnigmatica.LOGGER.error("index: " + index + ", model: " + new Gson().toJson(modelJson));
            e.printStackTrace();
        }
    }
}

