/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.world.gen.feature;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.geode.GeodeDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.sample.SampleBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.GeodeOreFeatureConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;

public class GeodeOreFeature
extends Feature<GeodeOreFeatureConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();
    private final List<CommonBlockDefinitionModel> outerShellBlocks;
    private final List<CommonBlockDefinitionModel> innerShellBlocks;
    private final List<CommonBlockDefinitionModel> innerBlocks;
    private final List<CommonBlockDefinitionModel> fillBlocks;
    private final List<SampleBlockDefinitionModel> sampleBlocks;
    private final List<BlockState> clusters;
    private final GeodeDepositModel model;
    private final EmendatusDataRegistry registry;
    private boolean placed = false;

    public GeodeOreFeature(Codec<GeodeOreFeatureConfig> codec, GeodeDepositModel model, EmendatusDataRegistry registry) {
        super(codec);
        NonNullList filled;
        this.model = model;
        this.registry = registry;
        this.outerShellBlocks = new ArrayList<CommonBlockDefinitionModel>();
        for (CommonBlockDefinitionModel outerShellBlock : model.getOuterShellBlocks()) {
            filled = NonNullList.m_122780_((int)outerShellBlock.getWeight(), (Object)outerShellBlock);
            this.outerShellBlocks.addAll((Collection<CommonBlockDefinitionModel>)filled);
        }
        this.innerShellBlocks = new ArrayList<CommonBlockDefinitionModel>();
        for (CommonBlockDefinitionModel innerShellBlock : model.getInnerShellBlocks()) {
            filled = NonNullList.m_122780_((int)innerShellBlock.getWeight(), (Object)innerShellBlock);
            this.innerShellBlocks.addAll((Collection<CommonBlockDefinitionModel>)filled);
        }
        this.innerBlocks = new ArrayList<CommonBlockDefinitionModel>();
        for (CommonBlockDefinitionModel innerBlock : model.getInnerBlocks()) {
            filled = NonNullList.m_122780_((int)innerBlock.getWeight(), (Object)innerBlock);
            this.innerBlocks.addAll((Collection<CommonBlockDefinitionModel>)filled);
        }
        this.fillBlocks = new ArrayList<CommonBlockDefinitionModel>();
        for (CommonBlockDefinitionModel fillBlock : model.getFillBlocks()) {
            filled = NonNullList.m_122780_((int)fillBlock.getWeight(), (Object)fillBlock);
            this.fillBlocks.addAll((Collection<CommonBlockDefinitionModel>)filled);
        }
        this.clusters = new ArrayList<BlockState>();
        for (String cluster : model.getClusters()) {
            BlockState clusterBlockstate = Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(cluster))).m_49966_();
            NonNullList filled2 = NonNullList.m_122780_((int)1, (Object)clusterBlockstate);
            this.clusters.addAll((Collection<BlockState>)filled2);
        }
        this.sampleBlocks = new ArrayList<SampleBlockDefinitionModel>();
        for (SampleBlockDefinitionModel sampleBlock : model.getSampleBlocks()) {
            filled = NonNullList.m_122780_((int)sampleBlock.getWeight(), (Object)sampleBlock);
            this.sampleBlocks.addAll((Collection<SampleBlockDefinitionModel>)filled);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<GeodeOreFeatureConfig> config) {
        RandomSource rand = config.m_225041_();
        BlockPos pos = config.m_159777_();
        WorldGenLevel level = config.m_159774_();
        UniformInt outerWallDistance = UniformInt.m_146622_((int)4, (int)6);
        UniformInt distributionPoint = UniformInt.m_146622_((int)3, (int)4);
        UniformInt pointOffset = UniformInt.m_146622_((int)1, (int)2);
        int invalidBlocksThreshold = 1;
        double noiseMultiplier = 0.05;
        LinkedList list = Lists.newLinkedList();
        int k = distributionPoint.m_214085_(rand);
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.m_7328_()));
        NormalNoise normalnoise = NormalNoise.m_230504_((RandomSource)worldgenrandom, (int)-4, (double[])new double[]{1.0});
        LinkedList list1 = Lists.newLinkedList();
        double d0 = (double)k / (double)outerWallDistance.m_142737_();
        double d1 = 1.0 / Math.sqrt(1.7);
        double d2 = 1.0 / Math.sqrt(2.2 + d0);
        double d3 = 1.0 / Math.sqrt(3.2 + d0);
        double d4 = 1.0 / Math.sqrt(4.2 + d0);
        double d5 = 1.0 / Math.sqrt(2.0 + rand.m_188500_() / 2.0 + (k > 3 ? d0 : 0.0));
        boolean flag = (double)rand.m_188501_() < this.model.getCrackChance();
        int l = 0;
        for (int i1 = 0; i1 < k; ++i1) {
            int l1;
            int k1;
            int j1 = outerWallDistance.m_214085_(rand);
            BlockPos blockpos1 = pos.m_7918_(j1, k1 = outerWallDistance.m_214085_(rand), l1 = outerWallDistance.m_214085_(rand));
            BlockState blockstate = level.m_8055_(blockpos1);
            if ((blockstate.m_60795_() || blockstate.m_204336_(BlockTags.f_144289_)) && ++l > invalidBlocksThreshold) {
                return false;
            }
            list.add(Pair.of((Object)blockpos1, (Object)pointOffset.m_214085_(rand)));
        }
        if (flag) {
            int i2 = rand.m_188503_(4);
            int j2 = k * 2 + 1;
            if (i2 == 0) {
                list1.add(pos.m_7918_(j2, 7, 0));
                list1.add(pos.m_7918_(j2, 5, 0));
                list1.add(pos.m_7918_(j2, 1, 0));
            } else if (i2 == 1) {
                list1.add(pos.m_7918_(0, 7, j2));
                list1.add(pos.m_7918_(0, 5, j2));
                list1.add(pos.m_7918_(0, 1, j2));
            } else if (i2 == 2) {
                list1.add(pos.m_7918_(j2, 7, j2));
                list1.add(pos.m_7918_(j2, 5, j2));
                list1.add(pos.m_7918_(j2, 1, j2));
            } else {
                list1.add(pos.m_7918_(0, 7, 0));
                list1.add(pos.m_7918_(0, 5, 0));
                list1.add(pos.m_7918_(0, 1, 0));
            }
        }
        ArrayList list2 = Lists.newArrayList();
        Predicate predicate = GeodeOreFeature.m_204735_((TagKey)BlockTags.f_144287_);
        for (BlockPos blockpos3 : BlockPos.m_121940_((BlockPos)pos.m_7918_(-16, -16, -16), (BlockPos)pos.m_7918_(16, 16, 16))) {
            double d8 = normalnoise.m_75380_((double)blockpos3.m_123341_(), (double)blockpos3.m_123342_(), (double)blockpos3.m_123343_()) * noiseMultiplier;
            double d6 = 0.0;
            double d7 = 0.0;
            for (Pair pair : list) {
                d6 += Mth.m_14193_((double)(blockpos3.m_123331_((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + d8;
            }
            for (BlockPos blockpos6 : list1) {
                d7 += Mth.m_14193_((double)(blockpos3.m_123331_((Vec3i)blockpos6) + 2.0)) + d8;
            }
            if (d6 < d4) continue;
            if (flag && d7 >= d5 && d6 < d1) {
                this.m_159742_(level, blockpos3, Blocks.f_50016_.m_49966_(), predicate);
                for (Direction direction1 : DIRECTIONS) {
                    BlockPos blockpos2 = blockpos3.m_121945_(direction1);
                    FluidState fluidstate = level.m_6425_(blockpos2);
                    if (fluidstate.m_76178_()) continue;
                    level.m_186469_(blockpos2, fluidstate.m_76152_(), 0);
                }
                continue;
            }
            if (d6 >= d1) {
                this.placeBlock(level, rand, blockpos3, this.fillBlocks, predicate, config);
                continue;
            }
            if (d6 >= d2) {
                this.placeBlock(level, rand, blockpos3, this.innerBlocks, predicate, config);
                if (!((double)rand.m_188501_() < 0.35)) continue;
                list2.add(blockpos3.m_7949_());
                continue;
            }
            if (d6 >= d3) {
                this.placeBlock(level, rand, blockpos3, this.innerShellBlocks, predicate, config);
                continue;
            }
            if (!(d6 >= d4)) continue;
            this.placeBlock(level, rand, blockpos3, this.outerShellBlocks, predicate, config);
        }
        if (!this.clusters.isEmpty()) {
            block5: for (BlockPos blockpos4 : list2) {
                int index = rand.m_188503_(this.clusters.size());
                BlockState blockstate1 = this.clusters.get(index);
                for (Direction direction : DIRECTIONS) {
                    if (blockstate1.m_61138_((Property)BlockStateProperties.f_61372_)) {
                        blockstate1 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
                    }
                    BlockPos blockpos5 = blockpos4.m_121945_(direction);
                    BlockState blockstate2 = level.m_8055_(blockpos5);
                    if (blockstate1.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        blockstate1 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(blockstate2.m_60819_().m_76170_()));
                    }
                    if (!BuddingAmethystBlock.m_152734_((BlockState)blockstate2) || !(level.m_8055_(blockpos4).m_60734_() instanceof BuddingAmethystBlock)) continue;
                    this.m_159742_(level, blockpos5, blockstate1, predicate);
                    continue block5;
                }
            }
        }
        if (rand.m_188503_(100) < this.model.getChance() && !this.sampleBlocks.isEmpty()) {
            this.placeSurfaceSample(rand, pos, level);
        }
        return true;
    }

    private void placeBlock(WorldGenLevel level, RandomSource rand, BlockPos pos, List<CommonBlockDefinitionModel> blocks, Predicate<BlockState> predicate, FeaturePlaceContext<GeodeOreFeatureConfig> config) {
        if (!predicate.test(level.m_8055_(pos))) {
            return;
        }
        if (!((GeodeOreFeatureConfig)config.m_159778_()).target.m_213865_(level.m_8055_(pos), rand)) {
            return;
        }
        int index = rand.m_188503_(blocks.size());
        CommonBlockDefinitionModel commonBlockDefinitionModel = blocks.get(index);
        if (commonBlockDefinitionModel.getBlock() != null) {
            Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(commonBlockDefinitionModel.getBlock()));
            level.m_7731_(pos, block2.m_49966_(), 2);
        } else if (commonBlockDefinitionModel.getTag() != null) {
            ITag blockITag = ForgeRegistries.BLOCKS.tags().getTag(EETags.getBlockTag(new ResourceLocation(commonBlockDefinitionModel.getTag())));
            blockITag.getRandomElement(rand).ifPresent(block -> level.m_7731_(pos, block.m_49966_(), 2));
        } else if (commonBlockDefinitionModel.getMaterial() != null) {
            BlockState currentFiller = level.m_8055_(pos);
            String fillerId = ForgeRegistries.BLOCKS.getKey((Object)currentFiller.m_60734_()).toString();
            Integer strataIndex = this.registry.getStrataByIndex().getOrDefault(fillerId, null);
            if (strataIndex != null) {
                StrataModel stratum = this.registry.getStrata().get(strataIndex);
                Block block3 = (Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)commonBlockDefinitionModel.getMaterial())).get();
                level.m_7731_(pos, block3.m_49966_(), 2);
            }
        }
        this.placed = true;
    }

    private void placeSampleBlock(WorldGenLevel level, RandomSource rand, BlockPos samplePos) {
        try {
            int index = rand.m_188503_(this.sampleBlocks.size());
            SampleBlockDefinitionModel sampleBlockDefinitionModel = this.sampleBlocks.get(index);
            if (sampleBlockDefinitionModel.getBlock() != null) {
                Block sampleBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(sampleBlockDefinitionModel.getBlock()));
                level.m_7731_(samplePos, sampleBlock.m_49966_(), 2);
            } else if (sampleBlockDefinitionModel.getTag() != null) {
                ITag blockITag = ForgeRegistries.BLOCKS.tags().getTag(EETags.getBlockTag(new ResourceLocation(sampleBlockDefinitionModel.getTag())));
                blockITag.getRandomElement(rand).ifPresent(block -> level.m_7731_(samplePos, block.m_49966_(), 2));
            } else if (sampleBlockDefinitionModel.getMaterial() != null) {
                Block sampleBlock = (Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)sampleBlockDefinitionModel.getStrata(), (Object)sampleBlockDefinitionModel.getMaterial())).get();
                level.m_7731_(samplePos, sampleBlock.m_49966_(), 2);
            }
        }
        catch (Exception e) {
            JsonElement modelJson = (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder(GeodeDepositModel.CODEC).apply(this.model)).result().get();
            EmendatusEnigmatica.LOGGER.error("model: " + new Gson().toJson(modelJson));
            e.printStackTrace();
        }
    }

    private void placeSurfaceSample(RandomSource rand, BlockPos pos, WorldGenLevel level) {
        BlockPos sample = new BlockPos(pos.m_123341_(), level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        if (level.m_8055_(sample.m_7495_()).m_60734_() == Blocks.f_49990_) {
            sample = new BlockPos(pos.m_123341_(), level.m_6924_(Heightmap.Types.OCEAN_FLOOR, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        }
        if (sample.m_123342_() > level.m_141937_() + 3 && level.m_8055_(sample.m_7495_()).m_60767_() != Material.f_76274_) {
            for (int l = 0; l < 3; ++l) {
                int i = rand.m_188503_(2);
                int j = rand.m_188503_(2);
                int k = rand.m_188503_(2);
                float f = (float)(i + j + k) * 0.333f + 0.5f;
                for (BlockPos samplePos : BlockPos.m_121940_((BlockPos)sample.m_7918_(-i, -j, -k), (BlockPos)sample.m_7918_(i, j, k))) {
                    if (!(samplePos.m_123331_((Vec3i)sample) <= (double)(f * f)) || !this.placed) continue;
                    this.placeSampleBlock(level, rand, samplePos);
                }
                sample = sample.m_7918_(-1 + rand.m_188503_(2), -rand.m_188503_(2), -1 + rand.m_188503_(2));
            }
        }
        this.placed = false;
    }
}

