/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.world.gen.feature;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.dike.DikeDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.sample.SampleBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.DikeOreFeatureConfig;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITag;

public class DikeOreFeature
extends Feature<DikeOreFeatureConfig> {
    private DikeDepositModel model;
    private final EmendatusDataRegistry registry;
    private ArrayList<CommonBlockDefinitionModel> blocks;
    private ArrayList<SampleBlockDefinitionModel> sampleBlocks;
    private boolean placed = false;

    public DikeOreFeature(Codec<DikeOreFeatureConfig> codec, DikeDepositModel model, EmendatusDataRegistry registry) {
        super(codec);
        NonNullList filled;
        this.model = model;
        this.registry = registry;
        this.blocks = new ArrayList();
        for (CommonBlockDefinitionModel block : model.getBlocks()) {
            filled = NonNullList.m_122780_((int)block.getWeight(), (Object)block);
            this.blocks.addAll((Collection<CommonBlockDefinitionModel>)filled);
        }
        this.sampleBlocks = new ArrayList();
        for (SampleBlockDefinitionModel sampleBlock : model.getSampleBlocks()) {
            filled = NonNullList.m_122780_((int)sampleBlock.getWeight(), (Object)sampleBlock);
            this.sampleBlocks.addAll((Collection<SampleBlockDefinitionModel>)filled);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<DikeOreFeatureConfig> config) {
        RandomSource rand = config.m_225041_();
        BlockPos pos = config.m_159777_();
        WorldGenLevel level = config.m_159774_();
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.m_7328_()));
        NormalNoise normalNoise = NormalNoise.m_230504_((RandomSource)worldgenRandom, (int)-2, (double[])new double[]{4.0});
        ChunkPos chunkPos = new ChunkPos(pos);
        int size = this.model.getSize();
        int xPos = chunkPos.m_45604_() + level.m_213780_().m_188503_(16);
        int zPos = chunkPos.m_45605_() + level.m_213780_().m_188503_(16);
        int yTop = this.model.getMaxYLevel();
        int yBottom = this.model.getMinYLevel();
        BlockPos basePos = new BlockPos(xPos, yBottom, zPos);
        for (int dY = yBottom; dY <= yTop; ++dY) {
            for (int dX = -size; dX <= size; ++dX) {
                for (int dZ = -size; dZ <= size; ++dZ) {
                    float dist = dX * dX + dZ * dZ;
                    if (dist > (float)size || !(normalNoise.m_75380_((double)dX, (double)dY, (double)dZ) >= 0.5)) continue;
                    this.placeBlock(level, rand, new BlockPos(basePos.m_123341_() + dX, dY, basePos.m_123343_() + dZ), config);
                }
            }
        }
        if (rand.m_188503_(100) < this.model.getChance() && !this.sampleBlocks.isEmpty()) {
            this.placeSurfaceSample(rand, pos, level);
        }
        return true;
    }

    private void placeBlock(WorldGenLevel level, RandomSource rand, BlockPos pos, FeaturePlaceContext<DikeOreFeatureConfig> config) {
        if (!((DikeOreFeatureConfig)config.m_159778_()).target.m_213865_(level.m_8055_(pos), rand)) {
            return;
        }
        int index = rand.m_188503_(this.blocks.size());
        try {
            CommonBlockDefinitionModel commonBlockDefinitionModel = this.blocks.get(index);
            if (commonBlockDefinitionModel.getBlock() != null) {
                Block block2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(commonBlockDefinitionModel.getBlock()));
                if (pos.m_123342_() >= commonBlockDefinitionModel.getMin() && pos.m_123342_() <= commonBlockDefinitionModel.getMax()) {
                    level.m_7731_(pos, block2.m_49966_(), 2);
                }
            } else if (commonBlockDefinitionModel.getTag() != null) {
                ITag blockITag = ForgeRegistries.BLOCKS.tags().getTag(EETags.getBlockTag(new ResourceLocation(commonBlockDefinitionModel.getTag())));
                blockITag.getRandomElement(rand).ifPresent(block -> {
                    if (pos.m_123342_() >= commonBlockDefinitionModel.getMin() && pos.m_123342_() <= commonBlockDefinitionModel.getMax()) {
                        level.m_7731_(pos, block.m_49966_(), 2);
                    }
                });
            } else if (commonBlockDefinitionModel.getMaterial() != null) {
                BlockState currentFiller = level.m_8055_(pos);
                String fillerId = ForgeRegistries.BLOCKS.getKey((Object)currentFiller.m_60734_()).toString();
                Integer strataIndex = this.registry.getStrataByIndex().getOrDefault(fillerId, null);
                if (strataIndex != null) {
                    StrataModel stratum = this.registry.getStrata().get(strataIndex);
                    Block block3 = (Block)((RegistryObject)EERegistrar.oreBlockTable.get((Object)stratum.getId(), (Object)commonBlockDefinitionModel.getMaterial())).get();
                    if (pos.m_123342_() >= commonBlockDefinitionModel.getMin() && pos.m_123342_() <= commonBlockDefinitionModel.getMax()) {
                        level.m_7731_(pos, block3.m_49966_(), 2);
                    }
                }
            }
            this.placed = true;
        }
        catch (Exception e) {
            JsonElement modelJson = (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder(DikeDepositModel.CODEC).apply(this.model)).result().get();
            EmendatusEnigmatica.LOGGER.error("index: " + index + ", model: " + new Gson().toJson(modelJson));
            e.printStackTrace();
        }
    }

    private void placeSampleBlock(WorldGenLevel level, RandomSource rand, BlockPos samplePos) {
        try {
            int index = rand.m_188503_(this.sampleBlocks.size());
            SampleBlockDefinitionModel sampleBlockDefinitionModel = this.sampleBlocks.get(index);
            if (sampleBlockDefinitionModel.getBlock() != null) {
                Block sampleBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(sampleBlockDefinitionModel.getBlock()));
                level.m_7731_(samplePos, sampleBlock.m_49966_(), 2);
            } else if (sampleBlockDefinitionModel.getTag() != null) {
                ITag blockITag = ForgeRegistries.BLOCKS.tags().getTag(EETags.getBlockTag(new ResourceLocation(sampleBlockDefinitionModel.getTag())));
                blockITag.getRandomElement(rand).ifPresent(block -> level.m_7731_(samplePos, block.m_49966_(), 2));
            } else if (sampleBlockDefinitionModel.getMaterial() != null) {
                Block sampleBlock = (Block)((RegistryObject)EERegistrar.oreSampleBlockTable.get((Object)sampleBlockDefinitionModel.getStrata(), (Object)sampleBlockDefinitionModel.getMaterial())).get();
                level.m_7731_(samplePos, sampleBlock.m_49966_(), 2);
            }
        }
        catch (Exception e) {
            JsonElement modelJson = (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder(DikeDepositModel.CODEC).apply(this.model)).result().get();
            EmendatusEnigmatica.LOGGER.error("model: " + new Gson().toJson(modelJson));
            e.printStackTrace();
        }
    }

    private void placeSurfaceSample(RandomSource rand, BlockPos pos, WorldGenLevel level) {
        BlockPos sample = new BlockPos(pos.m_123341_(), level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        if (level.m_8055_(sample.m_7495_()).m_60734_() == Blocks.f_49990_) {
            sample = new BlockPos(pos.m_123341_(), level.m_6924_(Heightmap.Types.OCEAN_FLOOR, pos.m_123341_(), pos.m_123343_()), pos.m_123343_());
        }
        if (sample.m_123342_() > level.m_141937_() + 3 && level.m_8055_(sample.m_7495_()).m_60767_() != Material.f_76274_) {
            for (int l = 0; l < 3; ++l) {
                int i = rand.m_188503_(2);
                int j = rand.m_188503_(2);
                int k = rand.m_188503_(2);
                float f = (float)(i + j + k) * 0.333f + 0.5f;
                for (BlockPos samplePos : BlockPos.m_121940_((BlockPos)sample.m_7918_(-i, -j, -k), (BlockPos)sample.m_7918_(i, j, k))) {
                    if (!(samplePos.m_123331_((Vec3i)sample) <= (double)(f * f)) || !this.placed) continue;
                    this.placeSampleBlock(level, rand, samplePos);
                }
                sample = sample.m_7918_(-1 + rand.m_188503_(2), -rand.m_188503_(2), -1 + rand.m_188503_(2));
            }
        }
        this.placed = false;
    }
}

