/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.util;

import java.awt.Color;

public class ColorHelper {
    public static int HEXtoDEC(String hex) {
        return Integer.parseInt(hex, 16);
    }

    public static Color HEXtoColor(String hex) {
        Color c;
        int n = hex.length();
        String digits = hex.startsWith("#") ? hex.substring(1, Math.min(hex.length(), 7)) : hex;
        if (digits.length() == 3) {
            String r = digits.substring(0, 1);
            String g = digits.substring(1, 2);
            String b = digits.substring(2, 3);
            digits = String.format("%s%s%s%s%s%s", r, r, g, g, b, b);
        }
        String hstr = "0x" + digits;
        try {
            c = Color.decode(hstr);
        }
        catch (NumberFormatException nfe) {
            c = null;
        }
        return c;
    }

    public static float[] HEXtoRGB(String hex) {
        int r = ColorHelper.HEXtoColor(hex).getRed();
        int g = ColorHelper.HEXtoColor(hex).getGreen();
        int b = ColorHelper.HEXtoColor(hex).getBlue();
        return Color.RGBtoHSB(r, g, b, null);
    }

    public static float[] INTtoRGB(int color) {
        float[] res = new float[]{(float)(color >> 24 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return res;
    }

    public static float[] HEXtoHSV(String hex) {
        float max;
        float r = ColorHelper.HEXtoColor(hex).getRed();
        float g = ColorHelper.HEXtoColor(hex).getGreen();
        float b = ColorHelper.HEXtoColor(hex).getBlue();
        float min = Math.min(Math.min(r, g), b);
        float v = max = Math.max(Math.max(r, g), b);
        float delta = max - min;
        if (max == 0.0f) {
            float s = 0.0f;
            float h = -1.0f;
            return new float[]{h, s, v};
        }
        float s = delta / max;
        float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        h *= 60.0f;
        if (h < 0.0f) {
            h += 360.0f;
        }
        h = (float)((double)h * 1.0);
        s = (float)((double)s * 100.0);
        v = (float)((double)v / 256.0 * 100.0);
        return new float[]{Math.round(h), Math.round(s), Math.round(v)};
    }

    public static float getHue(String hex) {
        float[] hsv = ColorHelper.HEXtoHSV(hex);
        return hsv[0];
    }

    public static float getSaturation(String hex) {
        float[] hsv = ColorHelper.HEXtoHSV(hex);
        return hsv[1];
    }

    public static float getValue(String hex) {
        float[] hsv = ColorHelper.HEXtoHSV(hex);
        return hsv[2];
    }

    public static String RGBtoDEC(float r, float g, float b) {
        String rs = Integer.toHexString((int)(r * 256.0f));
        String gs = Integer.toHexString((int)(g * 256.0f));
        String bs = Integer.toHexString((int)(b * 256.0f));
        return rs + gs + bs;
    }

    public static String HSVtoHEX(float h, float s, float v) {
        float B;
        float G;
        float R;
        h /= 360.0f;
        v /= 100.0f;
        if ((s /= 100.0f) == 0.0f) {
            R = v * 255.0f;
            G = v * 255.0f;
            B = v * 255.0f;
        } else {
            float var_b;
            float var_g;
            float var_r;
            float var_h = h * 6.0f;
            if (var_h == 6.0f) {
                var_h = 0.0f;
            }
            int var_i = (int)Math.floor(var_h);
            float var_1 = v * (1.0f - s);
            float var_2 = v * (1.0f - s * (var_h - (float)var_i));
            float var_3 = v * (1.0f - s * (1.0f - (var_h - (float)var_i)));
            if (var_i == 0) {
                var_r = v;
                var_g = var_3;
                var_b = var_1;
            } else if (var_i == 1) {
                var_r = var_2;
                var_g = v;
                var_b = var_1;
            } else if (var_i == 2) {
                var_r = var_1;
                var_g = v;
                var_b = var_3;
            } else if (var_i == 3) {
                var_r = var_1;
                var_g = var_2;
                var_b = v;
            } else if (var_i == 4) {
                var_r = var_3;
                var_g = var_1;
                var_b = v;
            } else {
                var_r = v;
                var_g = var_1;
                var_b = var_2;
            }
            R = var_r * 255.0f;
            G = var_g * 255.0f;
            B = var_b * 255.0f;
        }
        Object rs = Integer.toHexString((int)R);
        Object gs = Integer.toHexString((int)G);
        Object bs = Integer.toHexString((int)B);
        if (((String)rs).length() == 1) {
            rs = "0" + (String)rs;
        }
        if (((String)gs).length() == 1) {
            gs = "0" + (String)gs;
        }
        if (((String)bs).length() == 1) {
            bs = "0" + (String)bs;
        }
        return (String)rs + (String)gs + (String)bs;
    }

    public static String hueShift(String hex, int factor, boolean isHighlight) {
        float h = ColorHelper.getHue(hex);
        float s = ColorHelper.getSaturation(hex);
        float v = ColorHelper.getValue(hex);
        float h2 = 0.0f;
        float s2 = 0.0f;
        float v2 = 0.0f;
        if (isHighlight) {
            if (h >= 0.0f && h < 60.0f) {
                h2 = h + (float)(4 * factor);
                s2 = s - (float)(5 * factor);
                v2 = v + (float)(10 * factor);
            }
            if (h >= 60.0f && h < 120.0f) {
                h2 = h - (float)(4 * factor);
                s2 = s - (float)(5 * factor);
                v2 = v + (float)(10 * factor);
            }
            if (h >= 120.0f && h < 180.0f) {
                h2 = h + (float)(8 * factor);
                s2 = s - (float)(2 * factor);
                v2 = v + (float)(20 * factor);
            }
            if (h >= 180.0f && h < 240.0f) {
                h2 = h - (float)(8 * factor);
                s2 = s - (float)(2 * factor);
                v2 = v + (float)(20 * factor);
            }
            if (h >= 240.0f && h < 300.0f) {
                h2 = h + (float)(8 * factor);
                s2 = s - (float)(2 * factor);
                v2 = v + (float)(20 * factor);
            }
            if (h >= 300.0f && h <= 360.0f) {
                h2 = h + (float)(8 * factor);
                s2 = s - (float)(2 * factor);
                v2 = v + (float)(20 * factor);
            }
        } else {
            if (h >= 0.0f && h < 60.0f) {
                h2 = h - (float)(4 * factor);
                s2 = s + (float)(5 * factor);
                v2 = v - (float)(15 * factor);
            }
            if (h >= 60.0f && h < 120.0f) {
                h2 = h + (float)(4 * factor);
                s2 = s + (float)(5 * factor);
                v2 = v - (float)(15 * factor);
            }
            if (h >= 120.0f && h < 180.0f) {
                h2 = h - (float)(8 * factor);
                s2 = s + (float)(2 * factor);
                v2 = v - (float)(10 * factor);
            }
            if (h >= 180.0f && h < 240.0f) {
                h2 = h + (float)(8 * factor);
                s2 = s + (float)(2 * factor);
                v2 = v - (float)(10 * factor);
            }
            if (h >= 240.0f && h < 300.0f) {
                h2 = h - (float)(8 * factor);
                s2 = s + (float)(2 * factor);
                v2 = v - (float)(10 * factor);
            }
            if (h >= 300.0f && h <= 360.0f) {
                h2 = h - (float)(8 * factor);
                s2 = s + (float)(2 * factor);
                v2 = v - (float)(10 * factor);
            }
        }
        if (h2 < 0.0f || h2 > 360.0f) {
            h2 = (h2 + 360.0f) % 360.0f;
        }
        if (s2 < 0.0f) {
            s2 = 0.0f;
        }
        if (s2 > 100.0f) {
            s2 = 100.0f;
        }
        if (v2 < 0.0f) {
            v2 = 0.0f;
        }
        if (v2 > 100.0f) {
            v2 = 100.0f;
        }
        return ColorHelper.HSVtoHEX(h2, s2, v2);
    }
}

