/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ridanisaurus.emendatusenigmatica.items.BasicShieldItem;
import com.ridanisaurus.emendatusenigmatica.util.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ShieldTextureRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final ShieldTextureRenderer RENDERER = new ShieldTextureRenderer();
    private ShieldModel shieldModel;

    public ShieldTextureRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_6213_(@NotNull ResourceManager resourceManager) {
        this.shieldModel = new ShieldModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171179_));
    }

    public void m_108829_(@NotNull ItemStack stack, @NotNull ItemTransforms.TransformType transformType, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        matrix.m_85836_();
        matrix.m_85841_(1.0f, -1.0f, -1.0f);
        Item shield = stack.m_41720_();
        if (shield instanceof BasicShieldItem) {
            BasicShieldItem bsi = (BasicShieldItem)shield;
            if (bsi.getMaterialModel().getColors().getMaterialColor() == -1) {
                ResourceLocation rl = new ResourceLocation("emendatusenigmatica", "textures/models/armor/" + bsi.getMaterialModel().getId() + "_shield.png");
                RenderType renderType = RenderType.m_110458_((ResourceLocation)rl);
                this.doRender(stack, matrix, renderer, light, overlayLight, this.shieldModel, 1.0f, 1.0f, 1.0f, renderType);
            } else {
                for (int i = 0; i < 5; ++i) {
                    ResourceLocation rl = new ResourceLocation("emendatusenigmatica", "textures/armor/shield/0" + i + ".png");
                    RenderType renderType = RenderType.m_110458_((ResourceLocation)rl);
                    float[] secondary = ColorHelper.INTtoRGB(bsi.getColorForIndex(i));
                    this.doRender(stack, matrix, renderer, light, overlayLight, this.shieldModel, secondary[1], secondary[2], secondary[3], renderType);
                }
                ResourceLocation rl = new ResourceLocation("emendatusenigmatica", "textures/armor/shield/wood.png");
                RenderType renderType = RenderType.m_110458_((ResourceLocation)rl);
                this.doRender(stack, matrix, renderer, light, overlayLight, this.shieldModel, 1.0f, 1.0f, 1.0f, renderType);
            }
        }
        matrix.m_85849_();
    }

    private void doRender(ItemStack stack, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ShieldModel model, float r, float g, float b, RenderType renderType) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)renderer, (RenderType)renderType, (boolean)false, (boolean)stack.m_41790_());
        if (stack.m_41737_("BlockEntityTag") != null) {
            model.m_103711_().m_104306_(matrix, vertexConsumer, light, overlayLight, r, g, b, 1.0f);
        } else {
            model.m_7695_(matrix, vertexConsumer, light, overlayLight, r, g, b, 1.0f);
        }
    }
}

