/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.renderers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.config.EEConfig;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class PatreonRewardRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final Map<String, ItemStack> REWARD_MAP = new HashMap<String, ItemStack>();

    public PatreonRewardRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> playerModel) {
        super(playerModel);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        String name = player.m_36316_().getName();
        Level world = player.m_20193_();
        if (((Boolean)EEConfig.client.showPatreonReward.get()).booleanValue()) {
            matrixStack.m_85836_();
            ((PlayerModel)this.m_117386_()).f_102808_.m_104299_(matrixStack);
            matrixStack.m_85837_(0.0, -1.0, 0.0);
            matrixStack.m_85841_(0.3f, -0.3f, -0.3f);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(world.m_46467_() % 360L)));
            Minecraft.m_91087_().m_91291_().m_174242_((LivingEntity)player, REWARD_MAP.getOrDefault(name, ItemStack.f_41583_), ItemTransforms.TransformType.NONE, false, matrixStack, buffer, player.f_19853_, 0xF000F0, OverlayTexture.f_118083_, player.m_19879_());
            matrixStack.m_85849_();
        }
    }

    static {
        new FetchThread();
    }

    private static class FetchThread
    extends Thread {
        public FetchThread() {
            this.setName("emendatusenigmatica_support_fetcher");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            Gson jsonParser = new Gson();
            try {
                URL url = new URL("https://raw.githubusercontent.com/Ridanisaurus/EmendatusEnigmatica/EEV2-1.19/patreon_supporters_list.json");
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(url.openStream()));
                JsonObject main = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                for (Map.Entry entry : main.entrySet()) {
                    String name = (String)entry.getKey();
                    ItemStack item = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("emendatusenigmatica", "felinium_jaminite_ingot")));
                    REWARD_MAP.put(name, item);
                }
                EmendatusEnigmatica.LOGGER.info("Fetching supporter information was successful!");
                reader.close();
            }
            catch (Exception e) {
                EmendatusEnigmatica.LOGGER.warn("Fetching supporter information failed", (Throwable)e);
            }
        }
    }
}

