/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ridanisaurus.emendatusenigmatica.events.ArmorTextureEvent;
import com.ridanisaurus.emendatusenigmatica.items.BasicArmorItem;
import com.ridanisaurus.emendatusenigmatica.util.ColorHelper;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class ArmorTextureRenderer<E extends LivingEntity, M extends HumanoidModel<E>>
extends RenderLayer<E, M> {
    private HumanoidModel<E> body;
    private HumanoidModel<E> legs;

    public ArmorTextureRenderer(RenderLayerParent<E, M> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.body = new HumanoidModel(entityModelSet.m_171103_(ArmorTextureEvent.ARMOR));
        this.legs = new HumanoidModel(entityModelSet.m_171103_(ArmorTextureEvent.LEGS));
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        RenderType renderType;
        ResourceLocation rl;
        int i;
        for (i = 0; i < 5; ++i) {
            rl = new ResourceLocation("emendatusenigmatica", "textures/armor/layer_2/0" + i + ".png");
            renderType = RenderType.m_110431_((ResourceLocation)rl);
            this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.LEGS, packedLightIn, this.legs, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, renderType, i);
        }
        for (i = 0; i < 5; ++i) {
            rl = new ResourceLocation("emendatusenigmatica", "textures/armor/layer_1/0" + i + ".png");
            renderType = RenderType.m_110431_((ResourceLocation)rl);
            this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.CHEST, packedLightIn, this.body, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, renderType, i);
            this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.FEET, packedLightIn, this.body, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, renderType, i);
            this.renderSlot(matrixStackIn, bufferIn, entity, EquipmentSlot.HEAD, packedLightIn, this.body, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, renderType, i);
        }
    }

    private void renderSlot(PoseStack matrixStack, MultiBufferSource buffer, E entity, EquipmentSlot slot, int light, HumanoidModel<E> model, float partialTicks, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, RenderType renderType, int colorIndex) {
        BasicArmorItem armor;
        ItemStack stack = entity.m_6844_(slot);
        Item item = stack.m_41720_();
        if (item instanceof BasicArmorItem && (armor = (BasicArmorItem)item).m_40402_() == slot && armor.getMaterialModel().getColors().getMaterialColor() != -1) {
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
            model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.setModelSlotVisible(model, slot);
            Model model1 = ForgeHooksClient.getArmorModel(entity, (ItemStack)stack, (EquipmentSlot)slot, model);
            boolean glint = stack.m_41790_();
            float[] secondary = ColorHelper.INTtoRGB(armor.getColorForIndex(colorIndex));
            this.doRender(matrixStack, buffer, light, glint, model1, secondary[1], secondary[2], secondary[3], slot, renderType);
        }
    }

    private void doRender(PoseStack matrixStack, MultiBufferSource buffer, int light, boolean glint, Model model, float r, float g, float b, EquipmentSlot slot, RenderType renderType) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)glint);
        model.m_7695_(matrixStack, vertexConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }

    protected void setModelSlotVisible(HumanoidModel<E> model, EquipmentSlot slotIn) {
        model.m_8009_(false);
        switch (slotIn) {
            case HEAD: {
                model.f_102808_.f_104207_ = true;
                model.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                model.f_102810_.f_104207_ = true;
                model.f_102811_.f_104207_ = true;
                model.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                model.f_102810_.f_104207_ = true;
                model.f_102813_.f_104207_ = true;
                model.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                model.f_102813_.f_104207_ = true;
                model.f_102814_.f_104207_ = true;
            }
        }
    }
}

