/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.registries;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Table;
import com.mojang.math.Vector3f;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicBuddingBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicClusterBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicClusterShardBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicStorageBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicStorageBlockItem;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicWaxedBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.BasicWeatheringBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.GemOreBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.GemOreBlockWithParticles;
import com.ridanisaurus.emendatusenigmatica.blocks.MetalOreBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.MetalOreBlockWithParticles;
import com.ridanisaurus.emendatusenigmatica.blocks.SampleOreBlock;
import com.ridanisaurus.emendatusenigmatica.blocks.SampleOreBlockWithParticles;
import com.ridanisaurus.emendatusenigmatica.fluids.BasicFluidType;
import com.ridanisaurus.emendatusenigmatica.items.BasicArmorItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicAxeItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicBurnableItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicHoeItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicPaxelItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicPickaxeItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicShieldItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicShovelItem;
import com.ridanisaurus.emendatusenigmatica.items.BasicSwordItem;
import com.ridanisaurus.emendatusenigmatica.items.FeliniumJaminiteIngot;
import com.ridanisaurus.emendatusenigmatica.items.ItemHammer;
import com.ridanisaurus.emendatusenigmatica.items.PaxelItem;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class EERegistrar {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"emendatusenigmatica");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"emendatusenigmatica");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"emendatusenigmatica");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"emendatusenigmatica");
    public static Table<String, String, RegistryObject<Block>> oreBlockTable = HashBasedTable.create();
    public static Table<String, String, RegistryObject<Item>> oreBlockItemTable = HashBasedTable.create();
    public static Table<String, String, RegistryObject<Block>> oreSampleBlockTable = HashBasedTable.create();
    public static Table<String, String, RegistryObject<Item>> oreSampleBlockItemTable = HashBasedTable.create();
    public static Map<String, RegistryObject<Block>> storageBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> storageBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> exposedBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Block>> weatheredBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Block>> oxidizedBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Block>> waxedStorageBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Block>> waxedExposedBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Block>> waxedWeatheredBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Block>> waxedOxidizedBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> exposedBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> weatheredBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> oxidizedBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> waxedStorageBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> waxedExposedBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> waxedWeatheredBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> waxedOxidizedBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> rawBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> rawBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> buddingBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> buddingBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> smallBudBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> smallBudBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> mediumBudBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> mediumBudBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> largeBudBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> largeBudBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> clusterBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> clusterBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Block>> clusterShardBlockMap = new HashMap<String, RegistryObject<Block>>();
    public static Map<String, RegistryObject<Item>> clusterShardBlockItemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> rawMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> ingotMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> nuggetMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> gemMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> dustMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> plateMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> gearMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> rodMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<Item>> clusterShardMap = new HashMap<String, RegistryObject<Item>>();
    public static Map<String, RegistryObject<SwordItem>> swordMap = new HashMap<String, RegistryObject<SwordItem>>();
    public static Map<String, RegistryObject<PickaxeItem>> pickaxeMap = new HashMap<String, RegistryObject<PickaxeItem>>();
    public static Map<String, RegistryObject<AxeItem>> axeMap = new HashMap<String, RegistryObject<AxeItem>>();
    public static Map<String, RegistryObject<ShovelItem>> shovelMap = new HashMap<String, RegistryObject<ShovelItem>>();
    public static Map<String, RegistryObject<HoeItem>> hoeMap = new HashMap<String, RegistryObject<HoeItem>>();
    public static Map<String, RegistryObject<PaxelItem>> paxelMap = new HashMap<String, RegistryObject<PaxelItem>>();
    public static Map<String, RegistryObject<ArmorItem>> helmetMap = new HashMap<String, RegistryObject<ArmorItem>>();
    public static Map<String, RegistryObject<ArmorItem>> chestplateMap = new HashMap<String, RegistryObject<ArmorItem>>();
    public static Map<String, RegistryObject<ArmorItem>> leggingsMap = new HashMap<String, RegistryObject<ArmorItem>>();
    public static Map<String, RegistryObject<ArmorItem>> bootsMap = new HashMap<String, RegistryObject<ArmorItem>>();
    public static Map<String, RegistryObject<ShieldItem>> shieldMap = new HashMap<String, RegistryObject<ShieldItem>>();
    public static Map<String, RegistryObject<FluidType>> fluidTypeMap = new HashMap<String, RegistryObject<FluidType>>();
    public static Map<String, RegistryObject<FlowingFluid>> fluidSourceMap = new HashMap<String, RegistryObject<FlowingFluid>>();
    public static Map<String, RegistryObject<FlowingFluid>> fluidFlowingMap = new HashMap<String, RegistryObject<FlowingFluid>>();
    public static Map<String, RegistryObject<LiquidBlock>> fluidBlockMap = new HashMap<String, RegistryObject<LiquidBlock>>();
    public static Map<String, RegistryObject<Item>> fluidBucketMap = new HashMap<String, RegistryObject<Item>>();
    public static final ResourceLocation FLUID_STILL_RL = new ResourceLocation("emendatusenigmatica", "fluids/fluid_still");
    public static final ResourceLocation FLUID_FLOWING_RL = new ResourceLocation("emendatusenigmatica", "fluids/fluid_flow");
    public static final ResourceLocation FLUID_OVERLAY_RL = new ResourceLocation("emendatusenigmatica", "fluids/fluid_overlay");
    public static RegistryObject<FluidType> fluidType;
    public static RegistryObject<FlowingFluid> fluidSource;
    public static RegistryObject<FlowingFluid> fluidFlowing;
    public static RegistryObject<LiquidBlock> fluidBlock;
    public static RegistryObject<Item> fluidBucket;
    public static final RegistryObject<Item> ENIGMATIC_HAMMER;
    public static final RegistryObject<Item> FELINIUM_JAMINITE;

    public static void registerOre(StrataModel strata, MaterialModel material) {
        String oreName = material.getId() + (String)(!strata.getId().equals("minecraft_stone") ? "_" + strata.getSuffix() : "") + "_ore";
        RegistryObject oreBlock = material.getProperties().getMaterialType().equals("gem") ? (material.getProperties().hasParticles() ? BLOCKS.register(oreName, () -> new GemOreBlockWithParticles(strata, material)) : BLOCKS.register(oreName, () -> new GemOreBlock(strata, material))) : (material.getProperties().hasParticles() ? BLOCKS.register(oreName, () -> new MetalOreBlockWithParticles(strata, material)) : BLOCKS.register(oreName, () -> new MetalOreBlock(strata, material)));
        oreBlockTable.put((Object)strata.getId(), (Object)material.getId(), (Object)oreBlock);
        oreBlockItemTable.put((Object)strata.getId(), (Object)material.getId(), (Object)ITEMS.register(oreName, () -> new BlockItem((Block)oreBlock.get(), new Item.Properties().m_41491_(EmendatusEnigmatica.TAB))));
    }

    public static void registerOreSample(StrataModel strata, MaterialModel material) {
        String oreSampleName = material.getId() + "_" + strata.getSuffix() + "_ore_sample";
        RegistryObject oreSampleBlock = strata.getSampleStrata() && material.getProperties().hasParticles() ? BLOCKS.register(oreSampleName, () -> new SampleOreBlockWithParticles(strata, material)) : BLOCKS.register(oreSampleName, () -> new SampleOreBlock(strata, material));
        oreSampleBlockTable.put((Object)strata.getId(), (Object)material.getId(), (Object)oreSampleBlock);
        oreSampleBlockItemTable.put((Object)strata.getId(), (Object)material.getId(), (Object)ITEMS.register(oreSampleName, () -> new BlockItem((Block)oreSampleBlock.get(), new Item.Properties().m_41491_(EmendatusEnigmatica.TAB))));
    }

    public static void registerStorageBlocks(MaterialModel material) {
        if (material.getProperties().hasOxidization()) {
            com.google.common.base.Supplier oxidizationBlockMap = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)storageBlockMap.get(material.getId()).get()), (Object)((Block)exposedBlockMap.get(material.getId()).get())).put((Object)((Block)exposedBlockMap.get(material.getId()).get()), (Object)((Block)weatheredBlockMap.get(material.getId()).get())).put((Object)((Block)weatheredBlockMap.get(material.getId()).get()), (Object)((Block)oxidizedBlockMap.get(material.getId()).get())).build());
            com.google.common.base.Supplier waxableBlockMap = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)((Block)storageBlockMap.get(material.getId()).get()), (Object)((Block)waxedStorageBlockMap.get(material.getId()).get())).put((Object)((Block)exposedBlockMap.get(material.getId()).get()), (Object)((Block)waxedExposedBlockMap.get(material.getId()).get())).put((Object)((Block)weatheredBlockMap.get(material.getId()).get()), (Object)((Block)waxedWeatheredBlockMap.get(material.getId()).get())).put((Object)((Block)oxidizedBlockMap.get(material.getId()).get()), (Object)((Block)waxedOxidizedBlockMap.get(material.getId()).get())).build());
            String storageBlockName = material.getId() + "_block";
            String exposedBlockName = "exposed_" + material.getId();
            String weatheredBlockName = "weathered_" + material.getId();
            String oxidizedBlockName = "oxidized_" + material.getId();
            String waxedStorageBlockName = "waxed_" + material.getId() + "_block";
            String waxedExposedBlockName = "waxed_exposed_" + material.getId();
            String waxedWeatheredBlockName = "waxed_weathered_" + material.getId();
            String waxedOxidizedBlockName = "waxed_oxidized_" + material.getId();
            RegistryObject storageBlock = BLOCKS.register(storageBlockName, () -> EERegistrar.lambda$registerStorageBlocks$10(material, (Supplier)oxidizationBlockMap, (Supplier)waxableBlockMap));
            RegistryObject exposedBlock = BLOCKS.register(exposedBlockName, () -> EERegistrar.lambda$registerStorageBlocks$11(material, (Supplier)oxidizationBlockMap, (Supplier)waxableBlockMap));
            RegistryObject weatheredBlock = BLOCKS.register(weatheredBlockName, () -> EERegistrar.lambda$registerStorageBlocks$12(material, (Supplier)oxidizationBlockMap, (Supplier)waxableBlockMap));
            RegistryObject oxidizedBlock = BLOCKS.register(oxidizedBlockName, () -> EERegistrar.lambda$registerStorageBlocks$13(material, (Supplier)oxidizationBlockMap, (Supplier)waxableBlockMap));
            RegistryObject waxedStorageBlock = BLOCKS.register(waxedStorageBlockName, () -> EERegistrar.lambda$registerStorageBlocks$14(material, (Supplier)waxableBlockMap));
            RegistryObject waxedExposedBlock = BLOCKS.register(waxedExposedBlockName, () -> EERegistrar.lambda$registerStorageBlocks$15(material, (Supplier)waxableBlockMap));
            RegistryObject waxedWeatheredBlock = BLOCKS.register(waxedWeatheredBlockName, () -> EERegistrar.lambda$registerStorageBlocks$16(material, (Supplier)waxableBlockMap));
            RegistryObject waxedOxidizedBlock = BLOCKS.register(waxedOxidizedBlockName, () -> EERegistrar.lambda$registerStorageBlocks$17(material, (Supplier)waxableBlockMap));
            storageBlockMap.put(material.getId(), (RegistryObject<Block>)storageBlock);
            exposedBlockMap.put(material.getId(), (RegistryObject<Block>)exposedBlock);
            weatheredBlockMap.put(material.getId(), (RegistryObject<Block>)weatheredBlock);
            oxidizedBlockMap.put(material.getId(), (RegistryObject<Block>)oxidizedBlock);
            waxedStorageBlockMap.put(material.getId(), (RegistryObject<Block>)waxedStorageBlock);
            waxedExposedBlockMap.put(material.getId(), (RegistryObject<Block>)waxedExposedBlock);
            waxedWeatheredBlockMap.put(material.getId(), (RegistryObject<Block>)waxedWeatheredBlock);
            waxedOxidizedBlockMap.put(material.getId(), (RegistryObject<Block>)waxedOxidizedBlock);
            if (material.getProperties().isBurnable()) {
                storageBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(storageBlockName, () -> new BasicStorageBlockItem((Block)storageBlock.get(), material.getProperties().getBurnTime() * 10)));
                exposedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(exposedBlockName, () -> new BasicStorageBlockItem((Block)exposedBlock.get(), material.getProperties().getBurnTime() * 10)));
                weatheredBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(weatheredBlockName, () -> new BasicStorageBlockItem((Block)weatheredBlock.get(), material.getProperties().getBurnTime() * 10)));
                oxidizedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(oxidizedBlockName, () -> new BasicStorageBlockItem((Block)oxidizedBlock.get(), material.getProperties().getBurnTime() * 10)));
                waxedStorageBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedStorageBlockName, () -> new BasicStorageBlockItem((Block)waxedStorageBlock.get(), material.getProperties().getBurnTime() * 10)));
                waxedExposedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedExposedBlockName, () -> new BasicStorageBlockItem((Block)waxedExposedBlock.get(), material.getProperties().getBurnTime() * 10)));
                waxedWeatheredBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedWeatheredBlockName, () -> new BasicStorageBlockItem((Block)waxedWeatheredBlock.get(), material.getProperties().getBurnTime() * 10)));
                waxedOxidizedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedOxidizedBlockName, () -> new BasicStorageBlockItem((Block)waxedOxidizedBlock.get(), material.getProperties().getBurnTime() * 10)));
            } else {
                storageBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(storageBlockName, () -> new BasicStorageBlockItem((Block)storageBlock.get(), 0)));
                exposedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(exposedBlockName, () -> new BasicStorageBlockItem((Block)exposedBlock.get(), 0)));
                weatheredBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(weatheredBlockName, () -> new BasicStorageBlockItem((Block)weatheredBlock.get(), 0)));
                oxidizedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(oxidizedBlockName, () -> new BasicStorageBlockItem((Block)oxidizedBlock.get(), 0)));
                waxedStorageBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedStorageBlockName, () -> new BasicStorageBlockItem((Block)waxedStorageBlock.get(), 0)));
                waxedExposedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedExposedBlockName, () -> new BasicStorageBlockItem((Block)waxedExposedBlock.get(), 0)));
                waxedWeatheredBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedWeatheredBlockName, () -> new BasicStorageBlockItem((Block)waxedWeatheredBlock.get(), 0)));
                waxedOxidizedBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(waxedOxidizedBlockName, () -> new BasicStorageBlockItem((Block)waxedOxidizedBlock.get(), 0)));
            }
        } else {
            String storageBlockName = material.getId() + "_block";
            RegistryObject storageBlock = BLOCKS.register(storageBlockName, () -> new BasicStorageBlock(material));
            storageBlockMap.put(material.getId(), (RegistryObject<Block>)storageBlock);
            if (material.getProperties().isBurnable()) {
                storageBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(storageBlockName, () -> new BasicStorageBlockItem((Block)storageBlock.get(), material.getProperties().getBurnTime() * 10)));
            } else {
                storageBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(storageBlockName, () -> new BasicStorageBlockItem((Block)storageBlock.get(), 0)));
            }
        }
    }

    public static void registerRawBlocks(MaterialModel material) {
        String rawBlockName = "raw_" + material.getId() + "_block";
        RegistryObject rawBlock = BLOCKS.register(rawBlockName, () -> new BasicStorageBlock(material));
        rawBlockMap.put(material.getId(), (RegistryObject<Block>)rawBlock);
        if (material.getProperties().isBurnable()) {
            rawBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(rawBlockName, () -> new BasicStorageBlockItem((Block)rawBlock.get(), material.getProperties().getBurnTime() * 10)));
        } else {
            rawBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(rawBlockName, () -> new BasicStorageBlockItem((Block)rawBlock.get(), 0)));
        }
    }

    public static void registerBuddingBlocks(MaterialModel material) {
        String buddingBlockName = "budding_" + material.getId();
        RegistryObject buddingBlock = BLOCKS.register(buddingBlockName, () -> new BasicBuddingBlock(material, (Supplier)smallBudBlockMap.get(material.getId()), (Supplier)mediumBudBlockMap.get(material.getId()), (Supplier)largeBudBlockMap.get(material.getId()), (Supplier)clusterBlockMap.get(material.getId())));
        buddingBlockMap.put(material.getId(), (RegistryObject<Block>)buddingBlock);
        if (material.getProperties().isBurnable()) {
            buddingBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(buddingBlockName, () -> new BasicStorageBlockItem((Block)buddingBlock.get(), material.getProperties().getBurnTime() * 4)));
        } else {
            buddingBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(buddingBlockName, () -> new BasicStorageBlockItem((Block)buddingBlock.get(), 0)));
        }
    }

    public static void registerSmallBudBlocks(MaterialModel material) {
        String smallBudBlockName = "small_" + material.getId() + "_bud";
        RegistryObject smallBudBlock = BLOCKS.register(smallBudBlockName, () -> new BasicClusterBlock(3, 4, 1, material));
        smallBudBlockMap.put(material.getId(), (RegistryObject<Block>)smallBudBlock);
        if (material.getProperties().isBurnable()) {
            smallBudBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(smallBudBlockName, () -> new BasicStorageBlockItem((Block)smallBudBlock.get(), material.getProperties().getBurnTime())));
        } else {
            smallBudBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(smallBudBlockName, () -> new BasicStorageBlockItem((Block)smallBudBlock.get(), 0)));
        }
    }

    public static void registerMediumBudBlocks(MaterialModel material) {
        String mediumBudBlockName = "medium_" + material.getId() + "_bud";
        RegistryObject mediumBudBlock = BLOCKS.register(mediumBudBlockName, () -> new BasicClusterBlock(4, 3, 2, material));
        mediumBudBlockMap.put(material.getId(), (RegistryObject<Block>)mediumBudBlock);
        if (material.getProperties().isBurnable()) {
            mediumBudBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(mediumBudBlockName, () -> new BasicStorageBlockItem((Block)mediumBudBlock.get(), material.getProperties().getBurnTime())));
        } else {
            mediumBudBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(mediumBudBlockName, () -> new BasicStorageBlockItem((Block)mediumBudBlock.get(), 0)));
        }
    }

    public static void registerLargeBudBlocks(MaterialModel material) {
        String largeBudBlockName = "large_" + material.getId() + "_bud";
        RegistryObject largeBudBlock = BLOCKS.register(largeBudBlockName, () -> new BasicClusterBlock(5, 3, 4, material));
        largeBudBlockMap.put(material.getId(), (RegistryObject<Block>)largeBudBlock);
        if (material.getProperties().isBurnable()) {
            largeBudBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(largeBudBlockName, () -> new BasicStorageBlockItem((Block)largeBudBlock.get(), material.getProperties().getBurnTime())));
        } else {
            largeBudBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(largeBudBlockName, () -> new BasicStorageBlockItem((Block)largeBudBlock.get(), 0)));
        }
    }

    public static void registerClusterBlocks(MaterialModel material) {
        String clusterBlockName = material.getId() + "_cluster";
        RegistryObject clusterBlock = BLOCKS.register(clusterBlockName, () -> new BasicClusterBlock(7, 3, 5, material));
        clusterBlockMap.put(material.getId(), (RegistryObject<Block>)clusterBlock);
        if (material.getProperties().isBurnable()) {
            clusterBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(clusterBlockName, () -> new BasicStorageBlockItem((Block)clusterBlock.get(), material.getProperties().getBurnTime())));
        } else {
            clusterBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(clusterBlockName, () -> new BasicStorageBlockItem((Block)clusterBlock.get(), 0)));
        }
    }

    public static void registerClusterShardBlocks(MaterialModel material) {
        String clusterShardBlockName = material.getId() + "_cluster_shard_block";
        RegistryObject clusterShardBlock = BLOCKS.register(clusterShardBlockName, () -> new BasicClusterShardBlock(material));
        clusterShardBlockMap.put(material.getId(), (RegistryObject<Block>)clusterShardBlock);
        if (material.getProperties().isBurnable()) {
            clusterShardBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(clusterShardBlockName, () -> new BasicStorageBlockItem((Block)clusterShardBlock.get(), material.getProperties().getBurnTime() * 4)));
        } else {
            clusterShardBlockItemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(clusterShardBlockName, () -> new BasicStorageBlockItem((Block)clusterShardBlock.get(), 0)));
        }
    }

    public static void registerClusterShards(MaterialModel material) {
        String itemName = material.getId() + "_cluster_shard";
        if (material.getProperties().isBurnable()) {
            clusterShardMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime())));
        } else {
            clusterShardMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerRaws(MaterialModel material) {
        String itemName = "raw_" + material.getId();
        if (material.getProperties().isBurnable()) {
            rawMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime())));
        } else {
            rawMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerIngots(MaterialModel material) {
        String itemName = material.getId() + "_ingot";
        if (material.getProperties().isBurnable()) {
            ingotMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime())));
        } else {
            ingotMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerNuggets(MaterialModel material) {
        String itemName = material.getId() + "_nugget";
        if (material.getProperties().isBurnable()) {
            nuggetMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime() / 10)));
        } else {
            nuggetMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerGems(MaterialModel material) {
        String itemName = material.getId() + "_gem";
        if (material.getProperties().isBurnable()) {
            gemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime())));
        } else {
            gemMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerDusts(MaterialModel material) {
        String itemName = material.getId() + "_dust";
        if (material.getProperties().isBurnable()) {
            dustMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime())));
        } else {
            dustMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerPlates(MaterialModel material) {
        String itemName = material.getId() + "_plate";
        if (material.getProperties().isBurnable()) {
            plateMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime())));
        } else {
            plateMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerGears(MaterialModel material) {
        String itemName = material.getId() + "_gear";
        if (material.getProperties().isBurnable()) {
            gearMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime() * 4)));
        } else {
            gearMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerRods(MaterialModel material) {
        String itemName = material.getId() + "_rod";
        if (material.getProperties().isBurnable()) {
            rodMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicBurnableItem(material, material.getProperties().getBurnTime() * 2)));
        } else {
            rodMap.put(material.getId(), (RegistryObject<Item>)ITEMS.register(itemName, () -> new BasicItem(material)));
        }
    }

    public static void registerSwords(MaterialModel material) {
        String itemName = material.getId() + "_sword";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        swordMap.put(material.getId(), (RegistryObject<SwordItem>)ITEMS.register(itemName, () -> new BasicSwordItem(material, repairItem)));
    }

    public static void registerPickaxes(MaterialModel material) {
        String itemName = material.getId() + "_pickaxe";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        pickaxeMap.put(material.getId(), (RegistryObject<PickaxeItem>)ITEMS.register(itemName, () -> new BasicPickaxeItem(material, repairItem)));
    }

    public static void registerAxes(MaterialModel material) {
        String itemName = material.getId() + "_axe";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        axeMap.put(material.getId(), (RegistryObject<AxeItem>)ITEMS.register(itemName, () -> new BasicAxeItem(material, repairItem)));
    }

    public static void registerShovels(MaterialModel material) {
        String itemName = material.getId() + "_shovel";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        shovelMap.put(material.getId(), (RegistryObject<ShovelItem>)ITEMS.register(itemName, () -> new BasicShovelItem(material, repairItem)));
    }

    public static void registerHoes(MaterialModel material) {
        String itemName = material.getId() + "_hoe";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        hoeMap.put(material.getId(), (RegistryObject<HoeItem>)ITEMS.register(itemName, () -> new BasicHoeItem(material, repairItem)));
    }

    public static void registerPaxels(MaterialModel material) {
        String itemName = material.getId() + "_paxel";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        paxelMap.put(material.getId(), (RegistryObject<PaxelItem>)ITEMS.register(itemName, () -> new BasicPaxelItem(material, repairItem)));
    }

    public static void registerHelmets(MaterialModel material) {
        String itemName = material.getId() + "_helmet";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        helmetMap.put(material.getId(), (RegistryObject<ArmorItem>)ITEMS.register(itemName, () -> new BasicArmorItem(material, repairItem, EquipmentSlot.HEAD, material.getArmor().getHelmet())));
    }

    public static void registerChestplates(MaterialModel material) {
        String itemName = material.getId() + "_chestplate";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        chestplateMap.put(material.getId(), (RegistryObject<ArmorItem>)ITEMS.register(itemName, () -> new BasicArmorItem(material, repairItem, EquipmentSlot.CHEST, material.getArmor().getChestplate())));
    }

    public static void registerLeggings(MaterialModel material) {
        String itemName = material.getId() + "_leggings";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        leggingsMap.put(material.getId(), (RegistryObject<ArmorItem>)ITEMS.register(itemName, () -> new BasicArmorItem(material, repairItem, EquipmentSlot.LEGS, material.getArmor().getLeggings())));
    }

    public static void registerBoots(MaterialModel material) {
        String itemName = material.getId() + "_boots";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        bootsMap.put(material.getId(), (RegistryObject<ArmorItem>)ITEMS.register(itemName, () -> new BasicArmorItem(material, repairItem, EquipmentSlot.FEET, material.getArmor().getBoots())));
    }

    public static void registerShields(MaterialModel material) {
        String itemName = material.getId() + "_shield";
        TagKey<Item> repairItem = material.getProperties().getMaterialType().equals("metal") ? EETags.MATERIAL_INGOT.apply(material.getId()) : EETags.MATERIAL_GEM.apply(material.getId());
        shieldMap.put(material.getId(), (RegistryObject<ShieldItem>)ITEMS.register(itemName, () -> new BasicShieldItem(material, repairItem)));
    }

    public static void registerFluids(MaterialModel material) {
        fluidType = FLUID_TYPES.register(material.getId(), () -> new BasicFluidType(FLUID_STILL_RL, FLUID_FLOWING_RL, FLUID_OVERLAY_RL, material.getColors().getFluidColor(), new Vector3f(Vec3.m_82501_((int)material.getColors().getFluidColor())), EERegistrar.fluidTypeProperties(material)));
        fluidSource = FLUIDS.register(material.getId(), () -> new ForgeFlowingFluid.Source(EERegistrar.makeProperties((Supplier)fluidTypeMap.get(material.getId()), (Supplier)fluidSourceMap.get(material.getId()), (Supplier)fluidFlowingMap.get(material.getId()), (Supplier)fluidBlockMap.get(material.getId()), (Supplier)fluidBucketMap.get(material.getId()))));
        fluidFlowing = FLUIDS.register("flowing_" + material.getId(), () -> new ForgeFlowingFluid.Flowing(EERegistrar.makeProperties((Supplier)fluidTypeMap.get(material.getId()), (Supplier)fluidSourceMap.get(material.getId()), (Supplier)fluidFlowingMap.get(material.getId()), (Supplier)fluidBlockMap.get(material.getId()), (Supplier)fluidBucketMap.get(material.getId()))));
        fluidBlock = BLOCKS.register(material.getId(), () -> new LiquidBlock((Supplier)fluidSourceMap.get(material.getId()), BlockBehaviour.Properties.m_60939_((Material)Material.f_76307_).m_60910_().m_60978_(100.0f).m_222994_()));
        fluidBucket = ITEMS.register(material.getId() + "_bucket", () -> new BucketItem((Supplier)fluidSourceMap.get(material.getId()), new Item.Properties().m_41487_(1).m_41495_(Items.f_42446_).m_41491_(EmendatusEnigmatica.TAB)));
        fluidTypeMap.put(material.getId(), fluidType);
        fluidSourceMap.put(material.getId(), fluidSource);
        fluidFlowingMap.put(material.getId(), fluidFlowing);
        fluidBlockMap.put(material.getId(), fluidBlock);
        fluidBucketMap.put(material.getId(), fluidBucket);
    }

    private static FluidType.Properties fluidTypeProperties(MaterialModel material) {
        return FluidType.Properties.create().descriptionId("fluid.emendatusenigmatica." + material.getId()).lightLevel(15).density(3000).viscosity(6000).temperature(1300).rarity(Rarity.COMMON).canDrown(false).canSwim(false).pathType(BlockPathTypes.LAVA).adjacentPathType(null).sound(SoundAction.get((String)"bucket_fill"), SoundEvents.f_11783_).sound(SoundAction.get((String)"bucket_empty"), SoundEvents.f_11780_);
    }

    public static ForgeFlowingFluid.Properties makeProperties(Supplier<FluidType> type, Supplier<FlowingFluid> source, Supplier<FlowingFluid> flowing, Supplier<LiquidBlock> block, Supplier<Item> bucket) {
        return new ForgeFlowingFluid.Properties(type, source, flowing).slopeFindDistance(2).levelDecreasePerBlock(2).block(block).bucket(bucket);
    }

    public static void finalize(IEventBus eventBus) {
        ITEMS.register(eventBus);
        BLOCKS.register(eventBus);
        FLUID_TYPES.register(eventBus);
        FLUIDS.register(eventBus);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$17(MaterialModel material, Supplier waxableBlockMap) {
        return new BasicWaxedBlock(material, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$16(MaterialModel material, Supplier waxableBlockMap) {
        return new BasicWaxedBlock(material, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$15(MaterialModel material, Supplier waxableBlockMap) {
        return new BasicWaxedBlock(material, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$14(MaterialModel material, Supplier waxableBlockMap) {
        return new BasicWaxedBlock(material, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$13(MaterialModel material, Supplier oxidizationBlockMap, Supplier waxableBlockMap) {
        return new BasicWeatheringBlock(material, BasicWeatheringBlock.WeatherState.OXIDIZED, oxidizationBlockMap, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$12(MaterialModel material, Supplier oxidizationBlockMap, Supplier waxableBlockMap) {
        return new BasicWeatheringBlock(material, BasicWeatheringBlock.WeatherState.WEATHERED, oxidizationBlockMap, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$11(MaterialModel material, Supplier oxidizationBlockMap, Supplier waxableBlockMap) {
        return new BasicWeatheringBlock(material, BasicWeatheringBlock.WeatherState.EXPOSED, oxidizationBlockMap, waxableBlockMap);
    }

    private static /* synthetic */ Block lambda$registerStorageBlocks$10(MaterialModel material, Supplier oxidizationBlockMap, Supplier waxableBlockMap) {
        return new BasicWeatheringBlock(material, BasicWeatheringBlock.WeatherState.UNAFFECTED, oxidizationBlockMap, waxableBlockMap);
    }

    static {
        ENIGMATIC_HAMMER = ITEMS.register("enigmatic_hammer", ItemHammer::new);
        FELINIUM_JAMINITE = ITEMS.register("felinium_jaminite_ingot", FeliniumJaminiteIngot::new);
    }
}

