/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.plugin;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.api.IEmendatusPlugin;
import com.ridanisaurus.emendatusenigmatica.api.annotation.EmendatusPluginReference;
import com.ridanisaurus.emendatusenigmatica.datagen.BlockHarvestTagsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.BlockModelsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.BlockStatesGen;
import com.ridanisaurus.emendatusenigmatica.datagen.BlockTagsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.FluidModelsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.FluidTagsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.ItemModelsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.ItemTagsGen;
import com.ridanisaurus.emendatusenigmatica.datagen.LangGen;
import com.ridanisaurus.emendatusenigmatica.datagen.LootTablesGen;
import com.ridanisaurus.emendatusenigmatica.datagen.OreFeatureDataGen;
import com.ridanisaurus.emendatusenigmatica.datagen.RecipesGen;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.CompatModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.StrataModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.util.FileHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.fml.loading.FMLPaths;

@EmendatusPluginReference(modid="emendatusenigmatica", name="config")
public class DefaultConfigPlugin
implements IEmendatusPlugin {
    public static final List<MaterialModel> MATERIALS = new ArrayList<MaterialModel>();
    public static final List<StrataModel> STRATA = new ArrayList<StrataModel>();

    @Override
    public void load(EmendatusDataRegistry registry) {
        Optional result;
        File compatDir;
        File materialDir;
        File strataDir;
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("emendatusenigmatica/");
        if (!configDir.toFile().exists() && configDir.toFile().mkdirs()) {
            EmendatusEnigmatica.LOGGER.info("Created /config/emendatusenigmatica/");
        }
        if (!(strataDir = configDir.resolve("strata/").toFile()).exists() && strataDir.mkdirs()) {
            EmendatusEnigmatica.LOGGER.info("Created /config/emendatusenigmatica/strata/");
        }
        if (!(materialDir = configDir.resolve("material/").toFile()).exists() && materialDir.mkdirs()) {
            EmendatusEnigmatica.LOGGER.info("Created /config/emendatusenigmatica/material/");
        }
        if (!(compatDir = configDir.resolve("compat/").toFile()).exists() && compatDir.mkdirs()) {
            EmendatusEnigmatica.LOGGER.info("Created /config/emendatusenigmatica/compat/");
        }
        ArrayList<JsonObject> strataDefinition = FileHelper.loadFilesAsJsonObjects(strataDir);
        ArrayList<JsonObject> materialDefinition = FileHelper.loadFilesAsJsonObjects(materialDir);
        ArrayList<JsonObject> compatDefinition = FileHelper.loadFilesAsJsonObjects(compatDir);
        for (JsonObject jsonObject : strataDefinition) {
            result = ((DataResult)JsonOps.INSTANCE.withDecoder(StrataModel.CODEC).apply(jsonObject)).result();
            if (!result.isPresent()) continue;
            StrataModel strataModel = (StrataModel)((Pair)result.get()).getFirst();
            registry.registerStrata(strataModel);
            STRATA.add(strataModel);
        }
        for (JsonObject jsonObject : materialDefinition) {
            result = ((DataResult)JsonOps.INSTANCE.withDecoder(MaterialModel.CODEC).apply(jsonObject)).result();
            if (!result.isPresent()) continue;
            MaterialModel materialModel = (MaterialModel)((Pair)result.get()).getFirst();
            registry.getMaterialOrRegister(materialModel.getId(), materialModel);
            MATERIALS.add(materialModel);
        }
        ArrayList<CompatModel> compatModels = new ArrayList<CompatModel>();
        for (JsonObject jsonObject : compatDefinition) {
            Optional result2 = ((DataResult)JsonOps.INSTANCE.withDecoder(CompatModel.CODEC).apply(jsonObject)).result();
            if (!result2.isPresent()) continue;
            CompatModel compatModel = (CompatModel)((Pair)result2.get()).getFirst();
            compatModels.add(compatModel);
            registry.registerCompat(compatModel);
        }
    }

    @Override
    public void registerMinecraft(List<MaterialModel> materialModels, List<StrataModel> strataModels) {
        for (StrataModel strata : strataModels) {
            for (MaterialModel material : materialModels) {
                if (material.getProcessedTypes().contains("ore")) {
                    EERegistrar.registerOre(strata, material);
                }
                if (!material.getProcessedTypes().contains("ore") || !strata.getSampleStrata()) continue;
                EERegistrar.registerOreSample(strata, material);
            }
        }
        for (MaterialModel material : materialModels) {
            if (material.getProcessedTypes().contains("storage_block")) {
                EERegistrar.registerStorageBlocks(material);
            }
            if (material.getProcessedTypes().contains("raw")) {
                EERegistrar.registerRaws(material);
                EERegistrar.registerRawBlocks(material);
            }
            if (material.getProcessedTypes().contains("cluster")) {
                EERegistrar.registerSmallBudBlocks(material);
                EERegistrar.registerMediumBudBlocks(material);
                EERegistrar.registerLargeBudBlocks(material);
                EERegistrar.registerClusterBlocks(material);
                EERegistrar.registerBuddingBlocks(material);
                EERegistrar.registerClusterShardBlocks(material);
                EERegistrar.registerClusterShards(material);
            }
            if (material.getProcessedTypes().contains("ingot")) {
                EERegistrar.registerIngots(material);
            }
            if (material.getProcessedTypes().contains("nugget")) {
                EERegistrar.registerNuggets(material);
            }
            if (material.getProcessedTypes().contains("gem")) {
                EERegistrar.registerGems(material);
            }
            if (material.getProcessedTypes().contains("dust")) {
                EERegistrar.registerDusts(material);
            }
            if (material.getProcessedTypes().contains("plate")) {
                EERegistrar.registerPlates(material);
            }
            if (material.getProcessedTypes().contains("gear")) {
                EERegistrar.registerGears(material);
            }
            if (material.getProcessedTypes().contains("rod")) {
                EERegistrar.registerRods(material);
            }
            if (material.getProcessedTypes().contains("sword")) {
                EERegistrar.registerSwords(material);
            }
            if (material.getProcessedTypes().contains("pickaxe")) {
                EERegistrar.registerPickaxes(material);
            }
            if (material.getProcessedTypes().contains("axe")) {
                EERegistrar.registerAxes(material);
            }
            if (material.getProcessedTypes().contains("shovel")) {
                EERegistrar.registerShovels(material);
            }
            if (material.getProcessedTypes().contains("hoe")) {
                EERegistrar.registerHoes(material);
            }
            if (material.getProcessedTypes().contains("paxel")) {
                EERegistrar.registerPaxels(material);
            }
            if (material.getProcessedTypes().contains("helmet")) {
                EERegistrar.registerHelmets(material);
            }
            if (material.getProcessedTypes().contains("chestplate")) {
                EERegistrar.registerChestplates(material);
            }
            if (material.getProcessedTypes().contains("leggings")) {
                EERegistrar.registerLeggings(material);
            }
            if (material.getProcessedTypes().contains("boots")) {
                EERegistrar.registerBoots(material);
            }
            if (material.getProcessedTypes().contains("shield")) {
                EERegistrar.registerShields(material);
            }
            if (!material.getProcessedTypes().contains("fluid")) continue;
            EERegistrar.registerFluids(material);
        }
    }

    @Override
    public void registerDynamicDataGen(DataGenerator generator, EmendatusDataRegistry registry) {
        generator.m_236039_(true, (DataProvider)new BlockStatesGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new BlockModelsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new ItemModelsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new FluidModelsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new LangGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new BlockTagsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new ItemTagsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new FluidTagsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new BlockHarvestTagsGen.BlockHarvestLevelTagsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new BlockHarvestTagsGen.BlockHarvestToolTagsGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new RecipesGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new LootTablesGen(generator, registry));
        generator.m_236039_(true, (DataProvider)new OreFeatureDataGen(generator, registry));
    }

    @Override
    public void finish(EmendatusDataRegistry registry) {
    }
}

