/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.parser.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialOreDropModel {
    public static final Codec<MaterialOreDropModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.optionalFieldOf("drop").forGetter(i -> Optional.ofNullable(i.drop)), (App)Codec.INT.optionalFieldOf("min").forGetter(i -> Optional.of(i.min)), (App)Codec.INT.optionalFieldOf("max").forGetter(i -> Optional.of(i.max))).apply((Applicative)x, (drop, min, max) -> new MaterialOreDropModel(drop.orElse(""), min.orElse(1), max.orElse(1))));
    private final String drop;
    private final int min;
    private final int max;

    public MaterialOreDropModel(String drop, int min, int max) {
        this.drop = drop;
        this.min = min;
        this.max = max;
    }

    public MaterialOreDropModel() {
        this.drop = "";
        this.min = 1;
        this.max = 1;
    }

    public String getDrop() {
        return this.drop;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public ItemLike getDefaultItemDropAsItem() {
        return (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.drop));
    }
}

