/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.parser.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialArmorModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialColorsModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialCompatModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialGasPropertiesModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialOreDropModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialPropertiesModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialToolsModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialModel {
    public static final Codec<MaterialModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("id").forGetter(i -> i.id), (App)Codec.STRING.fieldOf("source").forGetter(i -> i.source), (App)Codec.STRING.fieldOf("localizedName").forGetter(i -> i.localizedName), (App)Codec.BOOL.optionalFieldOf("disableDefaultOre").forGetter(i -> Optional.of(i.disableDefaultOre)), (App)Codec.list((Codec)Codec.STRING).fieldOf("processedTypes").forGetter(i -> i.processedTypes), (App)MaterialPropertiesModel.CODEC.optionalFieldOf("properties").forGetter(i -> Optional.of(i.properties)), (App)MaterialGasPropertiesModel.CODEC.optionalFieldOf("gas").forGetter(i -> Optional.of(i.gas)), (App)MaterialOreDropModel.CODEC.optionalFieldOf("oreDrop").forGetter(i -> Optional.of(i.oreDrop)), (App)MaterialCompatModel.CODEC.optionalFieldOf("compat").forGetter(i -> Optional.of(i.compat)), (App)MaterialColorsModel.CODEC.optionalFieldOf("colors").forGetter(i -> Optional.of(i.colors)), (App)MaterialToolsModel.CODEC.optionalFieldOf("tools").forGetter(i -> Optional.of(i.tools)), (App)MaterialArmorModel.CODEC.optionalFieldOf("armor").forGetter(i -> Optional.of(i.armor))).apply((Applicative)x, (id, source, localizedName, disableDefaultOre, processedTypes, properties, gas, oreDrop, compat, colors, tools, armor) -> new MaterialModel((String)id, (String)source, (String)localizedName, disableDefaultOre.orElse(false), (List<String>)processedTypes, properties.orElse(new MaterialPropertiesModel()), gas.orElse(new MaterialGasPropertiesModel()), oreDrop.orElse(new MaterialOreDropModel()), compat.orElse(new MaterialCompatModel()), colors.orElse(new MaterialColorsModel()), tools.orElse(new MaterialToolsModel()), armor.orElse(new MaterialArmorModel()))));
    private final String id;
    private final String source;
    private final String localizedName;
    private final boolean disableDefaultOre;
    private final List<String> processedTypes;
    private final MaterialPropertiesModel properties;
    private final MaterialGasPropertiesModel gas;
    private final MaterialOreDropModel oreDrop;
    private final MaterialCompatModel compat;
    private final MaterialColorsModel colors;
    private final MaterialToolsModel tools;
    private final MaterialArmorModel armor;

    public MaterialModel(String id, String source, String localizedName, boolean disableDefaultOre, List<String> processedTypes, MaterialPropertiesModel properties, MaterialGasPropertiesModel gas, MaterialOreDropModel oreDrop, MaterialCompatModel compat, MaterialColorsModel colors, MaterialToolsModel tools, MaterialArmorModel armor) {
        this.id = id;
        this.source = source;
        this.localizedName = localizedName;
        this.disableDefaultOre = disableDefaultOre;
        this.processedTypes = processedTypes;
        this.properties = properties;
        this.gas = gas;
        this.oreDrop = oreDrop;
        this.compat = compat;
        this.colors = colors;
        this.tools = tools;
        this.armor = armor;
    }

    public String getId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isModded() {
        return !this.getSource().equals("vanilla");
    }

    public boolean isVanilla() {
        return this.getSource().equals("vanilla");
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public boolean getDisableDefaultOre() {
        return this.disableDefaultOre;
    }

    public List<String> getProcessedTypes() {
        return this.processedTypes;
    }

    public MaterialPropertiesModel getProperties() {
        return this.properties;
    }

    public MaterialGasPropertiesModel getGas() {
        return this.gas;
    }

    public MaterialOreDropModel getOreDrop() {
        return this.oreDrop;
    }

    public MaterialCompatModel getCompat() {
        return this.compat;
    }

    public MaterialColorsModel getColors() {
        return this.colors;
    }

    public MaterialToolsModel getTools() {
        return this.tools;
    }

    public MaterialArmorModel getArmor() {
        return this.armor;
    }

    public ItemLike getOreDefaultDrop() {
        if (this.processedTypes.contains("ore")) {
            if (this.properties.getMaterialType().equals("gem")) {
                return this.processedTypes.contains("gem") ? (ItemLike)EERegistrar.gemMap.get(this.id).get() : this.oreDrop.getDefaultItemDropAsItem();
            }
            return this.processedTypes.contains("raw") ? (ItemLike)EERegistrar.rawMap.get(this.id).get() : this.oreDrop.getDefaultItemDropAsItem();
        }
        return (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:air"));
    }
}

