/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.parser.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ridanisaurus.emendatusenigmatica.util.ColorHelper;
import java.util.Optional;

public class MaterialColorsModel {
    public static final Codec<MaterialColorsModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.optionalFieldOf("fluidColor").forGetter(i -> Optional.of(i.fluidColor)), (App)Codec.STRING.optionalFieldOf("gasColor").forGetter(i -> Optional.of(i.gasColor)), (App)Codec.STRING.optionalFieldOf("particlesColor").forGetter(i -> Optional.of(i.particlesColor)), (App)Codec.STRING.optionalFieldOf("materialColor").forGetter(i -> Optional.of(i.materialColor)), (App)Codec.STRING.optionalFieldOf("oxidizationColor").forGetter(i -> Optional.of(i.oxidizationColor))).apply((Applicative)x, (fluidColor, gasColor, particlesColor, materialColor, oxidizationColor) -> new MaterialColorsModel(fluidColor.orElse(null), gasColor.orElse(null), particlesColor.orElse(null), materialColor.orElse(null), oxidizationColor.orElse(null))));
    private final String fluidColor;
    private final String gasColor;
    private final String particlesColor;
    private final String materialColor;
    private final String oxidizationColor;

    public MaterialColorsModel(String fluidColor, String gasColor, String particlesColor, String materialColor, String oxidizationColor) {
        this.fluidColor = fluidColor;
        this.gasColor = gasColor;
        this.particlesColor = particlesColor;
        this.materialColor = materialColor;
        this.oxidizationColor = oxidizationColor;
    }

    public MaterialColorsModel() {
        this.fluidColor = null;
        this.gasColor = null;
        this.particlesColor = null;
        this.materialColor = null;
        this.oxidizationColor = null;
    }

    public int getMaterialColor() {
        return this.materialColor != null ? ColorHelper.HEXtoDEC(this.materialColor) : -1;
    }

    public int getHighlightColor(int factor) {
        return this.materialColor != null ? ColorHelper.HEXtoDEC(ColorHelper.hueShift(this.materialColor, factor, true)) : -1;
    }

    public int getShadowColor(int factor) {
        return this.materialColor != null ? ColorHelper.HEXtoDEC(ColorHelper.hueShift(this.materialColor, factor, false)) : -1;
    }

    public int getOxidizationColor() {
        return this.oxidizationColor != null ? ColorHelper.HEXtoDEC(this.oxidizationColor) : -1;
    }

    public int getFluidColor() {
        return this.fluidColor != null ? ColorHelper.HEXtoDEC(this.fluidColor) : -1;
    }

    public int getGasColor() {
        return this.gasColor != null ? ColorHelper.HEXtoDEC(this.gasColor) : -1;
    }

    public int getParticlesColor() {
        return this.particlesColor != null ? ColorHelper.HEXtoDEC(this.particlesColor) : -1;
    }
}

