/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.parser.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectModel {
    public static final Codec<EffectModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.optionalFieldOf("effect").forGetter(i -> Optional.of(i.effect)), (App)Codec.INT.optionalFieldOf("level").forGetter(i -> Optional.of(i.level)), (App)Codec.BOOL.optionalFieldOf("showIcon").forGetter(i -> Optional.of(i.showIcon)), (App)Codec.BOOL.optionalFieldOf("showParticles").forGetter(i -> Optional.of(i.showParticles))).apply((Applicative)x, (effect, level, showIcon, showParticles) -> new EffectModel(effect.orElse(""), level.orElse(1), showIcon.orElse(true), showParticles.orElse(true))));
    private final String effect;
    private final int level;
    private final boolean showIcon;
    private final boolean showParticles;

    public EffectModel(String effect, int level, boolean showIcon, boolean showParticles) {
        this.effect = effect;
        this.level = level;
        this.showIcon = showIcon;
        this.showParticles = showParticles;
    }

    public EffectModel() {
        this.effect = "";
        this.level = 1;
        this.showIcon = true;
        this.showParticles = true;
    }

    public MobEffect getEffect() {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(this.effect));
    }

    public int getLevel() {
        return this.level - 1;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public boolean isShowParticles() {
        return this.showParticles;
    }
}

