/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.parser.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;

public class CompatModel {
    public static final Codec<CompatModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("id").forGetter(i -> i.id), (App)Codec.list(CompatRecipesModel.CODEC).fieldOf("recipes").forGetter(i -> i.recipes)).apply((Applicative)x, CompatModel::new));
    private final String id;
    private final List<CompatRecipesModel> recipes;

    public CompatModel(String id, List<CompatRecipesModel> recipes) {
        this.id = id;
        this.recipes = recipes;
    }

    public CompatModel() {
        this.id = "";
        this.recipes = List.of();
    }

    public final String getId() {
        return this.id;
    }

    public final List<CompatRecipesModel> getRecipes() {
        return this.recipes;
    }

    public static class CompatRecipesModel {
        public static final Codec<CompatRecipesModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("mod").forGetter(i -> i.mod), (App)Codec.STRING.fieldOf("machine").forGetter(i -> i.machine), (App)Codec.list(CompatValuesModel.CODEC).fieldOf("values").forGetter(i -> i.values)).apply((Applicative)x, CompatRecipesModel::new));
        private final String mod;
        private final String machine;
        private final List<CompatValuesModel> values;

        public CompatRecipesModel(String mod, String machine, List<CompatValuesModel> values) {
            this.mod = mod;
            this.machine = machine;
            this.values = values;
        }

        public CompatRecipesModel() {
            this.mod = "";
            this.machine = "";
            this.values = List.of();
        }

        public String getMod() {
            return this.mod;
        }

        public String getMachine() {
            return this.machine;
        }

        public List<CompatValuesModel> getValues() {
            return this.values;
        }
    }

    public static class CompatIOModel {
        public static final Codec<CompatIOModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.optionalFieldOf("item").forGetter(i -> Optional.ofNullable(i.item)), (App)Codec.INT.optionalFieldOf("count").forGetter(i -> Optional.of(i.count)), (App)Codec.FLOAT.optionalFieldOf("chance").forGetter(i -> Optional.of(Float.valueOf(i.chance)))).apply((Applicative)x, (item, count, chance) -> new CompatIOModel(item.orElse(""), count.orElse(0), chance.orElse(Float.valueOf(0.0f)).floatValue())));
        private final String item;
        private final int count;
        private final float chance;

        public CompatIOModel(String item, int count, float chance) {
            this.item = item;
            this.count = count;
            this.chance = chance;
        }

        public String getItem() {
            return this.item;
        }

        public int getCount() {
            return this.count;
        }

        public float getChance() {
            return this.chance;
        }
    }

    public static class CompatValuesModel {
        public static final Codec<CompatValuesModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i.type), (App)Codec.list(CompatIOModel.CODEC).fieldOf("input").orElse(List.of()).forGetter(i -> i.input), (App)Codec.list(CompatIOModel.CODEC).fieldOf("output").orElse(List.of()).forGetter(i -> i.output)).apply((Applicative)x, CompatValuesModel::new));
        private final String type;
        private final List<CompatIOModel> input;
        private final List<CompatIOModel> output;

        CompatValuesModel(String type, List<CompatIOModel> input, List<CompatIOModel> output) {
            this.type = type;
            this.input = input;
            this.output = output;
        }

        public String getType() {
            return this.type;
        }

        public List<CompatIOModel> getInput() {
            return this.input;
        }

        public List<CompatIOModel> getOutput() {
            return this.output;
        }
    }
}

