/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.deposit.model.vanilla;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonDepositModelBase;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.vanilla.VanillaDepositConfigModel;
import java.util.List;
import javax.annotation.Nullable;

public class VanillaDepositModel
extends CommonDepositModelBase {
    public static final Codec<VanillaDepositModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("type").forGetter(it -> it.type), (App)Codec.STRING.fieldOf("dimension").forGetter(it -> it.dimension), (App)Codec.list((Codec)Codec.STRING).fieldOf("biomes").orElse(List.of()).forGetter(it -> it.biomes), (App)Codec.STRING.fieldOf("registryName").forGetter(it -> it.name), (App)VanillaDepositConfigModel.CODEC.fieldOf("config").forGetter(it -> it.config)).apply((Applicative)x, VanillaDepositModel::new));
    private VanillaDepositConfigModel config;

    public VanillaDepositModel(String type, String dimension, List<String> biomes, String name, VanillaDepositConfigModel config) {
        super(type, dimension, biomes, name);
        this.config = config;
    }

    @Override
    public String getType() {
        return super.getType();
    }

    public int getMinYLevel() {
        if (this.config.minYLevel < -64 || this.config.minYLevel > 320) {
            throw new IllegalArgumentException("Min Y for " + this.name + " is out of Range [-64 - 320]");
        }
        return this.config.minYLevel;
    }

    public int getMaxYLevel() {
        if (this.config.maxYLevel < -64 || this.config.maxYLevel > 320) {
            throw new IllegalArgumentException("Max Y for " + this.name + " is out of Range [-64 - 320]");
        }
        return this.config.maxYLevel;
    }

    public String getPlacement() {
        if (!this.config.placement.equals("uniform") && !this.config.placement.equals("triangle")) {
            throw new IllegalArgumentException("Placement for " + this.name + " contains an invalid option.");
        }
        return this.config.placement;
    }

    public String getRarity() {
        if (!this.config.rarity.equals("common") && !this.config.rarity.equals("rare")) {
            throw new IllegalArgumentException("Rarity for " + this.name + " contains an invalid option.");
        }
        return this.config.rarity;
    }

    public int getChance() {
        if (this.config.chance < 1 || this.config.chance > 100) {
            throw new IllegalArgumentException("Chance for " + this.name + " is out of Range [1 - 100]");
        }
        return this.config.chance;
    }

    public int getPlacementChance() {
        return this.config.rarity.equals("rare") ? 100 - this.getChance() + 1 : this.getChance();
    }

    public int getSize() {
        if (this.config.size < 1 || this.config.size > 16) {
            throw new IllegalArgumentException("Size for " + this.name + " is out of Range [1 - 16]");
        }
        return this.config.size;
    }

    public List<String> getFillerTypes() {
        if (this.config.fillerTypes.isEmpty()) {
            throw new IllegalArgumentException("Filler Types for " + this.name + " cannot be empty.");
        }
        return this.config.fillerTypes;
    }

    @Nullable
    public String getBlock() {
        return this.config.block;
    }

    @Nullable
    public String getMaterial() {
        return this.config.material;
    }
}

