/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.deposit.model.geode;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonDepositModelBase;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.geode.GeodeDepositConfigModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.sample.SampleBlockDefinitionModel;
import java.util.List;

public class GeodeDepositModel
extends CommonDepositModelBase {
    public static final Codec<GeodeDepositModel> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("type").forGetter(it -> it.type), (App)Codec.STRING.fieldOf("dimension").forGetter(it -> it.dimension), (App)Codec.list((Codec)Codec.STRING).fieldOf("biomes").orElse(List.of()).forGetter(it -> it.biomes), (App)Codec.STRING.fieldOf("registryName").forGetter(it -> it.name), (App)GeodeDepositConfigModel.CODEC.fieldOf("config").forGetter(it -> it.config)).apply((Applicative)x, GeodeDepositModel::new));
    private final GeodeDepositConfigModel config;

    public GeodeDepositModel(String type, String dimension, List<String> biomes, String name, GeodeDepositConfigModel config) {
        super(type, dimension, biomes, name);
        this.config = config;
    }

    @Override
    public String getType() {
        return super.getType();
    }

    public List<String> getFillerTypes() {
        if (this.config.fillerTypes.isEmpty()) {
            throw new IllegalArgumentException("Filler Types for " + this.name + " cannot be empty.");
        }
        return this.config.fillerTypes;
    }

    public List<String> getClusters() {
        return this.config.clusters;
    }

    public int getMaxYLevel() {
        if (this.config.maxYLevel < -64 || this.config.maxYLevel > 320) {
            throw new IllegalArgumentException("Max Y for " + this.name + " is out of Range [-64 - 320]");
        }
        return this.config.maxYLevel;
    }

    public int getMinYLevel() {
        if (this.config.minYLevel < -64 || this.config.minYLevel > 320) {
            throw new IllegalArgumentException("Min Y for " + this.name + " is out of Range [-64 - 320]");
        }
        return this.config.minYLevel;
    }

    public int getChance() {
        if (this.config.chance < 1 || this.config.chance > 100) {
            throw new IllegalArgumentException("Chance for " + this.name + " is out of Range [1 - 100]");
        }
        return this.config.chance;
    }

    public int getPlacementChance() {
        return this.config.rarity.equals("rare") ? 100 - this.getChance() + 1 : this.getChance();
    }

    public double getCrackChance() {
        if (this.config.crackChance < 0.0 || this.config.crackChance > 1.0) {
            throw new IllegalArgumentException("Crack Chance for " + this.name + " is out of Range [0.0 - 1.0]");
        }
        return this.config.crackChance;
    }

    public List<CommonBlockDefinitionModel> getOuterShellBlocks() {
        if (this.config.outerShellBlocks.isEmpty()) {
            throw new IllegalArgumentException("Outer Shell Blocks for " + this.name + " cannot be empty.");
        }
        return this.config.outerShellBlocks;
    }

    public List<CommonBlockDefinitionModel> getInnerShellBlocks() {
        if (this.config.innerShellBlocks.isEmpty()) {
            throw new IllegalArgumentException("Inner Shell Blocks for " + this.name + " cannot be empty.");
        }
        return this.config.innerShellBlocks;
    }

    public List<CommonBlockDefinitionModel> getInnerBlocks() {
        if (this.config.innerBlocks.isEmpty()) {
            throw new IllegalArgumentException("Inner Blocks for " + this.name + " cannot be empty.");
        }
        return this.config.innerBlocks;
    }

    public List<CommonBlockDefinitionModel> getFillBlocks() {
        if (this.config.fillBlocks.isEmpty()) {
            throw new IllegalArgumentException("Fill Blocks for " + this.name + " cannot be empty.");
        }
        return this.config.fillBlocks;
    }

    public String getPlacement() {
        if (!this.config.placement.equals("uniform") && !this.config.placement.equals("triangle")) {
            throw new IllegalArgumentException("Placement for " + this.name + " is invalid.");
        }
        return this.config.placement;
    }

    public String getRarity() {
        if (!this.config.rarity.equals("common") && !this.config.rarity.equals("rare")) {
            throw new IllegalArgumentException("Rarity for " + this.name + " is invalid.");
        }
        return this.config.rarity;
    }

    public boolean getGenerateSamples() {
        return this.config.generateSamples;
    }

    public List<SampleBlockDefinitionModel> getSampleBlocks() {
        if (this.getGenerateSamples() && this.config.sampleBlocks.isEmpty()) {
            throw new IllegalArgumentException("Sample Blocks for " + this.name + " cannot be empty if generateSamples is set to true.");
        }
        return this.config.sampleBlocks;
    }
}

