/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader.deposit;

import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.loader.EELoader;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.IDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonDepositModelBase;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.dense.DenseDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.dike.DikeDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.geode.GeodeDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.sphere.SphereDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.vanilla.VanillaDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.DenseDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.DikeDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.GeodeDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.SphereDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.TestDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.VanillaDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.util.FileHelper;
import com.ridanisaurus.emendatusenigmatica.util.WorldGenHelper;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.DenseOreFeature;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.DikeOreFeature;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.GeodeOreFeature;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.SphereOreFeature;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.VanillaOreFeature;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.DenseOreFeatureConfig;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.DikeOreFeatureConfig;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.GeodeOreFeatureConfig;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.config.SphereOreFeatureConfig;
import com.ridanisaurus.emendatusenigmatica.world.gen.feature.rule.MultiStrataRuleTest;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class EEDeposits {
    public static final Map<String, Function<JsonObject, IDepositProcessor>> DEPOSIT_PROCESSORS = new HashMap<String, Function<JsonObject, IDepositProcessor>>();
    public static final List<IDepositProcessor> ACTIVE_PROCESSORS = new ArrayList<IDepositProcessor>();
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122838_, (String)"emendatusenigmatica");
    public static final DeferredRegister<ConfiguredFeature<?, ?>> ORE_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"emendatusenigmatica");
    public static final DeferredRegister<PlacedFeature> PLACED_ORE_FEATURES = DeferredRegister.create((ResourceKey)Registry.f_194567_, (String)"emendatusenigmatica");
    private final EELoader loader;

    public EEDeposits(EELoader loader) {
        this.loader = loader;
    }

    public void initProcessors() {
        DEPOSIT_PROCESSORS.put(DepositType.VANILLA.getType(), VanillaDepositProcessor::new);
        DEPOSIT_PROCESSORS.put(DepositType.SPHERE.getType(), SphereDepositProcessor::new);
        DEPOSIT_PROCESSORS.put(DepositType.GEODE.getType(), GeodeDepositProcessor::new);
        DEPOSIT_PROCESSORS.put(DepositType.DIKE.getType(), DikeDepositProcessor::new);
        DEPOSIT_PROCESSORS.put(DepositType.DENSE.getType(), DenseDepositProcessor::new);
        DEPOSIT_PROCESSORS.put(DepositType.TEST.getType(), TestDepositProcessor::new);
    }

    public void load() {
        File depositDir;
        Path configDir;
        if (DEPOSIT_PROCESSORS.isEmpty()) {
            this.initProcessors();
        }
        if (!(configDir = FMLPaths.CONFIGDIR.get().resolve("emendatusenigmatica/")).toFile().exists() && configDir.toFile().mkdirs()) {
            EmendatusEnigmatica.LOGGER.info("Created /config/emendatusenigmatica/");
        }
        if (!(depositDir = configDir.resolve("deposit/").toFile()).exists() && depositDir.mkdirs()) {
            EmendatusEnigmatica.LOGGER.info("Created /config/emendatusenigmatica/deposit/");
        }
        ArrayList<JsonObject> depositJsonDefinitions = FileHelper.loadFilesAsJsonObjects(depositDir);
        for (JsonObject depositJsonDefinition : depositJsonDefinitions) {
            String type;
            Function processor;
            if (!depositJsonDefinition.has("type") || (processor = (Function)DEPOSIT_PROCESSORS.getOrDefault(type = depositJsonDefinition.get("type").getAsString(), null)) == null) continue;
            ACTIVE_PROCESSORS.add((IDepositProcessor)processor.apply(depositJsonDefinition));
        }
        for (IDepositProcessor activeProcessor : ACTIVE_PROCESSORS) {
            activeProcessor.load();
        }
    }

    public void setup() {
        for (IDepositProcessor activeProcessor : ACTIVE_PROCESSORS) {
            HeightRangePlacement placement;
            RegistryObject oreFeature;
            CommonDepositModelBase model;
            if (activeProcessor.getType().equals(DepositType.VANILLA.getType())) {
                model = ((VanillaDepositProcessor)activeProcessor).getVanillaModel();
                RegistryObject vanillaOreFeature = FEATURES.register(model.getName(), () -> this.lambda$setup$0((VanillaDepositModel)model));
                oreFeature = ORE_FEATURES.register(model.getName(), () -> new ConfiguredFeature((Feature)((VanillaOreFeature)((Object)((Object)vanillaOreFeature.get()))), (FeatureConfiguration)new NoneFeatureConfiguration()));
                placement = ((VanillaDepositModel)model).getPlacement().equals("uniform") ? HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((VanillaDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((VanillaDepositModel)model).getMaxYLevel())) : HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)((VanillaDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((VanillaDepositModel)model).getMaxYLevel()));
                PLACED_ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$2(oreFeature, (VanillaDepositModel)model, placement));
            }
            if (activeProcessor.getType().equals(DepositType.SPHERE.getType())) {
                model = ((SphereDepositProcessor)activeProcessor).getSphereModel();
                RegistryObject sphereOreFeature = FEATURES.register(model.getName(), () -> this.lambda$setup$3((SphereDepositModel)model));
                oreFeature = ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$4(sphereOreFeature, (SphereDepositModel)model));
                placement = ((SphereDepositModel)model).getPlacement().equals("uniform") ? HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((SphereDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((SphereDepositModel)model).getMaxYLevel())) : HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)((SphereDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((SphereDepositModel)model).getMaxYLevel()));
                PLACED_ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$5(oreFeature, (SphereDepositModel)model, placement));
            }
            if (activeProcessor.getType().equals(DepositType.GEODE.getType())) {
                model = ((GeodeDepositProcessor)activeProcessor).getGeodeModel();
                RegistryObject geodeOreFeature = FEATURES.register(model.getName(), () -> this.lambda$setup$6((GeodeDepositModel)model));
                oreFeature = ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$7(geodeOreFeature, (GeodeDepositModel)model));
                placement = ((GeodeDepositModel)model).getPlacement().equals("uniform") ? HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((GeodeDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((GeodeDepositModel)model).getMaxYLevel())) : HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)((GeodeDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((GeodeDepositModel)model).getMaxYLevel()));
                PLACED_ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$8(oreFeature, (GeodeDepositModel)model, placement));
            }
            if (activeProcessor.getType().equals(DepositType.DIKE.getType())) {
                model = ((DikeDepositProcessor)activeProcessor).getDikeModel();
                RegistryObject dikeOreFeature = FEATURES.register(model.getName(), () -> this.lambda$setup$9((DikeDepositModel)model));
                oreFeature = ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$10(dikeOreFeature, (DikeDepositModel)model));
                placement = ((DikeDepositModel)model).getPlacement().equals("uniform") ? HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((DikeDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((DikeDepositModel)model).getMaxYLevel())) : HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)((DikeDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((DikeDepositModel)model).getMaxYLevel()));
                PLACED_ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$11(oreFeature, (DikeDepositModel)model, placement));
            }
            if (!activeProcessor.getType().equals(DepositType.DENSE.getType())) continue;
            model = ((DenseDepositProcessor)activeProcessor).getDenseModel();
            RegistryObject denseOreFeature = FEATURES.register(model.getName(), () -> this.lambda$setup$12((DenseDepositModel)model));
            oreFeature = ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$13(denseOreFeature, (DenseDepositModel)model));
            placement = ((DenseDepositModel)model).getPlacement().equals("uniform") ? HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)((DenseDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((DenseDepositModel)model).getMaxYLevel())) : HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)((DenseDepositModel)model).getMinYLevel()), (VerticalAnchor)VerticalAnchor.m_158922_((int)((DenseDepositModel)model).getMaxYLevel()));
            PLACED_ORE_FEATURES.register(model.getName(), () -> EEDeposits.lambda$setup$14(oreFeature, (DenseDepositModel)model, placement));
        }
    }

    public void finalize(IEventBus eventBus) {
        FEATURES.register(eventBus);
        ORE_FEATURES.register(eventBus);
        PLACED_ORE_FEATURES.register(eventBus);
    }

    private static /* synthetic */ PlacedFeature lambda$setup$14(RegistryObject oreFeature, DenseDepositModel model, HeightRangePlacement placement) {
        return new PlacedFeature((Holder)oreFeature.getHolder().get(), model.getRarity().equals("common") ? WorldGenHelper.commonOrePlacement(model.getPlacementChance(), (PlacementModifier)placement) : WorldGenHelper.rareOrePlacement(model.getPlacementChance(), (PlacementModifier)placement));
    }

    private static /* synthetic */ ConfiguredFeature lambda$setup$13(RegistryObject denseOreFeature, DenseDepositModel model) {
        return new ConfiguredFeature((Feature)((DenseOreFeature)((Object)denseOreFeature.get())), (FeatureConfiguration)new DenseOreFeatureConfig(new MultiStrataRuleTest(model.getFillerTypes())));
    }

    private /* synthetic */ DenseOreFeature lambda$setup$12(DenseDepositModel model) {
        return new DenseOreFeature(DenseOreFeatureConfig.CODEC, model, this.loader.getDataRegistry());
    }

    private static /* synthetic */ PlacedFeature lambda$setup$11(RegistryObject oreFeature, DikeDepositModel model, HeightRangePlacement placement) {
        return new PlacedFeature((Holder)oreFeature.getHolder().get(), model.getRarity().equals("common") ? WorldGenHelper.commonOrePlacement(model.getPlacementChance(), (PlacementModifier)placement) : WorldGenHelper.rareOrePlacement(model.getPlacementChance(), (PlacementModifier)placement));
    }

    private static /* synthetic */ ConfiguredFeature lambda$setup$10(RegistryObject dikeOreFeature, DikeDepositModel model) {
        return new ConfiguredFeature((Feature)((DikeOreFeature)((Object)dikeOreFeature.get())), (FeatureConfiguration)new DikeOreFeatureConfig(new MultiStrataRuleTest(model.getFillerTypes())));
    }

    private /* synthetic */ DikeOreFeature lambda$setup$9(DikeDepositModel model) {
        return new DikeOreFeature(DikeOreFeatureConfig.CODEC, model, this.loader.getDataRegistry());
    }

    private static /* synthetic */ PlacedFeature lambda$setup$8(RegistryObject oreFeature, GeodeDepositModel model, HeightRangePlacement placement) {
        return new PlacedFeature((Holder)oreFeature.getHolder().get(), model.getRarity().equals("common") ? WorldGenHelper.commonOrePlacement(model.getPlacementChance(), (PlacementModifier)placement) : WorldGenHelper.rareOrePlacement(model.getPlacementChance(), (PlacementModifier)placement));
    }

    private static /* synthetic */ ConfiguredFeature lambda$setup$7(RegistryObject geodeOreFeature, GeodeDepositModel model) {
        return new ConfiguredFeature((Feature)((GeodeOreFeature)((Object)geodeOreFeature.get())), (FeatureConfiguration)new GeodeOreFeatureConfig(new MultiStrataRuleTest(model.getFillerTypes())));
    }

    private /* synthetic */ GeodeOreFeature lambda$setup$6(GeodeDepositModel model) {
        return new GeodeOreFeature(GeodeOreFeatureConfig.CODEC, model, this.loader.getDataRegistry());
    }

    private static /* synthetic */ PlacedFeature lambda$setup$5(RegistryObject oreFeature, SphereDepositModel model, HeightRangePlacement placement) {
        return new PlacedFeature((Holder)oreFeature.getHolder().get(), model.getRarity().equals("common") ? WorldGenHelper.commonOrePlacement(model.getPlacementChance(), (PlacementModifier)placement) : WorldGenHelper.rareOrePlacement(model.getPlacementChance(), (PlacementModifier)placement));
    }

    private static /* synthetic */ ConfiguredFeature lambda$setup$4(RegistryObject sphereOreFeature, SphereDepositModel model) {
        return new ConfiguredFeature((Feature)((SphereOreFeature)((Object)sphereOreFeature.get())), (FeatureConfiguration)new SphereOreFeatureConfig(new MultiStrataRuleTest(model.getFillerTypes())));
    }

    private /* synthetic */ SphereOreFeature lambda$setup$3(SphereDepositModel model) {
        return new SphereOreFeature(SphereOreFeatureConfig.CODEC, model, this.loader.getDataRegistry());
    }

    private static /* synthetic */ PlacedFeature lambda$setup$2(RegistryObject oreFeature, VanillaDepositModel model, HeightRangePlacement placement) {
        return new PlacedFeature((Holder)oreFeature.getHolder().get(), model.getRarity().equals("common") ? WorldGenHelper.commonOrePlacement(model.getPlacementChance(), (PlacementModifier)placement) : WorldGenHelper.rareOrePlacement(model.getPlacementChance(), (PlacementModifier)placement));
    }

    private /* synthetic */ VanillaOreFeature lambda$setup$0(VanillaDepositModel model) {
        return new VanillaOreFeature(model, this.loader.getDataRegistry());
    }

    public static enum DepositType {
        VANILLA("emendatusenigmatica:vanilla_deposit"),
        SPHERE("emendatusenigmatica:sphere_deposit"),
        GEODE("emendatusenigmatica:geode_deposit"),
        DIKE("emendatusenigmatica:dike_deposit"),
        DENSE("emendatusenigmatica:dense_deposit"),
        TEST("emendatusenigmatica:test_deposit");

        private final String type;

        private DepositType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

