/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.loader;

import com.ridanisaurus.emendatusenigmatica.api.AnnotationUtil;
import com.ridanisaurus.emendatusenigmatica.api.EmendatusDataRegistry;
import com.ridanisaurus.emendatusenigmatica.api.IEmendatusPlugin;
import com.ridanisaurus.emendatusenigmatica.api.annotation.EmendatusPluginReference;
import com.ridanisaurus.emendatusenigmatica.plugin.DefaultConfigPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.DataGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EELoader {
    public static final Logger LOADER_LOGGER = LogManager.getLogger(EELoader.class);
    private final EmendatusDataRegistry dataRegistry = new EmendatusDataRegistry();
    private List<IEmendatusPlugin> plugins = new ArrayList<IEmendatusPlugin>();

    public EELoader() {
        this.scanForClasses();
    }

    private void scanForClasses() {
        for (Class annotatedClass : AnnotationUtil.getAnnotatedClasses(EmendatusPluginReference.class)) {
            if (IEmendatusPlugin.class.isAssignableFrom(annotatedClass)) {
                EmendatusPluginReference annotation = annotatedClass.getAnnotation(EmendatusPluginReference.class);
                LOADER_LOGGER.info("Registered plugin " + annotation.modid() + ":" + annotation.name());
                try {
                    if (annotatedClass.equals(DefaultConfigPlugin.class)) {
                        this.plugins.add(0, (IEmendatusPlugin)annotatedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        continue;
                    }
                    this.plugins.add((IEmendatusPlugin)annotatedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOADER_LOGGER.error((Object)e);
                }
                continue;
            }
            LOADER_LOGGER.error(annotatedClass.getName() + " has an annotation but it doesn't implement IEmendatusPlugin");
        }
        LOADER_LOGGER.info("Finished scanning for plugins");
    }

    public void load() {
        this.plugins.forEach(iEmendatusPlugin -> iEmendatusPlugin.load(this.dataRegistry));
        this.plugins.forEach(iEmendatusPlugin -> iEmendatusPlugin.registerMinecraft(this.dataRegistry.getMaterials(), this.dataRegistry.getStrata()));
    }

    public void datagen(DataGenerator dataGenerator) {
        this.plugins.forEach(iEmendatusPlugin -> iEmendatusPlugin.registerDynamicDataGen(dataGenerator, this.dataRegistry));
    }

    public void finish() {
        this.plugins.forEach(iEmendatusPlugin -> iEmendatusPlugin.finish(this.dataRegistry));
    }

    public EmendatusDataRegistry getDataRegistry() {
        return this.dataRegistry;
    }
}

