/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.items;

import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaxelItem
extends DiggerItem {
    private static final ToolAction PAXEL_DIG = ToolAction.get((String)"paxel_dig");

    public PaxelItem(Tier tier, float dmgMod, float speedMod, Item.Properties props) {
        super(dmgMod, speedMod, tier, EETags.MINEABLE_WITH_PAXEL, props);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == PAXEL_DIG || ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState blockstate = world.m_8055_(blockpos);
        BlockState resultToSet = this.useAsAxe(blockstate, context);
        if (resultToSet == null) {
            if (context.m_43719_() == Direction.DOWN) {
                return InteractionResult.PASS;
            }
            BlockState foundResult = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
            if (foundResult != null && world.m_46859_(blockpos.m_7494_())) {
                world.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                resultToSet = foundResult;
            } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!world.f_46443_) {
                    world.m_5898_(null, 1009, blockpos, 0);
                }
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)world, (BlockPos)blockpos, (BlockState)blockstate);
                resultToSet = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
            if (resultToSet == null) {
                return InteractionResult.PASS;
            }
        }
        if (!world.f_46443_) {
            ItemStack stack = context.m_43722_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_220040_(serverPlayer, blockpos, stack);
            }
            world.m_7731_(blockpos, resultToSet, 11);
            if (player != null) {
                stack.m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(context.m_43724_()));
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    @Nullable
    private BlockState useAsAxe(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState resultToSet = state.getToolModifiedState(context, ToolActions.AXE_STRIP, false);
        if (resultToSet != null) {
            world.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return resultToSet;
        }
        resultToSet = state.getToolModifiedState(context, ToolActions.AXE_SCRAPE, false);
        if (resultToSet != null) {
            world.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3005, blockpos, 0);
            return resultToSet;
        }
        resultToSet = state.getToolModifiedState(context, ToolActions.AXE_WAX_OFF, false);
        if (resultToSet != null) {
            world.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_5898_(player, 3004, blockpos, 0);
            return resultToSet;
        }
        return null;
    }
}

