/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.items;

import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.renderers.ShieldTextureRenderer;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicShieldItem
extends ShieldItem {
    public final int highlight2;
    public final int highlight1;
    public final int base;
    public final int shadow1;
    public final int shadow2;
    public final TagKey<Item> repairItem;
    public final MaterialModel material;

    public BasicShieldItem(MaterialModel material, TagKey<Item> repairItem) {
        super(new Item.Properties().m_41491_(EmendatusEnigmatica.TAB).m_41503_(material.getArmor().getShield().getDurability()));
        this.highlight2 = material.getColors().getHighlightColor(3);
        this.highlight1 = material.getColors().getHighlightColor(1);
        this.base = material.getColors().getMaterialColor();
        this.shadow1 = material.getColors().getShadowColor(1);
        this.shadow2 = material.getColors().getShadowColor(2);
        this.repairItem = repairItem;
        this.material = material;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ShieldTextureRenderer.RENDERER;
            }
        });
    }

    public Ingredient getRepairMaterial() {
        return Ingredient.m_204132_(this.repairItem);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.getArmor().getShield().getDurability();
    }

    public boolean m_41465_() {
        return this.material.getArmor().getShield().getDurability() > 0;
    }

    public boolean m_6832_(@NotNull ItemStack toRepair, @NotNull ItemStack repair) {
        return this.getRepairMaterial().test(repair);
    }

    public int m_6473_() {
        return this.material.getArmor().getEnchantability();
    }

    public MaterialModel getMaterialModel() {
        return this.material;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.material.getColors().getMaterialColor() == -1) {
            return super.getArmorTexture(stack, entity, slot, type);
        }
        return new ResourceLocation("emendatusenigmatica", "textures/armor/empty.png").toString();
    }

    public int getColorForIndex(int index) {
        switch (index) {
            case 0: {
                return this.material.getColors().getHighlightColor(2);
            }
            case 1: {
                return this.material.getColors().getHighlightColor(1);
            }
            case 3: {
                return this.material.getColors().getShadowColor(1);
            }
            case 4: {
                return this.material.getColors().getShadowColor(2);
            }
        }
        this.material.getColors().getMaterialColor();
        return this.material.getColors().getMaterialColor();
    }
}

