/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.items;

import com.ridanisaurus.emendatusenigmatica.EmendatusEnigmatica;
import com.ridanisaurus.emendatusenigmatica.items.ArmorTier;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.ArmorModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.EffectModel;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.registries.EERegistrar;
import com.ridanisaurus.emendatusenigmatica.util.RomanNumberHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BasicArmorItem
extends ArmorItem {
    private final MaterialModel material;
    public final boolean isSet;
    public final List<EffectModel> effects;
    public final int highlight2;
    public final int highlight1;
    public final int base;
    public final int shadow1;
    public final int shadow2;

    public BasicArmorItem(MaterialModel material, TagKey<Item> repairItem, EquipmentSlot slot, ArmorModel model) {
        super((ArmorMaterial)new ArmorTier(material.getId(), model.getDurability(), model.getProtection(), material.getArmor().getEnchantability(), material.getArmor().getToughness(), material.getArmor().getKnockback(), () -> Ingredient.m_204132_((TagKey)repairItem)), slot, new Item.Properties().m_41491_(EmendatusEnigmatica.TAB));
        this.material = material;
        this.isSet = material.getArmor().isSetArmor();
        this.effects = material.getArmor().getEffects();
        this.highlight2 = material.getColors().getHighlightColor(3);
        this.highlight1 = material.getColors().getHighlightColor(1);
        this.base = material.getColors().getMaterialColor();
        this.shadow1 = material.getColors().getShadowColor(1);
        this.shadow2 = material.getColors().getShadowColor(2);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        super.onArmorTick(stack, level, player);
        if (this.isSet && this.isSetActive(player)) {
            for (EffectModel effect : this.effects) {
                player.m_7292_(new MobEffectInstance(effect.getEffect(), 600, effect.getLevel(), true, effect.isShowParticles(), effect.isShowIcon()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && this.isSet) {
            ItemStack[] setPieces = this.getSet();
            components.add((Component)Component.m_237113_((String)this.material.getArmor().getSetName()).m_130946_(" (" + this.getPiecesEquipped((Player)player) + "/" + setPieces.length + ") ").m_130940_(ChatFormatting.AQUA));
            if (!Screen.m_96638_()) {
                components.add((Component)Component.m_237113_((String)"Press [SHIFT] for more info").m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (Screen.m_96638_()) {
                for (int i = 0; i < setPieces.length; ++i) {
                    components.add((Component)setPieces[i].m_41786_().m_6879_().m_130940_(this.hasSetPiece((Player)player, EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)(setPieces.length - i - 1))) ? ChatFormatting.GOLD : ChatFormatting.DARK_GRAY));
                }
                components.add((Component)Component.m_237113_((String)" "));
                components.add((Component)Component.m_237113_((String)this.material.getArmor().getSetDesc()).m_130940_(this.isSetActive((Player)player) ? ChatFormatting.GOLD : ChatFormatting.DARK_GRAY));
                components.add((Component)Component.m_237113_((String)" "));
                components.add((Component)Component.m_237113_((String)"Effect(s):").m_130940_(ChatFormatting.GRAY));
                for (EffectModel effect : this.effects) {
                    components.add((Component)Component.m_237113_((String)("- " + effect.getEffect().m_19482_().getString() + " " + RomanNumberHelper.toRoman(effect.getLevel() + 1))).m_130940_(this.isSetActive((Player)player) ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    public boolean isSetActive(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_41720_() == EERegistrar.helmetMap.get(this.material.getId()).get() && player.m_6844_(EquipmentSlot.CHEST).m_41720_() == EERegistrar.chestplateMap.get(this.material.getId()).get() && player.m_6844_(EquipmentSlot.LEGS).m_41720_() == EERegistrar.leggingsMap.get(this.material.getId()).get() && player.m_6844_(EquipmentSlot.FEET).m_41720_() == EERegistrar.bootsMap.get(this.material.getId()).get();
    }

    public ItemStack[] getSet() {
        return new ItemStack[]{new ItemStack((ItemLike)EERegistrar.helmetMap.get(this.material.getId()).get()), new ItemStack((ItemLike)EERegistrar.chestplateMap.get(this.material.getId()).get()), new ItemStack((ItemLike)EERegistrar.leggingsMap.get(this.material.getId()).get()), new ItemStack((ItemLike)EERegistrar.bootsMap.get(this.material.getId()).get())};
    }

    public boolean hasSetPiece(Player player, EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> {
                if (player.m_6844_(slot).m_41720_() == EERegistrar.helmetMap.get(this.material.getId()).get()) {
                    yield true;
                }
                yield false;
            }
            case EquipmentSlot.CHEST -> {
                if (player.m_6844_(slot).m_41720_() == EERegistrar.chestplateMap.get(this.material.getId()).get()) {
                    yield true;
                }
                yield false;
            }
            case EquipmentSlot.LEGS -> {
                if (player.m_6844_(slot).m_41720_() == EERegistrar.leggingsMap.get(this.material.getId()).get()) {
                    yield true;
                }
                yield false;
            }
            case EquipmentSlot.FEET -> {
                if (player.m_6844_(slot).m_41720_() == EERegistrar.bootsMap.get(this.material.getId()).get()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private int getPiecesEquipped(Player player) {
        EquipmentSlot[] values;
        int armorPieces = 0;
        for (EquipmentSlot slot : values = EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !this.hasSetPiece(player, slot)) continue;
            ++armorPieces;
        }
        return armorPieces;
    }

    public MaterialModel getMaterialModel() {
        return this.material;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.material.getColors().getMaterialColor() == -1) {
            return super.getArmorTexture(stack, entity, slot, type);
        }
        return new ResourceLocation("emendatusenigmatica", "textures/armor/empty.png").toString();
    }

    public int getColorForIndex(int index) {
        switch (index) {
            case 0: {
                return this.material.getColors().getHighlightColor(2);
            }
            case 1: {
                return this.material.getColors().getHighlightColor(1);
            }
            case 3: {
                return this.material.getColors().getShadowColor(1);
            }
            case 4: {
                return this.material.getColors().getShadowColor(2);
            }
        }
        this.material.getColors().getMaterialColor();
        return this.material.getColors().getMaterialColor();
    }
}

