/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.integration;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.EEDeposits;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.IDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonBlockDefinitionModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.common.CommonDepositModelBase;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.dense.DenseDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.dike.DikeDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.geode.GeodeDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.sphere.SphereDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.model.vanilla.VanillaDepositModel;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.DenseDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.DikeDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.GeodeDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.SphereDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.deposit.processsors.VanillaDepositProcessor;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.MaterialModel;
import com.ridanisaurus.emendatusenigmatica.registries.EETags;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class WorldGenRecipeCategory
implements IRecipeCategory<WorldGenWrapper> {
    private static final ResourceLocation ID = new ResourceLocation("emendatusenigmatica", "world_gen");
    public static final RecipeType<WorldGenWrapper> RECIPE = new RecipeType(ID, WorldGenWrapper.class);
    private final IGuiHelper guiHelper;
    private final Component title;

    public WorldGenRecipeCategory(IGuiHelper guiHelper, String title) {
        this.guiHelper = guiHelper;
        this.title = Component.m_237115_((String)title);
    }

    public static List<WorldGenWrapper> getWorldGenRecipes(MaterialModel material, IDepositProcessor activeProcessor) {
        ArrayList<WorldGenWrapper> recipes;
        block11: {
            block12: {
                recipes = new ArrayList<WorldGenWrapper>();
                if (!material.getProcessedTypes().contains("ore")) break block11;
                if (!(activeProcessor instanceof VanillaDepositProcessor)) break block12;
                VanillaDepositModel model = ((VanillaDepositProcessor)activeProcessor).getVanillaModel();
                String depositMaterial = model.getMaterial();
                if (depositMaterial == null || !depositMaterial.equals(material.getId())) break block11;
                recipes.add(new WorldGenWrapper(material, activeProcessor));
                break block11;
            }
            if (activeProcessor instanceof GeodeDepositProcessor) {
                GeodeDepositModel model = ((GeodeDepositProcessor)activeProcessor).getGeodeModel();
                List<CommonBlockDefinitionModel> innerBlocks = model.getInnerBlocks();
                for (CommonBlockDefinitionModel innerBlock : innerBlocks) {
                    String depositMaterial = innerBlock.getMaterial();
                    if (depositMaterial == null || !depositMaterial.equals(material.getId())) continue;
                    recipes.add(new WorldGenWrapper(material, activeProcessor));
                }
            } else if (activeProcessor instanceof SphereDepositProcessor) {
                SphereDepositModel model = ((SphereDepositProcessor)activeProcessor).getSphereModel();
                List<CommonBlockDefinitionModel> blocks = model.getBlocks();
                for (CommonBlockDefinitionModel block : blocks) {
                    String depositMaterial = block.getMaterial();
                    if (depositMaterial == null || !depositMaterial.equals(material.getId())) continue;
                    recipes.add(new WorldGenWrapper(material, activeProcessor));
                }
            } else if (activeProcessor instanceof DenseDepositProcessor) {
                DenseDepositModel model = ((DenseDepositProcessor)activeProcessor).getDenseModel();
                List<CommonBlockDefinitionModel> blocks = model.getBlocks();
                for (CommonBlockDefinitionModel block : blocks) {
                    String depositMaterial = block.getMaterial();
                    if (depositMaterial == null || !depositMaterial.equals(material.getId())) continue;
                    recipes.add(new WorldGenWrapper(material, activeProcessor));
                }
            } else if (activeProcessor instanceof DikeDepositProcessor) {
                DikeDepositModel model = ((DikeDepositProcessor)activeProcessor).getDikeModel();
                List<CommonBlockDefinitionModel> blocks = model.getBlocks();
                for (CommonBlockDefinitionModel block : blocks) {
                    String depositMaterial = block.getMaterial();
                    if (depositMaterial == null || !depositMaterial.equals(material.getId())) continue;
                    recipes.add(new WorldGenWrapper(material, activeProcessor));
                }
            }
        }
        return recipes;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, WorldGenWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).addIngredients(Ingredient.m_204132_(EETags.MATERIAL_ORE.apply(recipe.material.getId())));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 39, 6).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{recipe.material.getOreDefaultDrop()}));
    }

    public RecipeType<WorldGenWrapper> getRecipeType() {
        return RECIPE;
    }

    public void draw(WorldGenWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrix, double mouseX, double mouseY) {
        String featureType = ChatFormatting.DARK_AQUA + "Type: " + ChatFormatting.DARK_GRAY + recipe.getTypeName();
        String minY = ChatFormatting.DARK_AQUA + "Min Y: " + ChatFormatting.DARK_GRAY + recipe.getMinY();
        String maxY = ChatFormatting.DARK_AQUA + "Max Y: " + ChatFormatting.DARK_GRAY + recipe.getMaxY();
        String chance = ChatFormatting.DARK_AQUA + "Chance: " + ChatFormatting.DARK_GRAY + recipe.getChance() + "%";
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, featureType, 5.0f, 30.0f, 0);
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, minY, 5.0f, 42.0f, 0);
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, maxY, 75.0f, 42.0f, 0);
        Minecraft.m_91087_().f_91062_.m_92883_(matrix, chance, 5.0f, 54.0f, 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("emendatusenigmatica", "textures/gui/world_gen.png"));
        if (recipe.getDimension().equals("Overworld")) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 74, 8, 134, 0, 12, 12);
        } else if (recipe.getDimension().equals("The Nether")) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 74, 8, 134, 12, 12, 12);
        } else if (recipe.getDimension().equals("The End")) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 74, 8, 134, 24, 12, 12);
        } else {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 74, 8, 134, 36, 12, 12);
        }
        if (recipe.getBiomes().contains("#" + BiomeTags.f_207602_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 0, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207603_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 12, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207604_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 24, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207605_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 36, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207606_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 48, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207607_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 60, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207608_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 72, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207609_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 84, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207610_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 96, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_207611_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 108, 12, 12);
        } else if (recipe.getBiomes().contains("#" + BiomeTags.f_215816_.f_203868_().toString())) {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 120, 12, 12);
        } else {
            Minecraft.m_91087_().f_91080_.m_93228_(matrix, 91, 8, 146, 132, 12, 12);
        }
        if (!recipe.getType().equals(EEDeposits.DepositType.VANILLA.getType())) {
            if (recipe.hasSurfaceSample()) {
                Minecraft.m_91087_().f_91080_.m_93228_(matrix, 108, 8, 158, 0, 12, 12);
            } else {
                Minecraft.m_91087_().f_91080_.m_93228_(matrix, 108, 8, 158, 12, 12, 12);
            }
        }
    }

    public List<Component> getTooltipStrings(WorldGenWrapper recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 74.0 && mouseX < 86.0 && mouseY > 8.0 && mouseY < 20.0) {
            ArrayList<Component> dimension = new ArrayList<Component>();
            dimension.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Dimension:")));
            dimension.add((Component)Component.m_237113_((String)recipe.getDimension()));
            return dimension;
        }
        if (mouseX > 91.0 && mouseX < 103.0 && mouseY > 8.0 && mouseY < 20.0) {
            ArrayList<Component> biomes = new ArrayList<Component>();
            biomes.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Biomes:")));
            if (recipe.getBiomes().size() == 0) {
                biomes.add((Component)Component.m_237113_((String)"- Any"));
            } else {
                for (String biome : recipe.getBiomes()) {
                    biomes.add((Component)Component.m_237113_((String)"- ").m_7220_((Component)Component.m_237113_((String)biome)));
                }
            }
            return biomes;
        }
        if (mouseX > 108.0 && mouseX < 120.0 && mouseY > 8.0 && mouseY < 20.0 && !recipe.getType().equals(EEDeposits.DepositType.VANILLA.getType())) {
            ArrayList<Component> surfaceSamples = new ArrayList<Component>();
            surfaceSamples.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Generate Surface Samples:")));
            if (recipe.hasSurfaceSample()) {
                surfaceSamples.add((Component)Component.m_237113_((String)"True"));
            } else {
                surfaceSamples.add((Component)Component.m_237113_((String)"False"));
            }
            return surfaceSamples;
        }
        if (mouseX > 26.0 && mouseX < 35.0 && mouseY > 6.0 && mouseY < 22.0) {
            ArrayList<Component> oreDropInfo = new ArrayList<Component>();
            oreDropInfo.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Ore Drop Info:")));
            oreDropInfo.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_AQUA + "Min: " + ChatFormatting.WHITE + recipe.material.getOreDrop().getMin())));
            oreDropInfo.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_AQUA + "Max: " + ChatFormatting.WHITE + recipe.material.getOreDrop().getMax())));
            return oreDropInfo;
        }
        if (mouseX > 5.0 && mouseX < 129.0 && mouseY > 42.0 && mouseY < 49.0) {
            ArrayList<Component> optimalY = new ArrayList<Component>();
            optimalY.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Optimal Y:")));
            optimalY.add((Component)Component.m_237113_((String)String.valueOf((recipe.getMinY() + recipe.getMaxY()) / 2)));
            return optimalY;
        }
        return Collections.emptyList();
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("emendatusenigmatica", "textures/gui/world_gen.png"), 0, 0, 134, 66).addPadding(0, 0, 0, 0).build();
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42385_));
    }

    public static class WorldGenWrapper {
        private MaterialModel material;
        private IDepositProcessor activeProcessor;

        public WorldGenWrapper(MaterialModel material, IDepositProcessor activeProcessor) {
            this.material = material;
            this.activeProcessor = activeProcessor;
        }

        public String getType() {
            return this.activeProcessor.getType();
        }

        public String getTypeName() {
            return this.stripString(this.getType());
        }

        public CommonDepositModelBase getCommonModel() {
            return this.activeProcessor.getCommonModel();
        }

        public String getDeposit() {
            return this.stripString(this.getCommonModel().getName());
        }

        public String getDimension() {
            return this.stripString(this.getCommonModel().getDimension());
        }

        public List<String> getBiomes() {
            return this.getCommonModel().getBiomes();
        }

        public boolean hasSurfaceSample() {
            if (this.activeProcessor instanceof VanillaDepositProcessor) {
                return false;
            }
            if (this.activeProcessor instanceof GeodeDepositProcessor) {
                GeodeDepositModel model = ((GeodeDepositProcessor)this.activeProcessor).getGeodeModel();
                return model.getGenerateSamples();
            }
            if (this.activeProcessor instanceof SphereDepositProcessor) {
                SphereDepositModel model = ((SphereDepositProcessor)this.activeProcessor).getSphereModel();
                return model.getGenerateSamples();
            }
            if (this.activeProcessor instanceof DenseDepositProcessor) {
                DenseDepositModel model = ((DenseDepositProcessor)this.activeProcessor).getDenseModel();
                return model.getGenerateSamples();
            }
            if (this.activeProcessor instanceof DikeDepositProcessor) {
                DikeDepositModel model = ((DikeDepositProcessor)this.activeProcessor).getDikeModel();
                return model.getGenerateSamples();
            }
            return false;
        }

        public int getMinY() {
            if (this.activeProcessor instanceof VanillaDepositProcessor) {
                VanillaDepositModel model = ((VanillaDepositProcessor)this.activeProcessor).getVanillaModel();
                return model.getMinYLevel();
            }
            if (this.activeProcessor instanceof GeodeDepositProcessor) {
                GeodeDepositModel model = ((GeodeDepositProcessor)this.activeProcessor).getGeodeModel();
                return model.getMinYLevel();
            }
            if (this.activeProcessor instanceof SphereDepositProcessor) {
                SphereDepositModel model = ((SphereDepositProcessor)this.activeProcessor).getSphereModel();
                return model.getMinYLevel();
            }
            if (this.activeProcessor instanceof DenseDepositProcessor) {
                DenseDepositModel model = ((DenseDepositProcessor)this.activeProcessor).getDenseModel();
                return model.getMinYLevel();
            }
            if (this.activeProcessor instanceof DikeDepositProcessor) {
                DikeDepositModel model = ((DikeDepositProcessor)this.activeProcessor).getDikeModel();
                return model.getMinYLevel();
            }
            return -1;
        }

        public int getMaxY() {
            if (this.activeProcessor instanceof VanillaDepositProcessor) {
                VanillaDepositModel model = ((VanillaDepositProcessor)this.activeProcessor).getVanillaModel();
                return model.getMaxYLevel();
            }
            if (this.activeProcessor instanceof GeodeDepositProcessor) {
                GeodeDepositModel model = ((GeodeDepositProcessor)this.activeProcessor).getGeodeModel();
                return model.getMaxYLevel();
            }
            if (this.activeProcessor instanceof SphereDepositProcessor) {
                SphereDepositModel model = ((SphereDepositProcessor)this.activeProcessor).getSphereModel();
                return model.getMaxYLevel();
            }
            if (this.activeProcessor instanceof DenseDepositProcessor) {
                DenseDepositModel model = ((DenseDepositProcessor)this.activeProcessor).getDenseModel();
                return model.getMaxYLevel();
            }
            if (this.activeProcessor instanceof DikeDepositProcessor) {
                DikeDepositModel model = ((DikeDepositProcessor)this.activeProcessor).getDikeModel();
                return model.getMaxYLevel();
            }
            return -1;
        }

        public int getChance() {
            if (this.activeProcessor instanceof VanillaDepositProcessor) {
                VanillaDepositModel model = ((VanillaDepositProcessor)this.activeProcessor).getVanillaModel();
                return model.getChance();
            }
            if (this.activeProcessor instanceof GeodeDepositProcessor) {
                GeodeDepositModel model = ((GeodeDepositProcessor)this.activeProcessor).getGeodeModel();
                return model.getChance();
            }
            if (this.activeProcessor instanceof SphereDepositProcessor) {
                SphereDepositModel model = ((SphereDepositProcessor)this.activeProcessor).getSphereModel();
                return model.getChance();
            }
            if (this.activeProcessor instanceof DenseDepositProcessor) {
                DenseDepositModel model = ((DenseDepositProcessor)this.activeProcessor).getDenseModel();
                return model.getChance();
            }
            if (this.activeProcessor instanceof DikeDepositProcessor) {
                DikeDepositModel model = ((DikeDepositProcessor)this.activeProcessor).getDikeModel();
                return model.getChance();
            }
            return -1;
        }

        private String stripString(String input) {
            int index = input.indexOf(":");
            if (index != -1) {
                input = input.substring(index + 1);
            }
            input = input.replaceAll("_", " ");
            String[] words = input.split(" ");
            StringBuilder sb = new StringBuilder();
            for (String word : words) {
                sb.append(Character.toUpperCase(word.charAt(0)));
                sb.append(word.substring(1));
                sb.append(" ");
            }
            input = sb.toString().trim();
            return input;
        }
    }
}

