/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.events;

import com.ridanisaurus.emendatusenigmatica.renderers.ArmorTextureRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="emendatusenigmatica", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ArmorTextureEvent {
    public static final ModelLayerLocation ARMOR = new ModelLayerLocation(new ResourceLocation("emendatusenigmatica", "layer_1"), "main");
    public static final ModelLayerLocation LEGS = new ModelLayerLocation(new ResourceLocation("emendatusenigmatica", "layer_2"), "main");

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171106_, (float)0.0f), (int)64, (int)32));
        event.registerLayerDefinition(LEGS, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)LayerDefinitions.f_171107_, (float)0.0f), (int)64, (int)32));
    }

    @SubscribeEvent
    public static void registerRenderLayers(EntityRenderersEvent.AddLayers event) {
        for (EntityRenderer entityRenderer : Minecraft.m_91087_().m_91290_().f_114362_.values()) {
            if (entityRenderer instanceof HumanoidMobRenderer) {
                HumanoidMobRenderer hmr = (HumanoidMobRenderer)entityRenderer;
                ArmorTextureEvent.addRenderLayer(hmr, event.getEntityModels());
                continue;
            }
            if (!(entityRenderer instanceof ArmorStandRenderer)) continue;
            ArmorStandRenderer asr = (ArmorStandRenderer)entityRenderer;
            ArmorTextureEvent.addRenderLayer(asr, event.getEntityModels());
        }
        for (String skin : event.getSkins()) {
            LivingEntityRenderer render = event.getSkin(skin);
            if (!(render instanceof PlayerRenderer)) continue;
            PlayerRenderer pr = (PlayerRenderer)render;
            ArmorTextureEvent.addRenderLayer(pr, event.getEntityModels());
        }
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addRenderLayer(LivingEntityRenderer<T, M> render, EntityModelSet models) {
        render.m_115326_(new ArmorTextureRenderer<T, M>(render, models));
    }
}

