/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class TagBuilder {
    private final List<String> tags = Lists.newArrayList();

    public TagBuilder tag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public TagBuilder tags(List<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    public void save(Consumer<IFinishedGenericJSON> consumer, ResourceLocation jsonResourceLocation) {
        consumer.accept(new Result(jsonResourceLocation, this.tags));
    }

    public class Result
    implements IFinishedGenericJSON {
        private final ResourceLocation id;
        private final List<String> tags;

        public Result(ResourceLocation id, List<String> tags) {
            this.id = id;
            this.tags = tags;
        }

        @Override
        public void serializeJSONData(JsonObject recipeJson) {
            if (this.tags.size() > 0) {
                JsonArray jsonarray = new JsonArray();
                for (String b : this.tags) {
                    jsonarray.add(b);
                }
                recipeJson.add("values", (JsonElement)jsonarray);
            }
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

