/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericRecipe;
import com.ridanisaurus.emendatusenigmatica.loader.parser.model.CompatModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeBuilder {
    private JsonItemBuilder result;
    private final String resultName;
    private String group;
    private String type;
    private final Map<String, String> fieldValueString = Maps.newLinkedHashMap();
    private final Map<String, Integer> fieldValueInt = Maps.newLinkedHashMap();
    private final Map<String, Float> fieldValueFloat = Maps.newLinkedHashMap();
    private final Map<String, Boolean> fieldValueBoolean = Maps.newLinkedHashMap();
    private final Map<String, ItemLike> fieldValueItem = Maps.newLinkedHashMap();
    private final Map<String, JsonItemBuilder> fieldValueJson = Maps.newLinkedHashMap();

    public RecipeBuilder(String resultName) {
        this.resultName = resultName;
        this.result = new JsonItemBuilder(false);
    }

    public RecipeBuilder fieldString(String key, String value) {
        if (this.fieldValueString.containsKey(key)) {
            throw new IllegalArgumentException("Field Key '" + key + "' is already defined!");
        }
        this.fieldValueString.put(key, value);
        return this;
    }

    public RecipeBuilder fieldInt(String key, int value) {
        if (this.fieldValueInt.containsKey(key)) {
            throw new IllegalArgumentException("Field Key '" + key + "' is already defined!");
        }
        this.fieldValueInt.put(key, value);
        return this;
    }

    public RecipeBuilder fieldFloat(String key, float value) {
        if (this.fieldValueFloat.containsKey(key)) {
            throw new IllegalArgumentException("Field Key '" + key + "' is already defined!");
        }
        this.fieldValueFloat.put(key, Float.valueOf(value));
        return this;
    }

    public RecipeBuilder fieldBoolean(String key, boolean value) {
        if (this.fieldValueBoolean.containsKey(key)) {
            throw new IllegalArgumentException("Field Key '" + key + "' is already defined!");
        }
        this.fieldValueBoolean.put(key, value);
        return this;
    }

    public RecipeBuilder fieldItem(String key, ItemLike value) {
        if (this.fieldValueItem.containsKey(key)) {
            throw new IllegalArgumentException("Field Key '" + key + "' is already defined!");
        }
        this.fieldValueItem.put(key, value);
        return this;
    }

    public RecipeBuilder fieldJson(String key, JsonItemBuilder builder) {
        if (this.fieldValueJson.containsKey(key)) {
            throw new IllegalArgumentException("Field Key '" + key + "' is already defined!");
        }
        this.fieldValueJson.put(key, builder);
        return this;
    }

    public RecipeBuilder addOutput(Consumer<JsonItemBuilder> output) {
        output.accept(this.result);
        return this;
    }

    public RecipeBuilder setResult(JsonItemBuilder result) {
        this.result = result;
        return this;
    }

    public RecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public RecipeBuilder type(String type) {
        this.type = type;
        return this;
    }

    public RecipeBuilder forceOutputArray(boolean force) {
        this.result.setForceArray(force);
        return this;
    }

    public void save(Consumer<IFinishedGenericRecipe> consumer, ResourceLocation recipeResourceLocation) {
        consumer.accept(new Result(recipeResourceLocation, this.resultName, this.result, this.group == null ? "" : this.group, this.type, this.fieldValueString, this.fieldValueInt, this.fieldValueFloat, this.fieldValueBoolean, this.fieldValueItem, this.fieldValueJson));
    }

    public static class JsonItemBuilder {
        private List<JsonObject> outputs = new ArrayList<JsonObject>();
        private boolean forceArray;

        public JsonItemBuilder(boolean forceArray) {
            this.forceArray = forceArray;
        }

        public JsonItemBuilder addOutput(Pair<String, Object> ... elements) {
            JsonObject object = new JsonObject();
            for (Pair<String, Object> element : elements) {
                if (element.getValue() instanceof Number) {
                    object.addProperty((String)element.getKey(), (Number)element.getValue());
                }
                if (element.getValue() instanceof String) {
                    object.addProperty((String)element.getKey(), (String)element.getValue());
                }
                if (element.getValue() instanceof Boolean) {
                    object.addProperty((String)element.getKey(), (Boolean)element.getValue());
                }
                if (element.getValue() instanceof Character) {
                    object.addProperty((String)element.getKey(), (Character)element.getValue());
                }
                if (!(element.getValue() instanceof Pair)) continue;
                object.add((String)element.getKey(), (JsonElement)JsonItemBuilder.parsePair((Pair)element.getValue()));
            }
            this.outputs.add(object);
            return this;
        }

        private static JsonObject parsePair(Pair<String, Object> ... elements) {
            JsonObject object = new JsonObject();
            for (Pair<String, Object> element : elements) {
                if (element.getValue() instanceof Number) {
                    object.addProperty((String)element.getKey(), (Number)element.getValue());
                }
                if (element.getValue() instanceof String) {
                    object.addProperty((String)element.getKey(), (String)element.getValue());
                }
                if (element.getValue() instanceof Boolean) {
                    object.addProperty((String)element.getKey(), (Boolean)element.getValue());
                }
                if (!(element.getValue() instanceof Character)) continue;
                object.addProperty((String)element.getKey(), (Character)element.getValue());
            }
            return object;
        }

        public JsonItemBuilder objectWithChance(String key, ItemLike itemProvider, int count, double chance) {
            return this.addOutput(Pair.of((Object)key, (Object)Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemProvider.m_5456_()).toString())), Pair.of((Object)"count", (Object)count), Pair.of((Object)"chance", (Object)chance));
        }

        public JsonItemBuilder stackWithChance(ItemLike itemProvider, int count, double chance) {
            return this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemProvider.m_5456_()).toString()), Pair.of((Object)"count", (Object)count), Pair.of((Object)"chance", (Object)chance));
        }

        public JsonItemBuilder stackWithCount(ItemLike itemProvider, int count) {
            return this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemProvider.m_5456_()).toString()), Pair.of((Object)"count", (Object)count));
        }

        public JsonItemBuilder stackWithoutCount(ItemLike itemProvider, float chance) {
            return this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemProvider.m_5456_()).toString()), Pair.of((Object)"chance", (Object)Float.valueOf(chance)));
        }

        public JsonItemBuilder stacks(List<CompatModel.CompatIOModel> ioList) {
            for (CompatModel.CompatIOModel io : ioList) {
                String item = io.getItem();
                int count = io.getCount();
                float chance = io.getChance();
                ItemLike itemLike = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
                this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_()).toString()), Pair.of((Object)"count", (Object)count), Pair.of((Object)"chance", (Object)Float.valueOf(chance)));
            }
            return this;
        }

        public JsonItemBuilder stacksWithCombinedChance(List<CompatModel.CompatIOModel> ioList) {
            for (CompatModel.CompatIOModel io : ioList) {
                String item = io.getItem();
                int count = io.getCount();
                float chance = io.getChance();
                ItemLike itemLike = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
                this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_()).toString()), Pair.of((Object)"chance", (Object)Float.valueOf((float)count + chance)));
            }
            return this;
        }

        public JsonItemBuilder stacksWithCount(List<CompatModel.CompatIOModel> ioList) {
            for (CompatModel.CompatIOModel io : ioList) {
                String item = io.getItem();
                int count = io.getCount();
                ItemLike itemLike = (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
                this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_()).toString()), Pair.of((Object)"count", (Object)count));
            }
            return this;
        }

        public JsonItemBuilder stack(ItemLike itemProvider) {
            return this.addOutput(Pair.of((Object)"item", (Object)ForgeRegistries.ITEMS.getKey((Object)itemProvider.m_5456_()).toString()));
        }

        public JsonItemBuilder tagWithChance(TagKey<Item> itemTag, int count, double chance) {
            return this.addOutput(Pair.of((Object)"tag", (Object)(itemTag.f_203868_().m_135827_() + ":" + itemTag.f_203868_().m_135815_())), Pair.of((Object)"count", (Object)count), Pair.of((Object)"chance", (Object)chance));
        }

        public JsonItemBuilder tagWithCount(TagKey<Item> itemTag, int count) {
            return this.addOutput(Pair.of((Object)"tag", (Object)(itemTag.f_203868_().m_135827_() + ":" + itemTag.f_203868_().m_135815_())), Pair.of((Object)"count", (Object)count));
        }

        public JsonItemBuilder tag(TagKey<Item> itemTag) {
            return this.addOutput(Pair.of((Object)"tag", (Object)(itemTag.f_203868_().m_135827_() + ":" + itemTag.f_203868_().m_135815_())));
        }

        public JsonElement getOutput() {
            if (this.outputs.size() > 1 || this.forceArray) {
                JsonArray array = new JsonArray();
                this.outputs.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return array;
            }
            return (JsonElement)this.outputs.get(0);
        }

        public void setForceArray(boolean forceArray) {
            this.forceArray = forceArray;
        }
    }

    public class Result
    implements IFinishedGenericRecipe {
        private final ResourceLocation id;
        private final JsonItemBuilder result;
        private final String resultName;
        private final String group;
        private final String type;
        private final Map<String, String> fieldValueString;
        private final Map<String, Integer> fieldValueInt;
        private final Map<String, Float> fieldValueFloat;
        private final Map<String, Boolean> fieldValueBoolean;
        private final Map<String, ItemLike> fieldValueItem;
        private final Map<String, JsonItemBuilder> fieldValueJson;

        public Result(ResourceLocation id, String resultName, JsonItemBuilder outputBuilder, String group, String type, Map<String, String> fieldValueString, Map<String, Integer> fieldValueInt, Map<String, Float> fieldValueFloat, Map<String, Boolean> fieldValueBoolean, Map<String, ItemLike> fieldValueItem, Map<String, JsonItemBuilder> fieldValueJson) {
            this.id = id;
            this.resultName = resultName;
            this.group = group;
            this.type = type;
            this.result = outputBuilder;
            this.fieldValueString = fieldValueString;
            this.fieldValueInt = fieldValueInt;
            this.fieldValueFloat = fieldValueFloat;
            this.fieldValueBoolean = fieldValueBoolean;
            this.fieldValueItem = fieldValueItem;
            this.fieldValueJson = fieldValueJson;
        }

        @Override
        public void serializeRecipeData(JsonObject recipeJson) {
            if (!this.group.isEmpty()) {
                recipeJson.addProperty("group", this.group);
            }
            if (!this.type.isEmpty()) {
                recipeJson.addProperty("type", this.type);
            }
            recipeJson.add(this.resultName, this.result.getOutput());
            if (!this.fieldValueString.isEmpty()) {
                for (Map.Entry<String, String> entry : this.fieldValueString.entrySet()) {
                    recipeJson.addProperty(entry.getKey(), entry.getValue());
                }
            }
            if (!this.fieldValueInt.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.fieldValueInt.entrySet()) {
                    recipeJson.addProperty(entry.getKey(), (Number)entry.getValue());
                }
            }
            if (!this.fieldValueFloat.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.fieldValueFloat.entrySet()) {
                    recipeJson.addProperty(entry.getKey(), (Number)entry.getValue());
                }
            }
            if (!this.fieldValueBoolean.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.fieldValueBoolean.entrySet()) {
                    recipeJson.addProperty(entry.getKey(), (Boolean)entry.getValue());
                }
            }
            if (!this.fieldValueItem.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.fieldValueItem.entrySet()) {
                    recipeJson.addProperty(entry.getKey(), ForgeRegistries.ITEMS.getKey((Object)((ItemLike)entry.getValue()).m_5456_()).toString());
                }
            }
            if (!this.fieldValueJson.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.fieldValueJson.entrySet()) {
                    recipeJson.add(entry.getKey(), ((JsonItemBuilder)entry.getValue()).getOutput());
                }
            }
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

