/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ItemModelBuilder {
    private final String parent;
    private final Map<String, String> textures = Maps.newLinkedHashMap();
    private boolean applyTint = false;
    private String fluid;
    private String loader;
    private List<OverrideBuilder> overrides = new ArrayList<OverrideBuilder>();

    public ItemModelBuilder(String parent) {
        this.parent = parent;
    }

    public ItemModelBuilder texture(String textureKey, String textureValue) {
        this.textures.put(textureKey, textureValue);
        return this;
    }

    public ItemModelBuilder applyTint(boolean tint) {
        this.applyTint = tint;
        return this;
    }

    public ItemModelBuilder fluid(String fluid) {
        this.fluid = fluid;
        return this;
    }

    public ItemModelBuilder loader(String loader) {
        this.loader = loader;
        return this;
    }

    public OverrideBuilder override() {
        OverrideBuilder ret = new OverrideBuilder();
        this.overrides.add(ret);
        return ret;
    }

    public OverrideBuilder override(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.overrides.size(), (String)"override");
        return this.overrides.get(index);
    }

    public void save(Consumer<IFinishedGenericJSON> consumer, ResourceLocation jsonResourceLocation) {
        consumer.accept(new Result(jsonResourceLocation, this.parent, this.textures, this.applyTint, this.fluid, this.loader, this.overrides));
    }

    public class OverrideBuilder {
        private ResourceLocation model;
        private final Map<ResourceLocation, Float> predicates = new LinkedHashMap<ResourceLocation, Float>();

        public OverrideBuilder model(ResourceLocation model) {
            this.model = model;
            return this;
        }

        public OverrideBuilder predicate(ResourceLocation key, float value) {
            this.predicates.put(key, Float.valueOf(value));
            return this;
        }

        public ItemModelBuilder end() {
            return ItemModelBuilder.this;
        }

        JsonObject toJson() {
            JsonObject ret = new JsonObject();
            JsonObject predicatesJson = new JsonObject();
            this.predicates.forEach((key, val) -> predicatesJson.addProperty(key.toString(), (Number)val));
            ret.add("predicate", (JsonElement)predicatesJson);
            ret.addProperty("model", this.model.toString());
            return ret;
        }
    }

    public class Result
    implements IFinishedGenericJSON {
        private final ResourceLocation id;
        private final String parent;
        private final Map<String, String> textures;
        private final boolean applyTint;
        private final String fluid;
        private final String loader;
        private final List<OverrideBuilder> overrides;

        public Result(ResourceLocation id, String parent, Map<String, String> textures, @Nullable boolean applyTint, @Nullable String fluid, String loader, List<OverrideBuilder> overrides) {
            this.id = id;
            this.parent = parent;
            this.textures = textures;
            this.applyTint = applyTint;
            this.fluid = fluid;
            this.loader = loader;
            this.overrides = overrides;
        }

        @Override
        public void serializeJSONData(JsonObject json) {
            if (!this.parent.isEmpty()) {
                json.addProperty("parent", this.parent);
            }
            if (!this.textures.isEmpty()) {
                JsonObject texturesObject = new JsonObject();
                for (Map.Entry<String, String> e : this.textures.entrySet()) {
                    texturesObject.addProperty(e.getKey(), e.getValue());
                }
                json.add("textures", (JsonElement)texturesObject);
            }
            if (this.applyTint) {
                json.addProperty("apply_tint", Boolean.valueOf(true));
            }
            if (this.fluid != null) {
                json.addProperty("fluid", this.fluid);
            }
            if (this.loader != null) {
                json.addProperty("loader", this.loader);
            }
            if (!this.overrides.isEmpty()) {
                JsonArray overridesJson = new JsonArray();
                this.overrides.stream().map(OverrideBuilder::toJson).forEach(arg_0 -> ((JsonArray)overridesJson).add(arg_0));
                json.add("overrides", (JsonElement)overridesJson);
            }
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

