/*
 * Decompiled with CFR 0.152.
 */
package com.ridanisaurus.emendatusenigmatica.datagen.base;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ridanisaurus.emendatusenigmatica.datagen.base.IFinishedGenericJSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class FluidModelBuilder {
    private final Map<String, objectBuilder> textures = Maps.newLinkedHashMap();

    public FluidModelBuilder textures(objectBuilder builder) {
        this.textures.put("textures", builder);
        return this;
    }

    public void save(Consumer<IFinishedGenericJSON> consumer, ResourceLocation resourceLocation) {
        consumer.accept(new Result(resourceLocation, this.textures));
    }

    public class Result
    implements IFinishedGenericJSON {
        private final ResourceLocation id;
        private final Map<String, objectBuilder> fieldValueJson;

        public Result(ResourceLocation id, Map<String, objectBuilder> fieldValueJson) {
            this.id = id;
            this.fieldValueJson = fieldValueJson;
        }

        @Override
        public void serializeJSONData(JsonObject json) {
            if (!this.fieldValueJson.isEmpty()) {
                for (Map.Entry<String, objectBuilder> entry : this.fieldValueJson.entrySet()) {
                    json.add(entry.getKey(), entry.getValue().getOutput());
                }
            }
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }

    public static class objectBuilder {
        private List<JsonObject> jsonObject = new ArrayList<JsonObject>();
        private boolean forceArray;

        public objectBuilder(boolean forceArray) {
            this.forceArray = forceArray;
        }

        public objectBuilder addObject(Pair<String, Object> ... elements) {
            JsonObject object = new JsonObject();
            for (Pair<String, Object> element : elements) {
                if (!(element.getValue() instanceof String)) continue;
                object.addProperty((String)element.getKey(), (String)element.getValue());
            }
            this.jsonObject.add(object);
            return this;
        }

        public objectBuilder particle(String pairValue) {
            return this.addObject(Pair.of((Object)"particle", (Object)pairValue));
        }

        public JsonElement getOutput() {
            if (this.jsonObject.size() > 1 || this.forceArray) {
                JsonArray array = new JsonArray();
                this.jsonObject.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return array;
            }
            return (JsonElement)this.jsonObject.get(0);
        }
    }
}

